/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.baderlab.csplugins.enrichmentmap.HeatMapTableModel;
import org.baderlab.csplugins.enrichmentmap.HyperLinkOut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeatMapTableActionListener
implements MouseListener {
    private JTable jtable;
    private HeatMapTableModel model;
    private JPopupMenu rightClickPopupMenu;
    private Map<String, Map<String, String>> linkoutProps;
    static final String MAC_OS_ID = "mac";

    public HeatMapTableActionListener(JTable jtable, HeatMapTableModel model, JPopupMenu rightClickPopupMenu, Map<String, Map<String, String>> linkoutProps) {
        this.jtable = jtable;
        this.model = model;
        this.linkoutProps = linkoutProps;
        this.rightClickPopupMenu = rightClickPopupMenu;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int column = this.jtable.getColumnModel().getColumnIndexAtX(e.getX());
        int row = e.getY() / this.jtable.getRowHeight();
        Object value = this.jtable.getValueAt(row, column);
        if ((SwingUtilities.isRightMouseButton(e) || this.isMacPlatform() && e.isControlDown()) && value != null) {
            if (this.rightClickPopupMenu.getComponentCount() > 0) {
                this.rightClickPopupMenu.remove(this.rightClickPopupMenu.getComponentCount() - 1);
            }
            if (column == 0 || column == 1) {
                this.rightClickPopupMenu.add(new HyperLinkOut(value.toString(), this.linkoutProps));
            } else {
                this.rightClickPopupMenu.add(new JMenuItem(this.model.getExpValueAt(row, column).toString()));
            }
            this.rightClickPopupMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    private boolean isMacPlatform() {
        String os = System.getProperty("os.name");
        return os.regionMatches(true, 0, MAC_OS_ID, 0, MAC_OS_ID.length());
    }
}

