/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.data.readers.TextFileReader;
import cytoscape.util.FileUtil;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.HashMap;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToolTip;
import org.baderlab.csplugins.enrichmentmap.BuildBulkEnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.CollapsiblePanel;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.JMultiLineToolTip;

public class BulkEMCreationPanel
extends JPanel {
    private static final long serialVersionUID = 7233557042420194604L;
    private EnrichmentMapParameters params = new EnrichmentMapParameters();
    private JFormattedTextField GSEAResultsDirTextField;
    private JFormattedTextField GMTDirectoryTextField;
    private JFormattedTextField GCTDirectoryTextField;
    private JFormattedTextField pvalueTextField;
    private JFormattedTextField qvalueTextField;
    private JFormattedTextField coeffecientTextField;
    private JFormattedTextField lowerLimitField;
    private JFormattedTextField upperLimitField;
    private JRadioButton overlap;
    private JRadioButton jaccard;
    private JRadioButton combined;
    DecimalFormat decFormat;
    NumberFormat numFormat;
    private int defaultColumns = 15;

    public BulkEMCreationPanel() {
        CollapsiblePanel OptionsPanel = this.createOptionsPanel();
        OptionsPanel.setCollapsed(false);
        JPanel advancedOptionsContainer = new JPanel(new BorderLayout());
        advancedOptionsContainer.add((Component)OptionsPanel, "Center");
        JPanel bottomPanel = this.createBottomPanel();
        this.add((Component)advancedOptionsContainer, "Center");
        this.add((Component)bottomPanel, "South");
    }

    private CollapsiblePanel createOptionsPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("User Input");
        JPanel panel = new JPanel();
        panel.setLayout(new BoxLayout(panel, 1));
        CollapsiblePanel GMTcollapsiblePanel = this.createGMTPanel();
        GMTcollapsiblePanel.setCollapsed(false);
        CollapsiblePanel ParametersPanel2 = this.createParametersPanel();
        ParametersPanel2.setCollapsed(false);
        CollapsiblePanel GMTDirPanel = this.createDiffGMTGCTDirectory();
        GMTDirPanel.setCollapsed(true);
        panel.add(GMTcollapsiblePanel);
        panel.add(ParametersPanel2);
        panel.add(GMTDirPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createDiffGMTGCTDirectory() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Advanced");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("Directory containing GMT file:"){
            private static final long serialVersionUID = -122741876830022713L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGMTDirButton = new JButton();
        this.GMTDirectoryTextField = new JFormattedTextField();
        this.GMTDirectoryTextField.setColumns(this.defaultColumns);
        this.GMTDirectoryTextField.setFont(new Font("Dialog", 1, 10));
        this.GMTDirectoryTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTDirButton.setText("...");
        selectGMTDirButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGMTDirButtonActionPerformed(evt);
            }
        });
        JPanel newGMTDirPanel = new JPanel();
        newGMTDirPanel.setLayout(new BorderLayout());
        newGMTDirPanel.add((Component)GMTLabel, "West");
        newGMTDirPanel.add((Component)this.GMTDirectoryTextField, "Center");
        newGMTDirPanel.add((Component)selectGMTDirButton, "East");
        panel.add(newGMTDirPanel);
        JLabel GCTLabel = new JLabel("Directory containing GCT file:"){
            private static final long serialVersionUID = -122741876830022713L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGCTDirButton = new JButton();
        this.GCTDirectoryTextField = new JFormattedTextField();
        this.GCTDirectoryTextField.setColumns(this.defaultColumns);
        this.GCTDirectoryTextField.setFont(new Font("Dialog", 1, 10));
        this.GCTDirectoryTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGCTDirButton.setText("...");
        selectGCTDirButton.setMargin(new Insets(0, 0, 0, 0));
        selectGCTDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGCTDirButtonActionPerformed(evt);
            }
        });
        JPanel newGCTDirPanel = new JPanel();
        newGCTDirPanel.setLayout(new BorderLayout());
        newGCTDirPanel.add((Component)GCTLabel, "West");
        newGCTDirPanel.add((Component)this.GCTDirectoryTextField, "Center");
        newGCTDirPanel.add((Component)selectGCTDirButton, "East");
        panel.add(newGCTDirPanel);
        JLabel lowerlimitLabel = new JLabel("Lower limit:");
        this.lowerLimitField = new JFormattedTextField(this.numFormat);
        this.lowerLimitField.setColumns(3);
        this.lowerLimitField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String lowerTip = "Sets the lower limit \nof the directory number you want to  \nuse when creating networks.";
        this.lowerLimitField.setToolTipText(lowerTip);
        this.lowerLimitField.setText("1");
        this.lowerLimitField.setValue(1);
        JPanel lowerLimitPanel = new JPanel();
        lowerLimitPanel.setLayout(new BorderLayout());
        lowerLimitPanel.setToolTipText(lowerTip);
        lowerLimitPanel.add((Component)lowerlimitLabel, "West");
        lowerLimitPanel.add((Component)this.lowerLimitField, "East");
        JLabel upperlimitLabel = new JLabel("Upper limit:");
        this.upperLimitField = new JFormattedTextField(this.numFormat);
        this.upperLimitField.setColumns(3);
        this.upperLimitField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String upperTip = "Sets the upper limit \nof the directory number you want to  \nuse when creating networks.";
        this.upperLimitField.setToolTipText(upperTip);
        this.upperLimitField.setText("1");
        this.upperLimitField.setValue(1);
        JPanel upperLimitPanel = new JPanel();
        upperLimitPanel.setLayout(new BorderLayout());
        upperLimitPanel.setToolTipText(upperTip);
        upperLimitPanel.add((Component)upperlimitLabel, "West");
        upperLimitPanel.add((Component)this.upperLimitField, "East");
        panel.add(lowerLimitPanel);
        panel.add(upperLimitPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createGMTPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Gene Sets");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel GMTLabel = new JLabel("GSEA Results directory:"){
            private static final long serialVersionUID = -122741876830022713L;

            public JToolTip createToolTip() {
                return new JMultiLineToolTip();
            }
        };
        JButton selectGMTFileButton = new JButton();
        this.GSEAResultsDirTextField = new JFormattedTextField();
        this.GSEAResultsDirTextField.setColumns(this.defaultColumns);
        this.GSEAResultsDirTextField.setFont(new Font("Dialog", 1, 10));
        this.GSEAResultsDirTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        selectGMTFileButton.setText("...");
        selectGMTFileButton.setMargin(new Insets(0, 0, 0, 0));
        selectGMTFileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectGMTFileButtonActionPerformed(evt);
            }
        });
        JPanel newGMTPanel = new JPanel();
        newGMTPanel.setLayout(new BorderLayout());
        newGMTPanel.add((Component)GMTLabel, "West");
        newGMTPanel.add((Component)this.GSEAResultsDirTextField, "Center");
        newGMTPanel.add((Component)selectGMTFileButton, "East");
        if (!this.params.getMethod().equalsIgnoreCase("DAVID/BiNGO")) {
            panel.add(newGMTPanel);
        }
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        return collapsiblePanel;
    }

    private CollapsiblePanel createParametersPanel() {
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel("Parameters");
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(0, 1));
        JLabel pvalueCutOffLabel = new JLabel("P-value Cutoff");
        this.pvalueTextField = new JFormattedTextField(this.decFormat);
        this.pvalueTextField.setColumns(3);
        this.pvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String pvalueCutOffTip = "Sets the p-value cutoff \nonly genesets with a p-value less than \nthe cutoff will be included.";
        this.pvalueTextField.setToolTipText(pvalueCutOffTip);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        JPanel pvalueCutOffPanel = new JPanel();
        pvalueCutOffPanel.setLayout(new BorderLayout());
        pvalueCutOffPanel.setToolTipText(pvalueCutOffTip);
        pvalueCutOffPanel.add((Component)pvalueCutOffLabel, "West");
        pvalueCutOffPanel.add((Component)this.pvalueTextField, "East");
        JLabel qvalueCutOffLabel = new JLabel("FDR Q-value Cutoff");
        this.qvalueTextField = new JFormattedTextField(this.decFormat);
        this.qvalueTextField.setColumns(3);
        this.qvalueTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String qvalueCutOffTip = "Sets the FDR q-value cutoff \nonly genesets with a FDR q-value less than \nthe cutoff will be included.";
        this.qvalueTextField.setToolTipText(qvalueCutOffTip);
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.qvalueTextField.setValue(this.params.getQvalue());
        JPanel qvalueCutOffPanel = new JPanel();
        qvalueCutOffPanel.setLayout(new BorderLayout());
        qvalueCutOffPanel.setToolTipText(qvalueCutOffTip);
        qvalueCutOffPanel.add((Component)qvalueCutOffLabel, "West");
        qvalueCutOffPanel.add((Component)this.qvalueTextField, "East");
        this.jaccard = new JRadioButton("Jaccard Coeffecient");
        this.jaccard.setActionCommand("jaccard");
        this.jaccard.setSelected(true);
        this.overlap = new JRadioButton("Overlap Coeffecient");
        this.overlap.setActionCommand("overlap");
        this.combined = new JRadioButton("Jaccard+Overlap Combined");
        this.combined.setActionCommand("combined");
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
        ButtonGroup jaccardOrOverlap = new ButtonGroup();
        jaccardOrOverlap.add(this.jaccard);
        jaccardOrOverlap.add(this.overlap);
        jaccardOrOverlap.add(this.combined);
        this.jaccard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.overlap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        this.combined.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.selectJaccardOrOverlapActionPerformed(evt);
            }
        });
        JPanel index_buttons = new JPanel();
        index_buttons.setLayout(new BorderLayout());
        index_buttons.add((Component)this.jaccard, "North");
        index_buttons.add((Component)this.overlap, "South");
        JLabel coeffecientCutOffLabel = new JLabel("Cutoff");
        this.coeffecientTextField = new JFormattedTextField(this.decFormat);
        this.coeffecientTextField.setColumns(3);
        this.coeffecientTextField.addPropertyChangeListener("value", new FormattedTextFieldAction());
        String coeffecientCutOffTip = "Sets the Jaccard or Overlap coeffecient cutoff \nonly edges with a Jaccard or Overlap coffecient less than \nthe cutoff will be added.";
        this.coeffecientTextField.setToolTipText(coeffecientCutOffTip);
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.params.setSimilarityCutOffChanged(false);
        JPanel coeffecientCutOffPanel = new JPanel();
        coeffecientCutOffPanel.setLayout(new BorderLayout());
        coeffecientCutOffPanel.setToolTipText(coeffecientCutOffTip);
        coeffecientCutOffPanel.add((Component)index_buttons, "West");
        coeffecientCutOffPanel.add((Component)coeffecientCutOffLabel, "Center");
        coeffecientCutOffPanel.add((Component)this.coeffecientTextField, "East");
        panel.add(pvalueCutOffPanel);
        panel.add(qvalueCutOffPanel);
        collapsiblePanel.getContentPane().add((Component)panel, "North");
        collapsiblePanel.getContentPane().add((Component)coeffecientCutOffPanel, "South");
        return collapsiblePanel;
    }

    public Color checkFile(String filename) {
        File tempfile;
        if (filename != null && !(tempfile = new File(filename)).canRead()) {
            return Color.RED;
        }
        return Color.BLACK;
    }

    public void populateFieldsFromRpt(File rptFile) {
        String filename;
        File temp;
        TextFileReader reader = new TextFileReader(rptFile.getAbsolutePath());
        reader.read();
        String fullText = reader.getText();
        HashMap<String, String> rpt = new HashMap<String, String>();
        String[] lines = fullText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length == 2) {
                rpt.put(tokens[0], tokens[1]);
                continue;
            }
            if (tokens.length != 3) continue;
            rpt.put(tokens[0] + " " + tokens[1], tokens[2]);
        }
        String timestamp = (String)rpt.get("producer_timestamp");
        String method = (String)rpt.get("producer_class");
        method = method.split("\\p{Punct}")[2];
        String out_dir = (String)rpt.get("param out");
        String job_dir_name = null;
        String data = (String)rpt.get("param res");
        String label = (String)rpt.get("param rpt_label");
        String classes = (String)rpt.get("param cls");
        String gmt = (String)rpt.get("param gmx");
        String gmt_nopath = gmt.substring(gmt.lastIndexOf(File.separator) + 1, gmt.length() - 1);
        String gseaHtmlReportFile = (String)rpt.get("file");
        String phenotype1 = "na";
        String phenotype2 = "na";
        if (classes != null && method.equalsIgnoreCase("Gsea")) {
            String[] classes_split = classes.split("#");
            String phenotypes = classes_split[1];
            String[] phenotypes_split = phenotypes.split("_versus_");
            phenotype1 = phenotypes_split[0];
            phenotype2 = phenotypes_split[1];
            this.params.setClassFile1(classes_split[0]);
            this.params.setDataset1Phenotype1(phenotype1);
            this.params.setDataset1Phenotype2(phenotype2);
        } else if (method.equalsIgnoreCase("GseaPreranked")) {
            data = (String)rpt.get("param rnk");
            phenotype1 = "na_pos";
            phenotype2 = "na_neg";
            this.params.setDataset1Phenotype1(phenotype1);
            this.params.setDataset1Phenotype2(phenotype2);
        } else {
            JOptionPane.showMessageDialog(this, "The class field in the rpt file has been modified or doesn't specify a class file\n but the analysis is a classic GSEA not PreRanked.  ");
        }
        String results1 = "";
        String results2 = "";
        String ranks = "";
        job_dir_name = label + "." + method + "." + timestamp;
        results1 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
        results2 = "" + out_dir + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
        ranks = "" + out_dir + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
        if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
            String out_dir_new = rptFile.getAbsolutePath();
            out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator));
            if (!(out_dir_new = out_dir_new.substring(0, out_dir_new.lastIndexOf(File.separator))).equalsIgnoreCase(out_dir)) {
                results1 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                results2 = out_dir_new + File.separator + job_dir_name + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                ranks = out_dir_new + File.separator + job_dir_name + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                if (this.checkFile(results1) != Color.BLACK || this.checkFile(results2) != Color.BLACK || this.checkFile(ranks) != Color.BLACK) {
                    results1 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype1 + "_" + timestamp + ".xls";
                    results2 = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "gsea_report_for_" + phenotype2 + "_" + timestamp + ".xls";
                    ranks = "" + out_dir + File.separator + job_dir_name + File.separator + label + "." + method + "." + timestamp + File.separator + "ranked_gene_list_" + phenotype1 + "_versus_" + phenotype2 + "_" + timestamp + ".xls";
                } else {
                    out_dir = out_dir_new;
                    gseaHtmlReportFile = "" + out_dir + File.separator + job_dir_name + File.separator + "index.html";
                }
            }
        }
        if (this.params.getGMTDirName() != null) {
            temp = new File(gmt);
            filename = temp.getName();
            gmt = this.params.getGMTDirName() + File.separator + filename;
        }
        if (this.params.getGCTDirName() != null) {
            temp = new File(data);
            filename = temp.getName();
            data = this.params.getGCTDirName() + File.separator + filename;
        }
        this.params.setGMTFileName(gmt);
        this.params.setExpressionFileName1(data);
        this.params.setData(true);
        this.params.setDataset1RankedFile(ranks);
        this.params.setEnrichmentDataset1FileName1(results1);
        this.params.setEnrichmentDataset1FileName2(results2);
        this.params.setGseaHtmlReportFileDataset1(gseaHtmlReportFile);
    }

    private void selectJaccardOrOverlapActionPerformed(ActionEvent evt) {
        if (evt.getActionCommand().equalsIgnoreCase("jaccard")) {
            this.params.setSimilarityMetric("JACCARD");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("overlap")) {
            this.params.setSimilarityMetric("OVERLAP");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else if (evt.getActionCommand().equalsIgnoreCase("combined")) {
            this.params.setSimilarityMetric("COMBINED");
            if (!this.params.isSimilarityCutOffChanged()) {
                this.params.setSimilarityCutOff(this.params.getDefaultOverlapCutOff() * this.params.getCombinedConstant() + (1.0 - this.params.getCombinedConstant()) * this.params.getDefaultJaccardCutOff());
                this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
                this.params.setSimilarityCutOffChanged(false);
            }
        } else {
            JOptionPane.showMessageDialog(this, "Invalid Jaccard Radio Button action command");
        }
    }

    private void selectGMTFileButtonActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"Import GSEA results directory", (int)FileUtil.LOAD);
        if (file != null) {
            this.GSEAResultsDirTextField.setText(file.getParent());
            this.params.setGSEAResultsDirName(file.getParent());
        }
    }

    private void selectGMTDirButtonActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"GMT directory", (int)FileUtil.LOAD);
        if (file != null) {
            this.GMTDirectoryTextField.setText(file.getParent());
            this.params.setGMTDirName(file.getParent());
        }
    }

    private void selectGCTDirButtonActionPerformed(ActionEvent evt) {
        File file = FileUtil.getFile((String)"GCT directory", (int)FileUtil.LOAD);
        if (file != null) {
            this.GCTDirectoryTextField.setText(file.getParent());
            this.params.setGCTDirName(file.getParent());
        }
    }

    private JPanel createBottomPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton closeButton = new JButton();
        JButton importButton = new JButton();
        JButton resetButton = new JButton("Reset");
        resetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.resetPanel();
            }
        });
        closeButton.setText("Close");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BulkEMCreationPanel.this.cancelButtonActionPerformed(evt);
            }
        });
        importButton.setText("Build");
        importButton.addActionListener(new BuildBulkEnrichmentMapActionListener(this));
        importButton.setEnabled(true);
        panel.add(resetButton);
        panel.add(closeButton);
        panel.add(importButton);
        return panel;
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setInputWindow(null);
        cytoPanel.remove((Component)this);
    }

    public void close() {
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(7);
        EnrichmentMapManager.getInstance().setInputWindow(null);
        cytoPanel.remove((Component)this);
    }

    private void resetPanel() {
        this.params = new EnrichmentMapParameters();
        this.GSEAResultsDirTextField.setText("");
        this.GSEAResultsDirTextField.setToolTipText(null);
        this.pvalueTextField.setText(Double.toString(this.params.getPvalue()));
        this.qvalueTextField.setText(Double.toString(this.params.getQvalue()));
        this.coeffecientTextField.setText(Double.toString(this.params.getSimilarityCutOff()));
        this.pvalueTextField.setValue(this.params.getPvalue());
        this.qvalueTextField.setValue(this.params.getQvalue());
        this.coeffecientTextField.setValue(this.params.getSimilarityCutOff());
        this.params.setSimilarityCutOffChanged(false);
        if (this.params.getSimilarityMetric().equalsIgnoreCase("JACCARD")) {
            this.jaccard.setSelected(true);
            this.overlap.setSelected(false);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("OVERLAP")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(true);
            this.combined.setSelected(false);
        } else if (this.params.getSimilarityMetric().equalsIgnoreCase("COMBINED")) {
            this.jaccard.setSelected(false);
            this.overlap.setSelected(false);
            this.combined.setSelected(true);
        }
    }

    public EnrichmentMapParameters getParams() {
        return this.params;
    }

    public void setParams(EnrichmentMapParameters params) {
        this.params = params;
    }

    private class FormattedTextFieldAction
    implements PropertyChangeListener {
        private FormattedTextFieldAction() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            JFormattedTextField source = (JFormattedTextField)e.getSource();
            String message = "The value you have entered is invalid.\n";
            boolean invalid = false;
            if (source == BulkEMCreationPanel.this.pvalueTextField) {
                Number value = (Number)BulkEMCreationPanel.this.pvalueTextField.getValue();
                if (value != null && value.doubleValue() > 0.0 && value.doubleValue() <= 1.0) {
                    BulkEMCreationPanel.this.params.setPvalue(value.doubleValue());
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getPvalue());
                    message = message + "The pvalue cutoff must be greater than or equal 0 and less than or equal to 1.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.qvalueTextField) {
                Number value = (Number)BulkEMCreationPanel.this.qvalueTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 100.0) {
                    BulkEMCreationPanel.this.params.setQvalue(value.doubleValue());
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getQvalue());
                    message = message + "The FDR q-value cutoff must be between 0 and 100.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.coeffecientTextField) {
                Number value = (Number)BulkEMCreationPanel.this.coeffecientTextField.getValue();
                if (value != null && value.doubleValue() >= 0.0 && value.doubleValue() <= 1.0) {
                    BulkEMCreationPanel.this.params.setSimilarityCutOff(value.doubleValue());
                    BulkEMCreationPanel.this.params.setSimilarityCutOffChanged(true);
                } else {
                    source.setValue(BulkEMCreationPanel.this.params.getSimilarityCutOff());
                    message = message + "The Overlap/Jaccard Coeffecient cutoff must be between 0 and 1.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.lowerLimitField) {
                Number value = (Number)BulkEMCreationPanel.this.lowerLimitField.getValue();
                if (value != null && value.intValue() >= 0) {
                    BulkEMCreationPanel.this.params.setLowerlimit(value.intValue());
                } else {
                    source.setValue("1");
                    message = message + "The lower limit must be greater than 0.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.upperLimitField) {
                Number value = (Number)BulkEMCreationPanel.this.upperLimitField.getValue();
                if (value != null && value.intValue() >= 0) {
                    BulkEMCreationPanel.this.params.setUpperlimit(value.intValue());
                } else {
                    source.setValue("1");
                    message = message + "The upper limit must be greater than 0.";
                    invalid = true;
                }
            } else if (source == BulkEMCreationPanel.this.GSEAResultsDirTextField) {
                String value = BulkEMCreationPanel.this.GSEAResultsDirTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGSEAResultsDirName(value);
                } else if (!BulkEMCreationPanel.this.GSEAResultsDirTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "File name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GSEAResultsDirTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.setGMTFileName(value);
                    }
                }
            } else if (source == BulkEMCreationPanel.this.GMTDirectoryTextField) {
                String value = BulkEMCreationPanel.this.GMTDirectoryTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGMTDirName(value);
                } else if (!BulkEMCreationPanel.this.GMTDirectoryTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Directory name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GMTDirectoryTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.setGMTFileName(value);
                    }
                }
            } else if (source == BulkEMCreationPanel.this.GCTDirectoryTextField) {
                String value = BulkEMCreationPanel.this.GCTDirectoryTextField.getText();
                if (value.equalsIgnoreCase("")) {
                    BulkEMCreationPanel.this.params.setGCTDirName(value);
                } else if (!BulkEMCreationPanel.this.GCTDirectoryTextField.getText().equalsIgnoreCase((String)e.getOldValue())) {
                    if (BulkEMCreationPanel.this.checkFile(value).equals(Color.RED)) {
                        JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Directory name change entered is not a valid file name", 2);
                        BulkEMCreationPanel.this.GCTDirectoryTextField.setForeground(BulkEMCreationPanel.this.checkFile(value));
                    } else {
                        BulkEMCreationPanel.this.params.setGMTFileName(value);
                    }
                }
            }
            if (invalid) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), message, "Parameter out of bounds", 2);
            }
        }
    }
}

