/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CytoscapeInit;
import giny.model.Edge;
import giny.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.SliderBarPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapParameters {
    private String NetworkName = null;
    private String attributePrefix;
    private String GMTFileName;
    private String GMTDirName = null;
    private String GCTDirName = null;
    private String GSEAResultsDirName = null;
    private int lowerlimit = 1;
    private int upperlimit = 1;
    private String expressionFileName1;
    private String expressionFileName2;
    private String enrichmentDataset1FileName1;
    private String enrichmentDataset1FileName2;
    private String enrichmentDataset2FileName1;
    private String enrichmentDataset2FileName2;
    private String dataset1RankedFile = null;
    private String dataset2RankedFile = null;
    private String classFile1;
    private String classFile2;
    private String gseaHtmlReportFileDataset1 = null;
    private String gseaHtmlReportFileDataset2 = null;
    private boolean Data = false;
    private boolean Data2 = false;
    private boolean twoDatasets = false;
    private boolean FDR = false;
    private String method = "GSEA";
    private String similarityMetric;
    private boolean similarityCutOffChanged = false;
    private double combinedConstant;
    private double pvalue;
    private SliderBarPanel pvalueSlider;
    private double qvalue;
    private SliderBarPanel qvalueSlider;
    private double similarityCutOff;
    private SliderBarPanel similaritySlider;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private HashSet<Integer> datasetGenes;
    private int NumberOfGenes = 0;
    private HashSet<Integer> datasetGenes_set2;
    private HashMap<String, GeneSet> filteredGenesets_set2;
    private HashMap<String, GeneSet> genesets_set2;
    private HashMap<String, GeneSet> genesetsOfInterest_set2;
    private HashSet<Integer> enrichmentMapGenes;
    private HashMap<String, EnrichmentResult> enrichmentResults1 = new HashMap();
    private HashMap<String, EnrichmentResult> enrichmentResults2 = new HashMap();
    private HashMap<String, GeneSet> genesets;
    private HashMap<String, GeneSet> filteredGenesets;
    private HashMap<String, EnrichmentResult> enrichmentResults1OfInterest;
    private HashMap<String, EnrichmentResult> enrichmentResults2OfInterest;
    private HashMap<String, GeneSet> genesetsOfInterest;
    private HashMap<String, GeneSet> signatureGenesets;
    private GeneExpressionMatrix expression;
    private GeneExpressionMatrix expression2;
    private boolean twoDistinctExpressionSets = false;
    private String dataset1Phenotype1 = "UP";
    private String dataset1Phenotype2 = "DOWN";
    private String dataset2Phenotype1 = "UP";
    private String dataset2Phenotype2 = "DOWN";
    private String[] temp_class1 = null;
    private String[] temp_class2 = null;
    private HashMap<String, GenesetSimilarity> genesetSimilarity = null;
    private ArrayList<Node> selectedNodes;
    private ArrayList<Edge> selectedEdges;
    private HeatMapParameters hmParams;
    private HashMap<Integer, Ranking> dataset1Rankings;
    private HashMap<Integer, Ranking> dataset2Rankings;
    private HashMap<Integer, Integer> rank2geneDataset1;
    private HashMap<Integer, Integer> rank2geneDataset2;
    private HashMap<String, HashMap<Integer, Ranking>> ranks;
    private boolean BulkEM = false;
    private Properties cyto_prop;
    private double defaultPvalueCutOff;
    private double defaultQvalueCutOff;
    private double defaultJaccardCutOff;
    private double defaultOverlapCutOff;
    private double defaultCombinedConstant;
    private String defaultSimilarityMetric;
    private Boolean disable_heatmap_autofocus;
    private String defaultSortMethod;
    private String defaultDistanceMetric;
    public static final String ENRICHMENT_INTERACTION_TYPE = "Geneset_Overlap";
    public static final String ENRICHMENT_INTERACTION_TYPE_SET1 = "Geneset_Overlap_set1";
    public static final String ENRICHMENT_INTERACTION_TYPE_SET2 = "Geneset_Overlap_set2";
    public static final String method_GSEA = "GSEA";
    public static final String method_generic = "generic";
    public static final String method_DAVID = "DAVID/BiNGO";
    public static final String SM_JACCARD = "JACCARD";
    public static final String SM_OVERLAP = "OVERLAP";
    public static final String SM_COMBINED = "COMBINED";
    private PostAnalysisParameters paParams;
    private String enrichment_edge_type;

    public EnrichmentMapParameters() {
        this.genes = new HashMap();
        this.hashkey2gene = new HashMap();
        this.datasetGenes = new HashSet();
        this.enrichmentMapGenes = new HashSet();
        this.genesets = new HashMap();
        this.filteredGenesets = new HashMap();
        this.enrichmentResults1OfInterest = new HashMap();
        this.enrichmentResults2OfInterest = new HashMap();
        this.genesetsOfInterest = new HashMap();
        this.signatureGenesets = new HashMap();
        this.selectedNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        this.ranks = new HashMap();
        this.dataset1Rankings = new HashMap();
        this.dataset2Rankings = new HashMap();
        this.cyto_prop = CytoscapeInit.getProperties();
        this.defaultPvalueCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_pvalue", "0.005"));
        this.defaultQvalueCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_qvalue", "0.1"));
        this.defaultJaccardCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_jaccard", "0.25"));
        this.defaultOverlapCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_overlap", "0.50"));
        this.defaultCombinedConstant = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_combinedConstant", "0.50"));
        this.defaultSimilarityMetric = this.cyto_prop.getProperty("EnrichmentMap.default_similarity_metric", this.cyto_prop.getProperty("EnrichmentMap.default_overlap_metric", "overlap"));
        this.disable_heatmap_autofocus = Boolean.parseBoolean(this.cyto_prop.getProperty("EnrichmentMap.disable_heatmap_autofocus", "false"));
        this.defaultSortMethod = this.cyto_prop.getProperty("EnrichmentMap.default_sort_method", HeatMapParameters.sort_hierarchical_cluster);
        this.combinedConstant = this.defaultCombinedConstant;
        this.defaultDistanceMetric = this.cyto_prop.getProperty("EnrichmentMap.default_distance_metric", HeatMapParameters.pearson_correlation);
        this.pvalue = this.defaultPvalueCutOff;
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalue = this.defaultQvalueCutOff;
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.qvalue);
        if (this.getOverlapMetricDefault().equalsIgnoreCase(SM_OVERLAP)) {
            this.similarityCutOff = this.defaultOverlapCutOff;
            this.similarityMetric = SM_OVERLAP;
        } else if (this.getOverlapMetricDefault().equalsIgnoreCase(SM_JACCARD)) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = SM_JACCARD;
        } else if (this.getOverlapMetricDefault().equalsIgnoreCase(SM_COMBINED)) {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.similarityMetric = SM_COMBINED;
        }
        this.enrichment_edge_type = ENRICHMENT_INTERACTION_TYPE;
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
        this.datasetGenes_set2 = new HashSet();
        this.genesets_set2 = new HashMap();
        this.filteredGenesets_set2 = new HashMap();
        this.genesetsOfInterest_set2 = new HashMap();
        this.expression = null;
        this.expression2 = null;
        this.setFDR(false);
        this.setData(false);
        this.setData2(false);
        this.setTwoDatasets(false);
        this.setTwoDistinctExpressionSets(false);
    }

    public EnrichmentMapParameters(String propFile) {
        this();
        String[] set;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.NetworkName = (String)props.get("NetworkName");
        this.attributePrefix = (String)props.get("attributePrefix");
        this.enrichment_edge_type = props.containsKey("enrichment_edge_type") ? (String)props.get("enrichment_edge_type") : "pp";
        this.GMTFileName = (String)props.get("GMTFileName");
        this.expressionFileName1 = props.get("expressionFileName1") != null ? (String)props.get("expressionFileName1") : (String)props.get("GCTFileName1");
        this.enrichmentDataset1FileName1 = (String)props.get("enerichmentDataset1FileName1");
        this.enrichmentDataset1FileName2 = (String)props.get("enrichmentDataset1FileName2");
        this.gseaHtmlReportFileDataset1 = (String)props.get("gseaHtmlReportFileDataset1");
        this.gseaHtmlReportFileDataset2 = (String)props.get("gseaHtmlReportFileDataset2");
        this.dataset1Phenotype1 = (String)props.get("dataset1Phenotype1");
        this.dataset1Phenotype2 = (String)props.get("dataset1Phenotype2");
        this.dataset2Phenotype1 = (String)props.get("dataset2Phenotype1");
        this.dataset2Phenotype2 = (String)props.get("dataset2Phenotype2");
        if (props.get("rankFile1") != null) {
            this.dataset1RankedFile = ((String)props.get("rankFile1")).equalsIgnoreCase("null") ? null : (String)props.get("rankFile1");
        }
        if (props.get("classFile1") != null) {
            this.classFile1 = ((String)props.get("classFile1")).equalsIgnoreCase("null") ? null : (String)props.get("classFile1");
        }
        if (props.get("classFile2") != null) {
            this.classFile2 = ((String)props.get("classFile2")).equalsIgnoreCase("null") ? null : (String)props.get("classFile2");
        }
        if (props.get("class1") != null) {
            if (((String)props.get("class1")).equalsIgnoreCase("null")) {
                this.temp_class1 = null;
            } else {
                String classes = (String)props.get("class1");
                set = classes.split(",");
                this.temp_class1 = new String[set.length];
                for (int i = 0; i < set.length; ++i) {
                    this.temp_class1[i] = set[i];
                }
            }
        }
        if (props.get("class2") != null) {
            if (((String)props.get("class2")).equalsIgnoreCase("null")) {
                this.temp_class2 = null;
            } else {
                String classes = (String)props.get("class2");
                set = classes.split(",");
                this.temp_class2 = new String[set.length];
                for (int i = 0; i < set.length; ++i) {
                    this.temp_class2[i] = set[i];
                }
            }
        }
        if (((String)props.get("twoDatasets")).equalsIgnoreCase("true")) {
            this.twoDatasets = true;
        }
        if (((String)props.get("jaccard")).equalsIgnoreCase("false")) {
            this.similarityMetric = SM_JACCARD;
        } else if (((String)props.get("jaccard")).equalsIgnoreCase("true")) {
            this.similarityMetric = SM_OVERLAP;
        } else if (((String)props.get("jaccard")).equalsIgnoreCase(SM_JACCARD)) {
            this.similarityMetric = SM_JACCARD;
        } else if (((String)props.get("jaccard")).equalsIgnoreCase(SM_OVERLAP)) {
            this.similarityMetric = SM_OVERLAP;
        } else if (((String)props.get("jaccard")).equalsIgnoreCase(SM_COMBINED)) {
            this.similarityMetric = SM_COMBINED;
        }
        if (props.get("CombinedConstant") != null) {
            this.setCombinedConstant(Double.parseDouble((String)props.get("CombinedConstant")));
        } else {
            this.setCombinedConstant(0.5);
        }
        if (props.get(method_GSEA) != null) {
            this.method = ((String)props.get(method_GSEA)).equalsIgnoreCase("false") ? method_generic : method_GSEA;
        }
        if (((String)props.get("Data")).equalsIgnoreCase("true")) {
            this.Data = true;
        }
        if (((String)props.get("Data2")).equalsIgnoreCase("true")) {
            this.Data2 = true;
        }
        if (((String)props.get("FDR")).equalsIgnoreCase("true")) {
            this.FDR = true;
        }
        if (props.get("method") != null) {
            this.method = (String)props.get("method");
        }
        if (this.twoDatasets) {
            if (this.Data2) {
                this.expressionFileName2 = props.get("expressionFileName2") != null ? (String)props.get("expressionFileName2") : (String)props.get("GCTFileName2");
            }
            this.enrichmentDataset2FileName1 = (String)props.get("enerichmentDataset2FileName1");
            this.enrichmentDataset2FileName2 = (String)props.get("enrichmentDataset2FileName2");
            if (props.get("rankFile2") != null) {
                this.dataset2RankedFile = ((String)props.get("rankFile2")).equalsIgnoreCase("null") ? null : (String)props.get("rankFile2");
            }
        }
        this.setPvalue(Double.parseDouble((String)props.get("pvalue")));
        this.setQvalue(Double.parseDouble((String)props.get("qvalue")));
        String cutoff = props.get("jaccardCutOff") != null ? (String)props.get("jaccardCutOff") : (String)props.get("similarityCutOff");
        if (cutoff != null) {
            this.similarityCutOff = Double.parseDouble(cutoff);
            this.similarityCutOffChanged = true;
        }
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
    }

    public void copyInputParameters(EnrichmentMapParameters copy) {
        if (copy.isBulkEM()) {
            this.NetworkName = copy.getNetworkName();
            this.BulkEM = copy.isBulkEM();
        }
        this.GMTFileName = copy.getGMTFileName();
        this.expressionFileName1 = copy.getExpressionFileName1();
        this.expressionFileName2 = copy.getExpressionFileName2();
        this.dataset1RankedFile = copy.getDataset1RankedFile();
        this.dataset2RankedFile = copy.getDataset2RankedFile();
        this.enrichmentDataset1FileName1 = copy.getEnrichmentDataset1FileName1();
        this.enrichmentDataset1FileName2 = copy.getEnrichmentDataset1FileName2();
        this.enrichmentDataset2FileName1 = copy.getEnrichmentDataset2FileName1();
        this.enrichmentDataset2FileName2 = copy.getEnrichmentDataset2FileName2();
        this.gseaHtmlReportFileDataset1 = copy.getGseaHtmlReportFileDataset1();
        this.gseaHtmlReportFileDataset2 = copy.getGseaHtmlReportFileDataset2();
        this.dataset1Phenotype1 = copy.getDataset1Phenotype1();
        this.dataset1Phenotype2 = copy.getDataset1Phenotype2();
        this.dataset2Phenotype1 = copy.getDataset2Phenotype1();
        this.dataset2Phenotype2 = copy.getDataset2Phenotype2();
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.pvalue);
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth, false, this.qvalue);
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.similaritySlider = new SliderBarPanel(this.similarityCutOff, 1.0, "Similarity Cutoff", this, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, ParametersPanel.summaryPanelWidth, true, this.similarityCutOff);
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.method = copy.getMethod();
        this.similarityMetric = copy.getSimilarityMetric();
        this.similarityCutOffChanged = copy.similarityCutOffChanged;
        this.classFile1 = copy.getClassFile1();
        this.classFile2 = copy.getClassFile2();
        this.GMTDirName = copy.getGMTDirName();
        this.GCTDirName = copy.getGCTDirName();
        this.GSEAResultsDirName = copy.getGSEAResultsDirName();
        this.upperlimit = copy.getUpperlimit();
        this.lowerlimit = copy.getLowerlimit();
    }

    public void copy(EnrichmentMapParameters copy) {
        this.NetworkName = copy.getNetworkName();
        this.GMTFileName = copy.getGMTFileName();
        this.expressionFileName1 = copy.getExpressionFileName1();
        this.expressionFileName2 = copy.getExpressionFileName2();
        this.dataset1RankedFile = copy.getDataset1RankedFile();
        this.dataset2RankedFile = copy.getDataset2RankedFile();
        this.ranks = copy.getRanks();
        this.enrichmentDataset1FileName1 = copy.getEnrichmentDataset1FileName1();
        this.enrichmentDataset1FileName2 = copy.getEnrichmentDataset1FileName2();
        this.enrichmentDataset2FileName1 = copy.getEnrichmentDataset2FileName1();
        this.enrichmentDataset2FileName2 = copy.getEnrichmentDataset2FileName2();
        this.gseaHtmlReportFileDataset1 = copy.getGseaHtmlReportFileDataset1();
        this.gseaHtmlReportFileDataset2 = copy.getGseaHtmlReportFileDataset2();
        this.dataset1Phenotype1 = copy.getDataset1Phenotype1();
        this.dataset1Phenotype2 = copy.getDataset1Phenotype2();
        this.dataset2Phenotype1 = copy.getDataset2Phenotype1();
        this.dataset2Phenotype2 = copy.getDataset2Phenotype2();
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = copy.getPvalueSlider();
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = copy.getQvalueSlider();
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.similaritySlider = copy.getSimilaritySlider();
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.method = copy.getMethod();
        this.FDR = copy.isFDR();
        this.similarityMetric = copy.getSimilarityMetric();
        this.combinedConstant = copy.getCombinedConstant();
        this.similarityCutOffChanged = copy.similarityCutOffChanged;
        this.genes = copy.getGenes();
        this.hashkey2gene = copy.getHashkey2gene();
        this.NumberOfGenes = copy.getNumberOfGenes();
        this.datasetGenes = copy.getDatasetGenes();
        this.genesets = copy.getGenesets();
        this.genesetsOfInterest = copy.getGenesetsOfInterest();
        this.signatureGenesets = copy.getSignatureGenesets();
        this.filteredGenesets = copy.getFilteredGenesets();
        this.enrichmentResults1 = copy.getEnrichmentResults1();
        this.enrichmentResults2 = copy.getEnrichmentResults2();
        this.enrichmentResults1OfInterest = copy.getEnrichmentResults1OfInterest();
        this.enrichmentResults2OfInterest = copy.getEnrichmentResults2OfInterest();
        this.expression = copy.getExpression();
        this.expression2 = copy.getExpression2();
        this.twoDistinctExpressionSets = copy.isTwoDistinctExpressionSets();
        this.classFile1 = copy.getClassFile1();
        this.classFile2 = copy.getClassFile2();
        this.temp_class1 = copy.getTemp_class1();
        this.temp_class2 = copy.getTemp_class2();
        this.dataset1Rankings = copy.getDataset1Rankings();
        this.dataset2Rankings = copy.getDataset2Rankings();
        this.selectedEdges = copy.getSelectedEdges();
        this.selectedNodes = copy.getSelectedNodes();
        this.genesetSimilarity = copy.getGenesetSimilarity();
        this.hmParams = copy.getHmParams();
        this.attributePrefix = copy.getAttributePrefix();
        this.enrichment_edge_type = copy.getEnrichment_edge_type();
        this.rank2geneDataset1 = copy.getRank2geneDataset1();
        this.rank2geneDataset2 = copy.getRank2geneDataset2();
        this.datasetGenes_set2 = copy.getDatasetGenes_set2();
        this.genesets_set2 = copy.getGenesets_set2();
        this.filteredGenesets_set2 = copy.getFilteredGenesets_set2();
        this.genesetsOfInterest_set2 = copy.getGenesetsOfInterest_set2();
        this.GMTDirName = copy.getGMTDirName();
        this.GCTDirName = copy.getGCTDirName();
        this.GSEAResultsDirName = copy.getGSEAResultsDirName();
        this.upperlimit = copy.getUpperlimit();
        this.lowerlimit = copy.getLowerlimit();
    }

    public String checkMinimalRequirements() {
        String errors = "";
        if (this.enrichmentDataset1FileName1 == null && this.enrichmentDataset1FileName2 == null && this.enrichmentDataset2FileName1 == null && this.enrichmentDataset2FileName2 == null && this.GMTFileName != null && !this.GMTFileName.equalsIgnoreCase("")) {
            errors = "GMTONLY";
        } else {
            if (this.enrichmentDataset1FileName1 == null || this.enrichmentDataset1FileName1.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset1FileName1)) {
                errors = errors + "Dataset 1, enrichment file 1 can not be found\n";
            }
            if (this.twoDatasets && (this.enrichmentDataset2FileName1 == null || this.enrichmentDataset2FileName1.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset2FileName1))) {
                errors = errors + "Dataset 2, enrichment file 1 can not be found\n";
            }
            if (!(this.method.equalsIgnoreCase(method_DAVID) || this.GMTFileName != null && !this.GMTFileName.equalsIgnoreCase("") && this.checkFile(this.GMTFileName))) {
                errors = errors + "GMT file can not be found \n";
            }
            if (this.method.equalsIgnoreCase(method_GSEA)) {
                if (this.enrichmentDataset1FileName2 != null && (this.enrichmentDataset1FileName2.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset1FileName2))) {
                    errors = errors + "Dataset 1, enrichment file 2 can not be found\n";
                }
                if (this.twoDatasets && this.enrichmentDataset2FileName2 != null && (this.enrichmentDataset2FileName2.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset2FileName2))) {
                    errors = errors + "Dataset 2, enrichment file 2 can not be found\n";
                }
            }
            if (this.twoDatasets && this.expressionFileName1 != null && this.expressionFileName1.equalsIgnoreCase(this.expressionFileName2)) {
                this.Data2 = false;
                this.expressionFileName2 = "";
            } else if (this.expressionFileName1 != null && this.expressionFileName2 != null && this.method.equalsIgnoreCase(method_DAVID)) {
                this.setTwoDistinctExpressionSets(true);
            }
        }
        return errors;
    }

    protected boolean checkFile(String filename) {
        File tempfile;
        return filename == null || (tempfile = new File(filename)).canRead();
    }

    public void filterGenesets() {
        if (this.isTwoDistinctExpressionSets()) {
            GeneSet new_set;
            HashSet<Integer> new_geneset;
            HashSet<Integer> intersection;
            HashSet<Integer> geneset_genes;
            GeneSet current_set;
            String geneset2_name;
            Iterator<String> j = this.genesets.keySet().iterator();
            while (j.hasNext()) {
                geneset2_name = j.next().toString();
                current_set = this.genesets.get(geneset2_name);
                geneset_genes = current_set.getGenes();
                intersection = new HashSet<Integer>(geneset_genes);
                intersection.retainAll(this.datasetGenes);
                new_geneset = new HashSet<Integer>(intersection);
                new_set = new GeneSet(geneset2_name, current_set.getDescription());
                new_set.setGenes(new_geneset);
                this.filteredGenesets.put(geneset2_name, new_set);
            }
            j = this.genesets_set2.keySet().iterator();
            while (j.hasNext()) {
                geneset2_name = j.next().toString();
                current_set = this.genesets_set2.get(geneset2_name);
                geneset_genes = current_set.getGenes();
                intersection = new HashSet<Integer>(geneset_genes);
                intersection.retainAll(this.datasetGenes_set2);
                new_geneset = new HashSet<Integer>(intersection);
                new_set = new GeneSet(geneset2_name, current_set.getDescription());
                new_set.setGenes(new_geneset);
                this.filteredGenesets_set2.put(geneset2_name, new_set);
            }
        } else {
            Iterator<String> j = this.genesets.keySet().iterator();
            while (j.hasNext()) {
                String geneset2_name = j.next().toString();
                GeneSet current_set = this.genesets.get(geneset2_name);
                HashSet<Integer> geneset_genes = current_set.getGenes();
                HashSet<Integer> intersection = new HashSet<Integer>(geneset_genes);
                intersection.retainAll(this.datasetGenes);
                HashSet<Integer> new_geneset = new HashSet<Integer>(intersection);
                GeneSet new_set = new GeneSet(geneset2_name, current_set.getDescription());
                new_set.setGenes(new_geneset);
                this.filteredGenesets.put(geneset2_name, new_set);
            }
            this.genesets.clear();
            this.genesets_set2.clear();
        }
    }

    public void computeEnrichmentMapGenes() {
        this.enrichmentMapGenes = new HashSet();
        for (String setName : this.genesetsOfInterest.keySet()) {
            this.enrichmentMapGenes.addAll(this.genesetsOfInterest.get(setName).getGenes());
        }
    }

    public boolean checkGenesets() {
        Iterator<String> j = this.filteredGenesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset2_name = j.next().toString();
            GeneSet current_set = this.filteredGenesets.get(geneset2_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            if (geneset_genes.isEmpty()) continue;
            return true;
        }
        return this.getMethod().equalsIgnoreCase(method_DAVID);
    }

    public String toString() {
        int j;
        StringBuffer output;
        String[] current_pheno;
        StringBuffer paramVariables = new StringBuffer();
        paramVariables.append("NetworkName\t" + this.NetworkName + "\n");
        paramVariables.append("attributePrefix\t" + this.attributePrefix + "\n");
        paramVariables.append("enrichment_edge_type\t" + this.enrichment_edge_type + "\n");
        paramVariables.append("GMTFileName\t" + this.GMTFileName + "\n");
        paramVariables.append("expressionFileName1\t" + this.expressionFileName1 + "\n");
        paramVariables.append("expressionFileName2\t" + this.expressionFileName2 + "\n");
        paramVariables.append("enerichmentDataset1FileName1\t" + this.enrichmentDataset1FileName1 + "\n");
        paramVariables.append("enrichmentDataset1FileName2\t" + this.enrichmentDataset1FileName2 + "\n");
        paramVariables.append("enerichmentDataset2FileName1\t" + this.enrichmentDataset2FileName1 + "\n");
        paramVariables.append("enrichmentDataset2FileName2\t" + this.enrichmentDataset2FileName2 + "\n");
        paramVariables.append("gseaHtmlReportFileDataset1\t" + this.gseaHtmlReportFileDataset1 + "\n");
        paramVariables.append("gseaHtmlReportFileDataset2\t" + this.gseaHtmlReportFileDataset2 + "\n");
        paramVariables.append("dataset1Phenotype1\t" + this.dataset1Phenotype1 + "\n");
        paramVariables.append("dataset1Phenotype2\t" + this.dataset1Phenotype2 + "\n");
        paramVariables.append("dataset2Phenotype1\t" + this.dataset2Phenotype1 + "\n");
        paramVariables.append("dataset2Phenotype2\t" + this.dataset2Phenotype2 + "\n");
        paramVariables.append("classFile1\t" + this.classFile1 + "\n");
        paramVariables.append("classFile2\t" + this.classFile2 + "\n");
        if (this.isData() && this.expression != null && (current_pheno = this.expression.getPhenotypes()) != null) {
            output = new StringBuffer();
            for (j = 0; j < current_pheno.length; ++j) {
                output.append(current_pheno[j] + ",");
            }
            paramVariables.append("class1\t" + output.toString() + "\n");
        }
        if (this.isData2() && this.expression2 != null && (current_pheno = this.expression2.getPhenotypes()) != null) {
            output = new StringBuffer();
            for (j = 0; j < current_pheno.length; ++j) {
                output.append(current_pheno[j] + ",");
            }
            paramVariables.append("class2\t" + output.toString() + "\n");
        }
        paramVariables.append("method\t" + this.method + "\n");
        paramVariables.append("rankFile1\t" + this.dataset1RankedFile + "\n");
        paramVariables.append("rankFile2\t" + this.dataset2RankedFile + "\n");
        paramVariables.append("twoDatasets\t" + this.twoDatasets + "\n");
        paramVariables.append("jaccard\t" + this.similarityMetric + "\n");
        paramVariables.append("CombinedConstant" + this.combinedConstant + "\n");
        paramVariables.append("Data\t" + this.Data + "\n");
        paramVariables.append("Data2\t" + this.Data2 + "\n");
        paramVariables.append("FDR\t" + this.FDR + "\n");
        paramVariables.append("pvalue\t" + this.pvalue + "\n");
        paramVariables.append("qvalue\t" + this.qvalue + "\n");
        paramVariables.append("similarityCutOff\t" + this.similarityCutOff + "\n");
        return paramVariables.toString();
    }

    public String printHashmap(HashMap map) {
        StringBuffer result = new StringBuffer();
        for (Object key : map.keySet()) {
            result.append(key.toString() + "\t" + map.get(key).toString() + "\n");
        }
        return result.toString();
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        String[] tokens;
        String line;
        int i;
        HashMap<Object, Object> newMap;
        boolean incrementRank = false;
        String[] lines = fileInput.split("\n");
        if (type == 1) {
            newMap = new HashMap<Object, Object>();
        } else if (type == 2) {
            newMap = new HashMap();
        } else if (type == 3) {
            newMap = new HashMap();
        } else if (type == 4) {
            newMap = new HashMap();
        } else if (type == 5) {
            newMap = new HashMap();
        } else if (type == 6) {
            newMap = new HashMap();
            for (i = 0; i < lines.length; ++i) {
                line = lines[i];
                tokens = line.split("\t");
                if (Integer.parseInt(tokens[3]) >= 0) continue;
                incrementRank = true;
            }
        } else {
            newMap = type == 7 ? new HashMap() : new HashMap();
        }
        for (i = 0; i < lines.length; ++i) {
            line = lines[i];
            tokens = line.split("\t");
            if (type == 1 && tokens.length >= 3) {
                newMap.put(tokens[0], new GeneSet(tokens));
            }
            if (type == 2) {
                if (tokens.length > 1) {
                    newMap.put(tokens[0], Integer.parseInt(tokens[1]));
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 3) {
                newMap.put(tokens[0], new GSEAResult(tokens));
            }
            if (type == 4 && tokens.length > 3) {
                newMap.put(tokens[0], new GenericResult(tokens));
            }
            if (type == 5) {
                if (tokens.length > 1) {
                    newMap.put(Integer.parseInt(tokens[0]), tokens[1]);
                } else {
                    System.out.println(tokens.toString());
                }
            }
            if (type == 6) {
                if (incrementRank) {
                    Integer newRank = Integer.parseInt(tokens[3]) + 1;
                    tokens[3] = newRank.toString();
                }
                newMap.put(Integer.parseInt(tokens[0]), new Ranking(tokens));
            }
            if (type != 7) continue;
            newMap.put(Integer.parseInt(tokens[0]), Integer.parseInt(tokens[1]));
        }
        return newMap;
    }

    public boolean haveRanks() {
        return this.ranks.size() > 0;
    }

    public String getGeneFromHashKey(Integer hash) {
        String gene = null;
        if (this.hashkey2gene != null || !this.hashkey2gene.isEmpty()) {
            gene = this.hashkey2gene.get(hash);
        }
        return gene;
    }

    public String getSimilarityMetric() {
        return this.similarityMetric;
    }

    public void setSimilarityMetric(String similarityMetric) {
        this.similarityMetric = similarityMetric;
    }

    public HashMap<String, EnrichmentResult> getEnrichmentResults1() {
        return this.enrichmentResults1;
    }

    public void setEnrichmentResults1(HashMap<String, EnrichmentResult> enrichmentResults1) {
        this.enrichmentResults1 = enrichmentResults1;
    }

    public HashMap<String, EnrichmentResult> getEnrichmentResults2() {
        return this.enrichmentResults2;
    }

    public void setEnrichmentResults2(HashMap<String, EnrichmentResult> enrichmentResults2) {
        this.enrichmentResults2 = enrichmentResults2;
    }

    public HashMap<String, EnrichmentResult> getEnrichmentResults1OfInterest() {
        return this.enrichmentResults1OfInterest;
    }

    public void setEnrichmentResults1OfInterest(HashMap<String, EnrichmentResult> enrichmentResults1OfInterest) {
        this.enrichmentResults1OfInterest = enrichmentResults1OfInterest;
    }

    public HashMap<String, EnrichmentResult> getEnrichmentResults2OfInterest() {
        return this.enrichmentResults2OfInterest;
    }

    public void setEnrichmentResults2OfInterest(HashMap<String, EnrichmentResult> enrichmentResults2OfInterest) {
        this.enrichmentResults2OfInterest = enrichmentResults2OfInterest;
    }

    public HashMap<String, GeneSet> getGenesetsOfInterest() {
        return this.genesetsOfInterest;
    }

    public void setGenesetsOfInterest(HashMap<String, GeneSet> genesetsOfInterest) {
        this.genesetsOfInterest = genesetsOfInterest;
    }

    public HashMap<String, GeneSet> getGenesets() {
        return this.genesets;
    }

    public void setGenesets(HashMap<String, GeneSet> genesets) {
        this.genesets = genesets;
    }

    public HashMap<String, GeneSet> getFilteredGenesets() {
        return this.filteredGenesets;
    }

    public void setFilteredGenesets(HashMap<String, GeneSet> filteredGenesets) {
        this.filteredGenesets = filteredGenesets;
    }

    public String getGMTFileName() {
        return this.GMTFileName;
    }

    public void setGMTFileName(String GMTFileName) {
        this.GMTFileName = GMTFileName;
    }

    public String getExpressionFileName1() {
        return this.expressionFileName1;
    }

    public void setExpressionFileName1(String GCTFileName) {
        this.expressionFileName1 = GCTFileName;
    }

    public String getExpressionFileName2() {
        return this.expressionFileName2;
    }

    public void setExpressionFileName2(String GCTFileName) {
        this.expressionFileName2 = GCTFileName;
    }

    public String getEnrichmentDataset1FileName1() {
        return this.enrichmentDataset1FileName1;
    }

    public void setEnrichmentDataset1FileName1(String enrichmentDataset1FileName1) {
        this.enrichmentDataset1FileName1 = enrichmentDataset1FileName1;
    }

    public String getEnrichmentDataset1FileName2() {
        return this.enrichmentDataset1FileName2;
    }

    public void setEnrichmentDataset1FileName2(String enrichmentDataset1FileName2) {
        this.enrichmentDataset1FileName2 = enrichmentDataset1FileName2;
    }

    public String getEnrichmentDataset2FileName1() {
        return this.enrichmentDataset2FileName1;
    }

    public void setEnrichmentDataset2FileName1(String enrichmentDataset2FileName1) {
        this.enrichmentDataset2FileName1 = enrichmentDataset2FileName1;
    }

    public String getEnrichmentDataset2FileName2() {
        return this.enrichmentDataset2FileName2;
    }

    public void setEnrichmentDataset2FileName2(String enrichmentDataset2FileName2) {
        this.enrichmentDataset2FileName2 = enrichmentDataset2FileName2;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setQvalue(double qvalue) {
        this.qvalue = qvalue;
    }

    public HashMap<String, Integer> getGenesetsGenes(HashMap<String, GeneSet> current_genesets) {
        HashMap<String, Integer> genesetGenes = new HashMap<String, Integer>();
        Iterator<String> j = current_genesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset_name = j.next().toString();
            GeneSet current_set = current_genesets.get(geneset_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            for (Integer current_genekey : geneset_genes) {
                if (!this.hashkey2gene.containsKey(current_genekey)) continue;
                String name = this.hashkey2gene.get(current_genekey);
                genesetGenes.put(name, current_genekey);
            }
        }
        return genesetGenes;
    }

    public HashMap<String, Integer> getGenes() {
        return this.genes;
    }

    public void setGenes(HashMap<String, Integer> genes) {
        this.genes = genes;
    }

    public HashSet<Integer> getDatasetGenes() {
        return this.datasetGenes;
    }

    public void setDatasetGenes(HashSet<Integer> datasetGenes) {
        this.datasetGenes = datasetGenes;
    }

    public int getNumberOfGenes() {
        return this.NumberOfGenes;
    }

    public void setNumberOfGenes(int numberOfGenes) {
        this.NumberOfGenes = numberOfGenes;
    }

    public double getSimilarityCutOff() {
        return this.similarityCutOff;
    }

    public void setSimilarityCutOff(double similarityCutOff) {
        this.similarityCutOff = similarityCutOff;
    }

    public String getNetworkName() {
        return this.NetworkName;
    }

    public void setNetworkName(String networkName) {
        this.NetworkName = networkName;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public boolean isTwoDatasets() {
        return this.twoDatasets;
    }

    public void setTwoDatasets(boolean twoDatasets) {
        this.twoDatasets = twoDatasets;
    }

    public void noFilter() {
        this.filteredGenesets = this.genesets;
        this.filteredGenesets_set2 = this.genesets_set2;
    }

    public boolean isData() {
        return this.Data;
    }

    public void setData(boolean data) {
        this.Data = data;
    }

    public boolean isData2() {
        return this.Data2;
    }

    public void setData2(boolean data2) {
        this.Data2 = data2;
    }

    public boolean isFDR() {
        return this.FDR;
    }

    public void setFDR(boolean FDR) {
        this.FDR = FDR;
    }

    public GeneExpressionMatrix getExpression() {
        return this.expression;
    }

    public void setExpression(GeneExpressionMatrix expression) {
        this.expression = expression;
    }

    public GeneExpressionMatrix getExpression2() {
        return this.expression2;
    }

    public void setExpression2(GeneExpressionMatrix expression2) {
        this.expression2 = expression2;
    }

    public HashMap<String, GenesetSimilarity> getGenesetSimilarity() {
        return this.genesetSimilarity;
    }

    public void setGenesetSimilarity(HashMap<String, GenesetSimilarity> genesetSimilarity) {
        this.genesetSimilarity = genesetSimilarity;
    }

    public String getClassFile1() {
        return this.classFile1;
    }

    public void setClassFile1(String classFile1) {
        this.classFile1 = classFile1;
    }

    public String getClassFile2() {
        return this.classFile2;
    }

    public void setClassFile2(String classFile2) {
        this.classFile2 = classFile2;
    }

    public void setGseaHtmlReportFileDataset1(String gseaHtmlReportFileDataset1) {
        this.gseaHtmlReportFileDataset1 = gseaHtmlReportFileDataset1;
    }

    public String getGseaHtmlReportFileDataset1() {
        return this.gseaHtmlReportFileDataset1;
    }

    public void setGseaHtmlReportFileDataset2(String gseaHtmlReportFileDataset2) {
        this.gseaHtmlReportFileDataset2 = gseaHtmlReportFileDataset2;
    }

    public String getGseaHtmlReportFileDataset2() {
        return this.gseaHtmlReportFileDataset2;
    }

    public String getDataset1Phenotype1() {
        return this.dataset1Phenotype1;
    }

    public void setDataset1Phenotype1(String dataset1Phenotype1) {
        this.dataset1Phenotype1 = dataset1Phenotype1;
    }

    public String getDataset1Phenotype2() {
        return this.dataset1Phenotype2;
    }

    public void setDataset1Phenotype2(String dataset1Phenotype2) {
        this.dataset1Phenotype2 = dataset1Phenotype2;
    }

    public String getDataset2Phenotype1() {
        return this.dataset2Phenotype1;
    }

    public void setDataset2Phenotype1(String dataset2Phenotype1) {
        this.dataset2Phenotype1 = dataset2Phenotype1;
    }

    public String getDataset2Phenotype2() {
        return this.dataset2Phenotype2;
    }

    public void setDataset2Phenotype2(String dataset2Phenotype2) {
        this.dataset2Phenotype2 = dataset2Phenotype2;
    }

    public SliderBarPanel getPvalueSlider() {
        return this.pvalueSlider;
    }

    public SliderBarPanel getQvalueSlider() {
        return this.qvalueSlider;
    }

    public SliderBarPanel getSimilaritySlider() {
        return this.similaritySlider;
    }

    public ArrayList<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public ArrayList<Edge> getSelectedEdges() {
        return this.selectedEdges;
    }

    public void setSelectedNodes(ArrayList<Node> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void setSelectedEdges(ArrayList<Edge> selectedEdges) {
        this.selectedEdges = selectedEdges;
    }

    public HeatMapParameters getHmParams() {
        return this.hmParams;
    }

    public void setHmParams(HeatMapParameters hmParams) {
        this.hmParams = hmParams;
    }

    public String getDataset1RankedFile() {
        return this.dataset1RankedFile;
    }

    public void setDataset1RankedFile(String dataset1RankedFile) {
        this.dataset1RankedFile = dataset1RankedFile;
    }

    public String getDataset2RankedFile() {
        return this.dataset2RankedFile;
    }

    public void setDataset2RankedFile(String dataset2RankedFile) {
        this.dataset2RankedFile = dataset2RankedFile;
    }

    public HashMap<Integer, Ranking> getDataset1Rankings() {
        return this.dataset1Rankings;
    }

    public void setDataset1Rankings(HashMap<Integer, Ranking> dataset1Rankings) {
        this.dataset1Rankings = dataset1Rankings;
        if (this.ranks != null) {
            this.ranks.put("Dataset 1 Ranking", this.dataset1Rankings);
        }
    }

    public HashMap<Integer, Ranking> getDataset2Rankings() {
        return this.dataset2Rankings;
    }

    public void setDataset2Rankings(HashMap<Integer, Ranking> dataset2Rankings) {
        this.dataset2Rankings = dataset2Rankings;
        if (this.ranks != null) {
            this.ranks.put("Dataset 2 Ranking", this.dataset2Rankings);
        }
    }

    public HashMap<Integer, Integer> getRank2geneDataset1() {
        return this.rank2geneDataset1;
    }

    public void setRank2geneDataset1(HashMap<Integer, Integer> rank2geneDataset1) {
        this.rank2geneDataset1 = rank2geneDataset1;
    }

    public HashMap<Integer, Integer> getRank2geneDataset2() {
        return this.rank2geneDataset2;
    }

    public void setRank2geneDataset2(HashMap<Integer, Integer> rank2geneDataset2) {
        this.rank2geneDataset2 = rank2geneDataset2;
    }

    public String getOverlapMetricDefault() {
        return this.defaultSimilarityMetric;
    }

    public void setDefaultJaccardCutOff(double defaultJaccardCutOff) {
        this.defaultJaccardCutOff = defaultJaccardCutOff;
    }

    public double getDefaultJaccardCutOff() {
        return this.defaultJaccardCutOff;
    }

    public void setDefaultOverlapCutOff(double defaultOverlapCutOff) {
        this.defaultOverlapCutOff = defaultOverlapCutOff;
    }

    public double getDefaultOverlapCutOff() {
        return this.defaultOverlapCutOff;
    }

    public boolean isDisableHeatmapAutofocus() {
        return this.disable_heatmap_autofocus;
    }

    public void setDisableHeatmapAutofocus(boolean disable_heatmap_autofocus) {
        this.disable_heatmap_autofocus = disable_heatmap_autofocus;
    }

    public String getDefaultSortMethod() {
        return this.defaultSortMethod;
    }

    public void setDefaultSortMethod(String defaultSortMethod) {
        this.defaultSortMethod = defaultSortMethod;
        this.cyto_prop = CytoscapeInit.getProperties();
        this.cyto_prop.setProperty("EnrichmentMap.default_sort_method", defaultSortMethod);
    }

    public void setSimilarityCutOffChanged(boolean similarityCutOffChanged) {
        this.similarityCutOffChanged = similarityCutOffChanged;
    }

    public boolean isSimilarityCutOffChanged() {
        return this.similarityCutOffChanged;
    }

    public HashMap<Integer, String> getHashkey2gene() {
        return this.hashkey2gene;
    }

    public void setHashkey2gene(HashMap<Integer, String> hashkey2gene) {
        this.hashkey2gene = hashkey2gene;
    }

    public HashMap<String, HashMap<Integer, Ranking>> getRanks() {
        return this.ranks;
    }

    public void setRanks(HashMap<String, HashMap<Integer, Ranking>> ranks) {
        this.ranks = ranks;
    }

    public void addRanks(String ranks_name, HashMap<Integer, Ranking> new_rank) {
        if (this.ranks != null) {
            this.ranks.put(ranks_name, new_rank);
        }
    }

    public HashMap<Integer, Ranking> getRanksByName(String ranks_name) {
        if (this.ranks != null) {
            return this.ranks.get(ranks_name);
        }
        return null;
    }

    public String[] getTemp_class1() {
        return this.temp_class1;
    }

    public void setTemp_class1(String[] temp_class1) {
        this.temp_class1 = temp_class1;
    }

    public String[] getTemp_class2() {
        return this.temp_class2;
    }

    public void setTemp_class2(String[] temp_class2) {
        this.temp_class2 = temp_class2;
    }

    public HashSet<Integer> getEnrichmentMapGenes() {
        return this.enrichmentMapGenes;
    }

    public void setEnrichmentMapGenes(HashSet<Integer> enrichmentMapGenes) {
        this.enrichmentMapGenes = enrichmentMapGenes;
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    public PostAnalysisParameters getPaParams() {
        if (this.paParams == null) {
            this.paParams = new PostAnalysisParameters(this);
        }
        return this.paParams;
    }

    public void setSignatureGenesets(HashMap<String, GeneSet> signatureGenesets) {
        this.signatureGenesets = signatureGenesets;
    }

    public HashMap<String, GeneSet> getSignatureGenesets() {
        return this.signatureGenesets;
    }

    public void setEnrichment_edge_type(String enrichment_edge_type) {
        this.enrichment_edge_type = enrichment_edge_type;
    }

    public String getEnrichment_edge_type() {
        return this.enrichment_edge_type;
    }

    public String getDefaultDistanceMetric() {
        return this.defaultDistanceMetric;
    }

    public void setDefaultDistanceMetric(String defaultDistanceMetric) {
        this.defaultDistanceMetric = defaultDistanceMetric;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public boolean isTwoDistinctExpressionSets() {
        return this.twoDistinctExpressionSets;
    }

    public String getGMTDirName() {
        return this.GMTDirName;
    }

    public void setTwoDistinctExpressionSets(boolean twoDistinctExpressionSets) {
        this.twoDistinctExpressionSets = twoDistinctExpressionSets;
    }

    public HashSet<Integer> getDatasetGenes_set2() {
        return this.datasetGenes_set2;
    }

    public void setDatasetGenes_set2(HashSet<Integer> datasetGenes_set2) {
        this.datasetGenes_set2 = datasetGenes_set2;
    }

    public HashMap<String, GeneSet> getFilteredGenesets_set2() {
        return this.filteredGenesets_set2;
    }

    public void setFilteredGenesets_set2(HashMap<String, GeneSet> filteredGenesets_set2) {
        this.filteredGenesets_set2 = filteredGenesets_set2;
    }

    public HashMap<String, GeneSet> getGenesets_set2() {
        return this.genesets_set2;
    }

    public void setGenesets_set2(HashMap<String, GeneSet> genesets_set2) {
        this.genesets_set2 = genesets_set2;
    }

    public HashMap<String, GeneSet> getGenesetsOfInterest_set2() {
        return this.genesetsOfInterest_set2;
    }

    public void setGenesetsOfInterest_set2(HashMap<String, GeneSet> genesetsOfInterest_set2) {
        this.genesetsOfInterest_set2 = genesetsOfInterest_set2;
    }

    public void setGMTDirName(String GMTDirName) {
        this.GMTDirName = GMTDirName;
    }

    public String getGCTDirName() {
        return this.GCTDirName;
    }

    public void setGCTDirName(String GCTDirName) {
        this.GCTDirName = GCTDirName;
    }

    public int getLowerlimit() {
        return this.lowerlimit;
    }

    public void setLowerlimit(int lowerlimit) {
        this.lowerlimit = lowerlimit;
    }

    public int getUpperlimit() {
        return this.upperlimit;
    }

    public void setUpperlimit(int upperlimit) {
        this.upperlimit = upperlimit;
    }

    public String getGSEAResultsDirName() {
        return this.GSEAResultsDirName;
    }

    public void setGSEAResultsDirName(String GSEAResultsDirName) {
        this.GSEAResultsDirName = GSEAResultsDirName;
    }

    public double getCombinedConstant() {
        return this.combinedConstant;
    }

    public void setCombinedConstant(double combinedConstant) {
        this.combinedConstant = combinedConstant;
    }

    public boolean isBulkEM() {
        return this.BulkEM;
    }

    public void setBulkEM(boolean bulkEM) {
        this.BulkEM = bulkEM;
    }
}

