/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.GMTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.VisualizeEnrichmentMapTask;

public class BuildGMTEnrichmentMapTask
implements Task {
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private EnrichmentMapParameters params = new EnrichmentMapParameters();

    public BuildGMTEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params.copyInputParameters(params);
    }

    public void buildEnrichmentMap() {
        try {
            GMTFileReaderTask gmtFile = new GMTFileReaderTask(this.params, this.taskMonitor);
            gmtFile.run();
            this.params.setGenesetsOfInterest(this.params.getGenesets());
            this.params.setMethod("generic");
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.params, this.taskMonitor);
            similarities.run();
            HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
            this.params.setGenesetSimilarity(similarity_results);
            HashMap<String, GeneSet> current_sets = this.params.getGenesets();
            HashMap<String, EnrichmentResult> currentEnrichments = this.params.getEnrichmentResults1();
            Iterator<String> i = current_sets.keySet().iterator();
            while (i.hasNext()) {
                String geneset1_name = i.next().toString();
                GeneSet current = current_sets.get(geneset1_name);
                GenericResult temp_result = new GenericResult(current.getName(), current.getDescription(), 0.01, current.getGenes().size());
                currentEnrichments.put(current.getName(), temp_result);
            }
            this.params.setEnrichmentResults1(currentEnrichments);
            this.params.setEnrichmentResults1OfInterest(currentEnrichments);
            HashMap<String, Integer> genes = this.params.getGenes();
            HashSet<Integer> datasetGenes = this.params.getDatasetGenes();
            String[] tokens = new String[]{"Name", "Description", "Fake Expression"};
            GeneExpressionMatrix expressionMatrix = new GeneExpressionMatrix(tokens);
            HashMap<Integer, GeneExpression> expression = new HashMap<Integer, GeneExpression>();
            expressionMatrix.setExpressionMatrix(expression);
            tokens[2] = "1.0";
            for (String currentGene : genes.keySet()) {
                double newMin;
                int genekey = genes.get(currentGene);
                if (datasetGenes != null) {
                    datasetGenes.add(genekey);
                }
                GeneExpression expres = new GeneExpression(currentGene, currentGene);
                expres.setExpression(tokens);
                double newMax = expres.newMax(expressionMatrix.getMaxExpression());
                if (newMax != -100.0) {
                    expressionMatrix.setMaxExpression(newMax);
                }
                if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                    expressionMatrix.setMinExpression(newMin);
                }
                expression.put(genekey, expres);
            }
            expressionMatrix.setNumGenes(expressionMatrix.getExpressionMatrix().size());
            this.params.setData(true);
            this.params.setExpression(expressionMatrix);
            VisualizeEnrichmentMapTask map = new VisualizeEnrichmentMapTask(this.params, this.taskMonitor);
            map.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to build/visualize map");
        }
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GMT File");
    }
}

