/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;

public class GenericResult
extends EnrichmentResult {
    private String name = "";
    private String description = "";
    private double pvalue = 1.0;
    private int gsSize = 0;
    private double fdrqvalue = 1.0;
    private double NES = 1.0;

    public GenericResult(String[] tokens) {
        this.name = tokens[1];
        this.description = tokens[2];
        this.pvalue = Double.parseDouble(tokens[3]);
        this.gsSize = Integer.parseInt(tokens[4]);
        this.fdrqvalue = Double.parseDouble(tokens[5]);
        this.NES = Double.parseDouble(tokens[6]);
    }

    public GenericResult(String name, String description, double pvalue, int gssize) {
        this.name = name;
        this.description = description;
        this.pvalue = pvalue;
        this.gsSize = gssize;
    }

    public GenericResult(String name, String description, double pvalue, int gssize, double fdrqvalue) {
        this.name = name;
        this.description = description;
        this.pvalue = pvalue;
        this.gsSize = gssize;
        this.fdrqvalue = fdrqvalue;
    }

    public GenericResult(String name, String description, double pvalue, int gssize, double fdrqvalue, double phenotype) {
        this.name = name;
        this.description = description;
        this.gsSize = gssize;
        this.pvalue = pvalue;
        this.fdrqvalue = fdrqvalue;
        this.NES = phenotype;
    }

    public boolean geneSetOfInterest(double pvalue, double fdrqvalue, boolean useFDR) {
        if (useFDR) {
            return this.pvalue <= pvalue && this.fdrqvalue <= fdrqvalue;
        }
        return this.pvalue <= pvalue;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getFdrqvalue() {
        return this.fdrqvalue;
    }

    public void setFdrqvalue(double fdrqvalue) {
        this.fdrqvalue = fdrqvalue;
    }

    public int getGsSize() {
        return this.gsSize;
    }

    public void setGsSize(int gs_size) {
        this.gsSize = gs_size;
    }

    public double getNES() {
        return this.NES;
    }

    public void setNES(double NES) {
        this.NES = NES;
    }

    public String toString() {
        return this.name + "\t" + this.description + "\t" + this.pvalue + "\t" + this.gsSize + "\t" + this.fdrqvalue + "\t" + this.NES;
    }
}

