/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;

public class GMTFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String GMTFileName;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private HashMap<String, GeneSet> genesets;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    static final int ENRICHMENT_GMT = 1;
    static final int SIGNATURE_GMT = 2;

    public GMTFileReaderTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(EnrichmentMapParameters params) {
        this.params = params;
        this.GMTFileName = params.getGMTFileName();
        this.genes = params.getGenes();
        this.hashkey2gene = params.getHashkey2gene();
        this.genesets = params.getGenesets();
    }

    public GMTFileReaderTask(PostAnalysisParameters params, TaskMonitor taskMonitor, int genesets_file) {
        this(params, genesets_file);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(PostAnalysisParameters params, int genesets_file) {
        this.params = params;
        this.genes = params.getGenes();
        this.hashkey2gene = params.getHashkey2gene();
        if (genesets_file == 1) {
            this.GMTFileName = params.getGMTFileName();
            this.genesets = params.getGenesets();
        } else if (genesets_file == 2) {
            this.GMTFileName = params.getSignatureGMTFileName();
            this.genesets = params.getSignatureGenesets();
        } else {
            throw new IllegalArgumentException("argument not allowed:" + genesets_file);
        }
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.GMTFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        int currentProgress = 0;
        this.maxValue = lines.length;
        try {
            for (int i = 0; i < lines.length; ++i) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String line = lines[i];
                String[] tokens = line.split("\t");
                if (tokens.length < 2) continue;
                String Name = tokens[0].toUpperCase().trim();
                String description = tokens[1].trim();
                GeneSet gs = new GeneSet(Name, description);
                int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
                long timeRemaining = this.maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + this.maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                for (int j = 2; j < tokens.length; ++j) {
                    if (this.genes.containsKey(tokens[j])) {
                        gs.addGene(this.genes.get(tokens[j]));
                        continue;
                    }
                    int value = this.params.getNumberOfGenes();
                    this.genes.put(tokens[j].toUpperCase(), value);
                    this.hashkey2gene.put(value, tokens[j].toUpperCase());
                    this.params.setNumberOfGenes(value + 1);
                    gs.addGene(this.genes.get(tokens[j].toUpperCase()));
                }
                this.genesets.put(Name, gs);
            }
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException((Throwable)e, "Loading of GMT file cancelled");
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GMT file");
    }
}

