/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;
import org.baderlab.csplugins.enrichmentmap.Ranking;

public class InitializeGenesetsOfInterestTask
implements Task {
    EnrichmentMapParameters params;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public InitializeGenesetsOfInterestTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public InitializeGenesetsOfInterestTask(EnrichmentMapParameters params) {
        this.params = params;
    }

    public boolean initializeSets() {
        GeneSet current_set;
        double scoreAtMax;
        int genekey;
        double NES;
        int currentRankAtMax;
        Integer largestRank;
        Set<Integer> allranks;
        EnrichmentResult current_result;
        String current_name;
        long timeRemaining;
        int percentComplete;
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set");
        }
        HashMap<String, EnrichmentResult> enrichmentResults1 = this.params.getEnrichmentResults1();
        HashMap<String, EnrichmentResult> enrichmentResults2 = this.params.getEnrichmentResults2();
        HashMap<String, GeneSet> genesets = this.params.getFilteredGenesets();
        HashMap<String, EnrichmentResult> enrichmentResults1OfInterest = this.params.getEnrichmentResults1OfInterest();
        HashMap<String, EnrichmentResult> enrichmentResults2OfInterest = this.params.getEnrichmentResults2OfInterest();
        HashMap<String, GeneSet> genesetsOfInterest = this.params.getGenesetsOfInterest();
        HashMap<Integer, Ranking> dataset1ranks = this.params.getRanksByName("Dataset 1 Ranking");
        HashMap<Integer, Ranking> dataset2ranks = this.params.getRanksByName("Dataset 2 Ranking");
        HashMap<Integer, Integer> rank2geneDataset1 = this.params.getRank2geneDataset1();
        HashMap<Integer, Integer> rank2geneDataset2 = this.params.getRank2geneDataset2();
        int currentProgress = 0;
        int maxValue = enrichmentResults1.size() + enrichmentResults2.size();
        Iterator<String> i = enrichmentResults1.keySet().iterator();
        while (i.hasNext()) {
            percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            current_name = i.next().toString();
            if (this.params.isGSEA()) {
                current_result = (GSEAResult)enrichmentResults1.get(current_name);
                if (dataset1ranks != null && rank2geneDataset1 != null) {
                    allranks = rank2geneDataset1.keySet();
                    largestRank = Collections.max(allranks);
                    currentRankAtMax = ((GSEAResult)current_result).getRankAtMax();
                    if (currentRankAtMax != -1) {
                        NES = ((GSEAResult)current_result).getNES();
                        genekey = -1;
                        if (NES < 0.0) {
                            currentRankAtMax = largestRank - currentRankAtMax;
                            ((GSEAResult)current_result).setRankAtMax(currentRankAtMax);
                        }
                        if (rank2geneDataset1.containsKey(currentRankAtMax)) {
                            genekey = rank2geneDataset1.get(currentRankAtMax);
                        } else {
                            while (genekey == -1 && currentRankAtMax <= largestRank && currentRankAtMax > 0) {
                                currentRankAtMax = NES < 0.0 ? ++currentRankAtMax : --currentRankAtMax;
                                if (!rank2geneDataset1.containsKey(currentRankAtMax)) continue;
                                genekey = rank2geneDataset1.get(currentRankAtMax);
                            }
                        }
                        if (genekey > -1) {
                            scoreAtMax = dataset1ranks.get(genekey).getScore();
                            ((GSEAResult)current_result).setScoreAtMax(scoreAtMax);
                        }
                    }
                }
                if (!((GSEAResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue())) continue;
                enrichmentResults1OfInterest.put(current_name, current_result);
                if (genesets.containsKey(current_name)) {
                    current_set = genesets.get(current_name);
                    genesetsOfInterest.put(current_name, current_set);
                    continue;
                }
                throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
            }
            current_result = (GenericResult)enrichmentResults1.get(current_name);
            if (!((GenericResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue(), this.params.isFDR())) continue;
            enrichmentResults1OfInterest.put(current_name, current_result);
            if (genesets.containsKey(current_name)) {
                current_set = genesets.get(current_name);
                genesetsOfInterest.put(current_name, current_set);
                continue;
            }
            throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
        }
        if (this.params.isTwoDatasets()) {
            Iterator<String> j = enrichmentResults2.keySet().iterator();
            while (j.hasNext()) {
                percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Initializing genesets and gsea results of interest " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                current_name = j.next().toString();
                if (this.params.isGSEA()) {
                    current_result = (GSEAResult)enrichmentResults2.get(current_name);
                    if (((GSEAResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue())) {
                        enrichmentResults2OfInterest.put(current_name, current_result);
                        if (genesets.containsKey(current_name)) {
                            current_set = genesets.get(current_name);
                            genesetsOfInterest.put(current_name, current_set);
                        } else {
                            throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
                        }
                    }
                    if (dataset2ranks == null || rank2geneDataset2 == null) continue;
                    allranks = rank2geneDataset2.keySet();
                    largestRank = Collections.max(allranks);
                    currentRankAtMax = ((GSEAResult)current_result).getRankAtMax();
                    if (currentRankAtMax == -1) continue;
                    NES = ((GSEAResult)current_result).getNES();
                    genekey = -1;
                    if (NES < 0.0) {
                        currentRankAtMax = largestRank - currentRankAtMax;
                        ((GSEAResult)current_result).setRankAtMax(currentRankAtMax);
                    }
                    if (rank2geneDataset2.containsKey(currentRankAtMax)) {
                        genekey = rank2geneDataset2.get(currentRankAtMax);
                    } else {
                        while (genekey == -1 && currentRankAtMax <= largestRank && currentRankAtMax > 0) {
                            currentRankAtMax = NES < 0.0 ? ++currentRankAtMax : --currentRankAtMax;
                            if (!rank2geneDataset2.containsKey(currentRankAtMax)) continue;
                            genekey = rank2geneDataset2.get(currentRankAtMax);
                        }
                    }
                    if (genekey <= -1) continue;
                    scoreAtMax = dataset2ranks.get(genekey).getScore();
                    ((GSEAResult)current_result).setScoreAtMax(scoreAtMax);
                    continue;
                }
                current_result = (GenericResult)enrichmentResults2.get(current_name);
                if (!((GenericResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue(), this.params.isFDR())) continue;
                enrichmentResults2OfInterest.put(current_name, current_result);
                if (genesets.containsKey(current_name)) {
                    current_set = genesets.get(current_name);
                    genesetsOfInterest.put(current_name, current_set);
                    continue;
                }
                throw new IllegalThreadStateException("The Geneset: " + current_name + " is not found in the GMT file.");
            }
        }
        genesets.clear();
        return true;
    }

    public void run() {
        this.initializeSets();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Initializing subset of genesets and GSEA results of interest");
    }
}

