/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.readers.TextFileReader;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.view.CyNetworkView;
import giny.view.GraphViewChangeListener;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.baderlab.csplugins.enrichmentmap.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.ExpressionFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.LoadEnrichmentsPanelAction;
import org.baderlab.csplugins.enrichmentmap.LoadPostAnalysisPanelAction;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.ShowAboutPanelAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enrichment_Map_Plugin
extends CytoscapePlugin {
    static Properties build_props = new Properties();
    static Properties plugin_props = new Properties();
    static String buildId;
    static String pluginUrl;
    static String userManualUrl;
    private static boolean overrideHeatmapRevalidation;

    public Enrichment_Map_Plugin() {
        JMenu menu = Cytoscape.getDesktop().getCyMenus().getOperationsMenu();
        JMenu submenu = new JMenu("Enrichment Map");
        JMenuItem item = new JMenuItem("Load Enrichment Results");
        item.addActionListener((ActionListener)((Object)new LoadEnrichmentsPanelAction()));
        submenu.add(item);
        item = new JMenuItem("Post Analysis");
        item.addActionListener((ActionListener)((Object)new LoadPostAnalysisPanelAction()));
        submenu.add(item);
        item = new JMenuItem("About");
        item.addActionListener((ActionListener)((Object)new ShowAboutPanelAction()));
        submenu.add(item);
        menu.add(submenu);
        Properties cyto_props = CytoscapeInit.getProperties();
        if (!cyto_props.containsKey("nodelinkouturl.MSigDb.GSEA Gene sets")) {
            cyto_props.put("nodelinkouturl.MSigDb.GSEA Gene sets", "http://www.broad.mit.edu/gsea/msigdb/cards/%ID%.html");
        }
        if (cyto_props.containsKey("nodelinkouturl.MSigDb")) {
            cyto_props.remove("nodelinkouturl.MSigDb");
        }
        try {
            build_props = this.getPropertiesFromClasspath("org/baderlab/csplugins/enrichmentmap/buildID.props");
        }
        catch (IOException e) {
            build_props.setProperty("build.number", "0");
            build_props.setProperty("svn.revision", "0");
            build_props.setProperty("build.user", "user");
            build_props.setProperty("build.host", "host");
            build_props.setProperty("build.timestemp", "1900/01/01 00:00:00 +0000 (GMT)");
        }
        buildId = "Build: " + build_props.getProperty("build.number") + " from SVN: " + build_props.getProperty("svn.revision") + " by: " + build_props.getProperty("build.user") + "@" + build_props.getProperty("build.host") + " at: " + build_props.getProperty("build.timestamp");
        try {
            plugin_props = this.getPropertiesFromClasspath("org/baderlab/csplugins/enrichmentmap/plugin.props");
        }
        catch (IOException e) {
            // empty catch block
        }
        pluginUrl = plugin_props.getProperty("pluginURL", "http://www.baderlab.org/Software/EnrichmentMap");
        userManualUrl = pluginUrl + "/UserManual";
    }

    public void onCytoscapeExit() {
    }

    public void saveSessionStateFiles(List<File> pFileList) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir: [" + tmpDir + "]");
        HashMap<String, EnrichmentMapParameters> networks = EnrichmentMapManager.getInstance().getCyNetworkList();
        Iterator<String> i = networks.keySet().iterator();
        while (i.hasNext()) {
            String param_name;
            String networkId = i.next().toString();
            EnrichmentMapParameters params = networks.get(networkId);
            String name = Cytoscape.getNetwork((String)networkId).getTitle();
            if (!name.equalsIgnoreCase(param_name = params.getNetworkName())) {
                params.setNetworkName(name);
            }
            File session_prop_file = new File(tmpDir, name + ".props");
            File gmt = new File(tmpDir, name + ".gmt");
            File genes = new File(tmpDir, name + ".genes.txt");
            File hkgenes = new File(tmpDir, name + ".hashkey2genes.txt");
            File enrichmentresults1 = new File(tmpDir, name + ".ENR1.txt");
            File enrichmentresults1Ofinterest = new File(tmpDir, name + ".SubENR1.txt");
            File siggmt = new File(tmpDir, name + ".signature.gmt");
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(session_prop_file));
                writer.write(params.toString());
                writer.close();
                BufferedWriter gmtwriter = new BufferedWriter(new FileWriter(gmt));
                gmtwriter.write(params.printHashmap(params.getGenesetsOfInterest()));
                gmtwriter.close();
                pFileList.add(gmt);
                if (!params.getSignatureGenesets().isEmpty()) {
                    BufferedWriter sigGmtwriter = new BufferedWriter(new FileWriter(siggmt));
                    sigGmtwriter.write(params.printHashmap(params.getSignatureGenesets()));
                    sigGmtwriter.close();
                    pFileList.add(siggmt);
                }
                BufferedWriter geneswriter = new BufferedWriter(new FileWriter(genes));
                geneswriter.write(params.printHashmap(params.getGenes()));
                geneswriter.close();
                pFileList.add(genes);
                BufferedWriter hashkey2geneswriter = new BufferedWriter(new FileWriter(hkgenes));
                hashkey2geneswriter.write(params.printHashmap(params.getHashkey2gene()));
                hashkey2geneswriter.close();
                pFileList.add(hkgenes);
                BufferedWriter enr1writer = new BufferedWriter(new FileWriter(enrichmentresults1));
                enr1writer.write(params.printHashmap(params.getEnrichmentResults1()));
                enr1writer.close();
                pFileList.add(enrichmentresults1);
                BufferedWriter subenr1writer = new BufferedWriter(new FileWriter(enrichmentresults1Ofinterest));
                subenr1writer.write(params.printHashmap(params.getEnrichmentResults1OfInterest()));
                subenr1writer.close();
                pFileList.add(enrichmentresults1Ofinterest);
                if (params.getRank2geneDataset1() != null) {
                    File ranks1geneids = new File(tmpDir, name + ".RANKS1Genes.txt");
                    BufferedWriter r2g12writer = new BufferedWriter(new FileWriter(ranks1geneids));
                    r2g12writer.write(params.printHashmap(params.getRank2geneDataset1()));
                    r2g12writer.close();
                    pFileList.add(ranks1geneids);
                }
                if (!params.getRanks().isEmpty()) {
                    HashMap<String, HashMap<Integer, Ranking>> all_ranks = params.getRanks();
                    Iterator<String> j = all_ranks.keySet().iterator();
                    while (j.hasNext()) {
                        String ranks_name = j.next().toString();
                        if (ranks_name.contains(".")) {
                            ranks_name.replace('.', '_');
                        }
                        File current_ranks = new File(tmpDir, name + "." + ranks_name + ".RANKS.txt");
                        BufferedWriter subrank1writer = new BufferedWriter(new FileWriter(current_ranks));
                        subrank1writer.write(params.printHashmap(all_ranks.get(ranks_name)));
                        subrank1writer.close();
                        pFileList.add(current_ranks);
                    }
                }
                if (params.isTwoDatasets()) {
                    File enrichmentresults2 = new File(tmpDir, name + ".ENR2.txt");
                    BufferedWriter enr2writer = new BufferedWriter(new FileWriter(enrichmentresults2));
                    enr2writer.write(params.printHashmap(params.getEnrichmentResults2()));
                    enr2writer.close();
                    pFileList.add(enrichmentresults2);
                    File enrichmentresults2Ofinterest = new File(tmpDir, name + ".SubENR2.txt");
                    BufferedWriter subenr2writer = new BufferedWriter(new FileWriter(enrichmentresults2Ofinterest));
                    subenr2writer.write(params.printHashmap(params.getEnrichmentResults1OfInterest()));
                    subenr2writer.close();
                    pFileList.add(enrichmentresults2Ofinterest);
                    if (params.getRank2geneDataset2() != null) {
                        File ranks2geneids = new File(tmpDir, name + ".RANKS2Genes.txt");
                        BufferedWriter r2g22writer = new BufferedWriter(new FileWriter(ranks2geneids));
                        r2g22writer.write(params.printHashmap(params.getRank2geneDataset2()));
                        r2g22writer.close();
                        pFileList.add(ranks2geneids);
                    }
                }
                if (params.isData()) {
                    File expression1 = new File(tmpDir, name + ".expression1.txt");
                    BufferedWriter expression1writer = new BufferedWriter(new FileWriter(expression1));
                    expression1writer.write(params.getExpression().toString());
                    expression1writer.close();
                    pFileList.add(expression1);
                }
                if (params.isData2()) {
                    File expression2 = new File(tmpDir, name + ".expression2.txt");
                    BufferedWriter expression2writer = new BufferedWriter(new FileWriter(expression2));
                    expression2writer.write(params.getExpression2().toString());
                    expression2writer.close();
                    pFileList.add(expression2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            pFileList.add(session_prop_file);
        }
    }

    public void restoreSessionState(List<File> pStateFileList) {
        if (pStateFileList == null || pStateFileList.size() == 0) {
            return;
        }
        try {
            String name;
            String[] fullname;
            EnrichmentMapParameters params;
            File prop_file;
            int i;
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (!prop_file.getName().contains(".props")) continue;
                TextFileReader reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                String fullText = reader.getText();
                params = new EnrichmentMapParameters(fullText);
                String param_name = params.getNetworkName();
                String[] fullname2 = prop_file.getName().split("Enrichment_Map_Plugin_");
                String props_name = fullname2[1].split("\\.")[0];
                String name2 = param_name;
                if (!props_name.equalsIgnoreCase(param_name)) {
                    name2 = props_name;
                    params.setNetworkName(name2);
                }
                EnrichmentMapManager.getInstance().registerNetwork(Cytoscape.getNetwork((String)name2), params);
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                if (fullname.length <= 1) continue;
                name = fullname[1].split("\\.")[0];
                params = EnrichmentMapManager.getInstance().getParameters(name);
                if (params == null) {
                    System.out.println("network for file" + prop_file.getName() + " does not exist.");
                    continue;
                }
                if (prop_file.getName().contains(".props") || prop_file.getName().contains(".expression1.txt") || prop_file.getName().contains(".expression2.txt")) continue;
                TextFileReader reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                String fullText = reader.getText();
                if (prop_file.getName().contains(".gmt")) {
                    if (prop_file.getName().contains(".signature.gmt")) {
                        params.setSignatureGenesets(params.repopulateHashmap(fullText, 1));
                    } else {
                        params.setGenesetsOfInterest(params.repopulateHashmap(fullText, 1));
                    }
                }
                if (prop_file.getName().contains(".genes.txt")) {
                    HashMap genes = params.repopulateHashmap(fullText, 2);
                    params.setGenes(genes);
                    params.setNumberOfGenes(Math.max(params.getNumberOfGenes(), (Integer)Collections.max(genes.values()) + 1));
                }
                if (prop_file.getName().contains(".hashkey2genes.txt")) {
                    HashMap hashkey2gene = params.repopulateHashmap(fullText, 5);
                    params.setHashkey2gene(hashkey2gene);
                    params.setNumberOfGenes(Math.max(params.getNumberOfGenes(), (Integer)Collections.max(hashkey2gene.keySet()) + 1));
                }
                if (prop_file.getName().contains(".ENR1.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults1(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults1(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (prop_file.getName().contains(".SubENR1.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults1OfInterest(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults1OfInterest(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (prop_file.getName().contains(".RANKS1.txt")) {
                    params.setDataset1Rankings(params.repopulateHashmap(fullText, 6));
                }
                if (prop_file.getName().contains(".RANKS1Genes.txt")) {
                    params.setRank2geneDataset1(params.repopulateHashmap(fullText, 7));
                }
                if (prop_file.getName().contains(".RANKS.txt")) {
                    String[] file_name_tokens = prop_file.getName().split("\\.");
                    String ranks_name = file_name_tokens.length == 4 ? file_name_tokens[1] : prop_file.getName();
                    params.addRanks(ranks_name, params.repopulateHashmap(fullText, 6));
                }
                if (!params.isTwoDatasets()) continue;
                if (prop_file.getName().contains(".ENR2.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults2(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults2(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (prop_file.getName().contains(".SubENR2.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults2OfInterest(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults2OfInterest(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (prop_file.getName().contains(".RANKS2Genes.txt")) {
                    params.setRank2geneDataset2(params.repopulateHashmap(fullText, 7));
                }
                if (!prop_file.getName().contains(".RANKS2.txt")) continue;
                params.setDataset2Rankings(params.repopulateHashmap(fullText, 6));
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains("expression1.txt")) {
                    fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                    name = fullname[1].split("\\.")[0];
                    params = EnrichmentMapManager.getInstance().getParameters(name);
                    params.setExpressionFileName1(prop_file.getAbsolutePath());
                    ExpressionFileReaderTask expressionFile1 = new ExpressionFileReaderTask(params, 1);
                    expressionFile1.run();
                    params.getExpression().rowNormalizeMatrix();
                }
                if (!prop_file.getName().contains("expression2.txt")) continue;
                fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                name = fullname[1].split("\\.")[0];
                params = EnrichmentMapManager.getInstance().getParameters(name);
                params.setExpressionFileName2(prop_file.getAbsolutePath());
                ExpressionFileReaderTask expressionFile2 = new ExpressionFileReaderTask(params, 2);
                expressionFile2.run();
                params.getExpression2().rowNormalizeMatrix();
            }
            EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
            HashMap<String, EnrichmentMapParameters> networks = manager.getCyNetworkList();
            Iterator<String> j = networks.keySet().iterator();
            while (j.hasNext()) {
                String currentNetwork = j.next();
                CyNetworkView view = Cytoscape.getNetworkView((String)currentNetwork);
                EnrichmentMapParameters params2 = networks.get(currentNetwork);
                ComputeSimilarityTask similarities = new ComputeSimilarityTask(params2, 0);
                similarities.run();
                HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
                params2.setGenesetSimilarity(similarity_results);
                if (!params2.getSignatureGenesets().isEmpty()) {
                    ComputeSimilarityTask sigSimilarities = new ComputeSimilarityTask(params2, 1);
                    sigSimilarities.run();
                    HashMap<String, GenesetSimilarity> sig_similarity_results = sigSimilarities.getGeneset_similarities();
                    params2.getGenesetSimilarity().putAll(sig_similarity_results);
                }
                view.addGraphViewChangeListener((GraphViewChangeListener)new EnrichmentMapActionListener(params2));
                if (j.hasNext()) continue;
                Cytoscape.setCurrentNetwork((String)currentNetwork);
                ParametersPanel paramPanel = manager.getParameterPanel();
                paramPanel.updatePanel(params2);
                paramPanel.revalidate();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
        Properties cyto_props = CytoscapeInit.getProperties();
        if (cyto_props.containsKey("nodelinkouturl.MSigDb")) {
            cyto_props.remove("nodelinkouturl.MSigDb");
        }
    }

    private Properties getPropertiesFromClasspath(String propFileName) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }

    public static void setOverrideHeatmapRevalidation(boolean overrideHeatmapRevalidation) {
        Enrichment_Map_Plugin.overrideHeatmapRevalidation = overrideHeatmapRevalidation;
    }

    public static boolean isOverrideHeatmapRevalidation() {
        return overrideHeatmapRevalidation;
    }

    static {
        overrideHeatmapRevalidation = false;
    }
}

