/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeMap;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.Enrichment_Map_Plugin;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.HeatMapActionListener;
import org.baderlab.csplugins.enrichmentmap.HeatMapPanel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class HeatMapParameters {
    private ColorGradientRange range;
    private ColorGradientTheme theme;
    Sort sort;
    Transformation transformation;
    private String sortbycolumnName;
    private boolean sortbycolumn_event_triggered = false;
    private int sortIndex = -1;
    private String rankFileIndex;
    private boolean[] ascending;
    static final int Ascending = 0;
    static final int Descending = 1;
    private ImageIcon[] iconArrow = this.createExpandAndCollapseIcon();
    private double minExpression;
    private double maxExpression;
    private double minExpression_rownorm;
    private double maxExpression_rownorm;
    private JPanel heatmapOptions;
    private JPanel RankOptions;
    private JComboBox hmOptionComboBox;
    private JComboBox rankOptionComboBox;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    public static String sort_hierarchical_cluster = "Hierarchical Cluster";
    public static String sort_rank = "Ranks";
    public static String sort_column = "Columns";
    public static String sort_none = "No Sort";

    public HeatMapParameters(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.sort = Sort.DEFAULT;
        this.transformation = Transformation.ASIS;
    }

    public void initColorGradients(GeneExpressionMatrix expression) {
        this.minExpression = expression.getMinExpression();
        this.maxExpression = expression.getMaxExpression();
        this.minExpression_rownorm = expression.getMinExpression(expression.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm = expression.getMaxExpression(expression.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        double median = 0.0;
        if (this.minExpression >= 0.0) {
            this.range = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient() {
        double max;
        double min;
        switch (this.transformation) {
            case ROWNORM: {
                min = this.minExpression_rownorm;
                max = this.maxExpression_rownorm;
                if (min == 0.0 && max == 0.0) {
                    JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Row normalization does not work with only one data column per dataset.", "Row normalization error", 2);
                }
                max = Math.max(Math.abs(min), max);
                break;
            }
            case LOGTRANSFORM: {
                min = Math.log1p(this.minExpression);
                max = Math.log1p(this.maxExpression);
                max = Math.max(Math.abs(min), max);
                break;
            }
            default: {
                min = this.minExpression;
                max = Math.max(Math.abs(this.minExpression), this.maxExpression);
            }
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public JPanel createSortOptionsPanel(EnrichmentMapParameters params) {
        TitledBorder RankBorder = BorderFactory.createTitledBorder("Sorting");
        HashMap<String, HashMap<Integer, Ranking>> ranks = params.getRanks();
        RankBorder.setTitleJustification(1);
        this.RankOptions = new JPanel();
        this.rankOptionComboBox = new JComboBox();
        JPanel ComboButton = new JPanel();
        this.rankOptionComboBox.addItem(sort_hierarchical_cluster);
        if (ranks != null) {
            TreeMap<String, HashMap<Integer, Ranking>> ranks_ordered = new TreeMap<String, HashMap<Integer, Ranking>>();
            ranks_ordered.putAll(ranks);
            Iterator j = ranks_ordered.keySet().iterator();
            while (j.hasNext()) {
                String ranks_name = ((String)j.next()).toString();
                this.rankOptionComboBox.addItem(ranks_name);
            }
        }
        this.rankOptionComboBox.addItem(sort_none);
        switch (this.sort) {
            case DEFAULT: {
                this.rankOptionComboBox.setSelectedItem(params.getDefaultSortMethod());
                if (params.getDefaultSortMethod().equalsIgnoreCase(sort_rank)) {
                    this.sort = Sort.RANK;
                    if (ranks != null) {
                        this.rankFileIndex = ranks.keySet().iterator().next();
                        this.sortIndex = this.ascending.length - ranks.size();
                        break;
                    }
                    this.rankOptionComboBox.setSelectedItem(sort_none);
                    this.sort = Sort.NONE;
                    break;
                }
                if (params.getDefaultSortMethod().equalsIgnoreCase(sort_none)) {
                    this.sort = Sort.NONE;
                    break;
                }
                if (!params.getDefaultSortMethod().equalsIgnoreCase(sort_hierarchical_cluster)) break;
                this.sort = Sort.CLUSTER;
                break;
            }
            case CLUSTER: {
                this.rankOptionComboBox.setSelectedItem(sort_hierarchical_cluster);
                break;
            }
            case NONE: {
                this.rankOptionComboBox.setSelectedItem(sort_none);
                break;
            }
            case RANK: {
                Iterator<String> j = ranks.keySet().iterator();
                while (j.hasNext()) {
                    String ranks_name = j.next().toString();
                    if (!ranks_name.equalsIgnoreCase(this.rankFileIndex)) continue;
                    this.rankOptionComboBox.setSelectedItem(ranks_name);
                }
                break;
            }
            case COLUMN: {
                this.rankOptionComboBox.addItem(sort_column + ":" + this.sortbycolumnName);
                this.rankOptionComboBox.setSelectedItem(sort_column + ":" + this.sortbycolumnName);
            }
        }
        this.rankOptionComboBox.addItem("Add Rankings ... ");
        ComboButton.add(this.rankOptionComboBox);
        if (this.sort == Sort.RANK || this.sort == Sort.COLUMN) {
            JButton arrow = this.isAscending(this.sortIndex) ? this.createArrowButton(0) : this.createArrowButton(1);
            ComboButton.add(arrow);
            arrow.addActionListener(new ChangeSortAction(arrow));
        }
        this.rankOptionComboBox.addActionListener(new HeatMapActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this.rankOptionComboBox, this, params));
        ComboButton.revalidate();
        this.RankOptions.add(ComboButton);
        this.RankOptions.setBorder(RankBorder);
        this.RankOptions.revalidate();
        return this.RankOptions;
    }

    private JButton createArrowButton(int direction) {
        JButton button = new JButton(this.iconArrow[direction]);
        button.setBorder(BorderFactory.createEmptyBorder(0, 1, 5, 1));
        button.setVerticalTextPosition(0);
        button.setHorizontalTextPosition(2);
        button.setMargin(new Insets(0, 0, 3, 0));
        Font font = BorderFactory.createTitledBorder("Sample").getTitleFont();
        Color color = BorderFactory.createTitledBorder("Sample").getTitleColor();
        button.setFont(font);
        button.setForeground(color);
        button.setFocusable(false);
        button.setContentAreaFilled(false);
        return button;
    }

    private ImageIcon[] createExpandAndCollapseIcon() {
        ImageIcon[] iconArrow = new ImageIcon[2];
        URL iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_up.gif");
        if (iconURL != null) {
            iconArrow[0] = new ImageIcon(iconURL);
        }
        if ((iconURL = Enrichment_Map_Plugin.class.getResource("resources/arrow_down.gif")) != null) {
            iconArrow[1] = new ImageIcon(iconURL);
        }
        return iconArrow;
    }

    public JPanel createDataTransformationOptionsPanel(EnrichmentMapParameters params) {
        TitledBorder HMBorder = BorderFactory.createTitledBorder("Normalization");
        HMBorder.setTitleJustification(1);
        this.heatmapOptions = new JPanel();
        this.hmOptionComboBox = new JComboBox();
        this.hmOptionComboBox.addItem("Data As Is");
        this.hmOptionComboBox.addItem("Row Normalize Data");
        this.hmOptionComboBox.addItem("Log Transform Data");
        switch (this.transformation) {
            case ASIS: {
                this.hmOptionComboBox.setSelectedItem("Data As Is");
                break;
            }
            case ROWNORM: {
                this.hmOptionComboBox.setSelectedItem("Row Normalize Data");
                break;
            }
            case LOGTRANSFORM: {
                this.hmOptionComboBox.setSelectedItem("Log Transform Data");
            }
        }
        this.hmOptionComboBox.addActionListener(new HeatMapActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this.hmOptionComboBox, this, params));
        this.heatmapOptions.add(this.hmOptionComboBox);
        this.heatmapOptions.setBorder(HMBorder);
        return this.heatmapOptions;
    }

    public void changeSortComboBoxToColumnSorted() {
        this.rankOptionComboBox.addItem(sort_column + ":" + this.sortbycolumnName);
        this.rankOptionComboBox.setSelectedItem(sort_column + ":" + this.sortbycolumnName);
    }

    public void changeSortComboBoxToNoSort() {
        this.rankOptionComboBox.setSelectedItem(sort_none);
    }

    public HeatMapPanel getEdgeOverlapPanel() {
        return this.edgeOverlapPanel;
    }

    public HeatMapPanel getNodeOverlapPanel() {
        return this.nodeOverlapPanel;
    }

    public ColorGradientRange getRange() {
        return this.range;
    }

    public void setRange(ColorGradientRange range) {
        this.range = range;
    }

    public ColorGradientTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ColorGradientTheme theme) {
        this.theme = theme;
    }

    public Transformation getTransformation() {
        return this.transformation;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = transformation;
    }

    public Sort getSort() {
        return this.sort;
    }

    public void setSort(Sort sort) {
        this.sort = sort;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public boolean isSortbycolumn_event_triggered() {
        return this.sortbycolumn_event_triggered;
    }

    public void setSortbycolumn_event_triggered(boolean sortbycolumn_event_triggered) {
        this.sortbycolumn_event_triggered = sortbycolumn_event_triggered;
    }

    public String getSortbycolumnName() {
        return this.sortbycolumnName;
    }

    public void setSortbycolumnName(String sortbycolumnName) {
        this.sortbycolumnName = sortbycolumnName;
    }

    public String getRankFileIndex() {
        return this.rankFileIndex;
    }

    public void setRankFileIndex(String rankFileIndex) {
        this.rankFileIndex = rankFileIndex;
    }

    public boolean[] getAscending() {
        return this.ascending;
    }

    public void setAscending(boolean[] ascending) {
        this.ascending = ascending;
    }

    public boolean isAscending(int index) {
        if (index == -1) {
            return true;
        }
        return this.ascending[index];
    }

    public void flipAscending(int index) {
        this.ascending[index] = !this.ascending[index];
        this.edgeOverlapPanel.updatePanel();
        this.nodeOverlapPanel.updatePanel();
    }

    private class ChangeSortAction
    extends AbstractAction
    implements ActionListener,
    ItemListener {
        private static final long serialVersionUID = -8951978251258210440L;
        private JButton arrow;

        private ChangeSortAction(JButton arrow) {
            this.arrow = arrow;
        }

        public void actionPerformed(ActionEvent e) {
            HeatMapParameters.this.flipAscending(HeatMapParameters.this.getSortIndex());
            if (HeatMapParameters.this.isAscending(HeatMapParameters.this.getSortIndex())) {
                this.arrow.setIcon(HeatMapParameters.this.iconArrow[0]);
            } else {
                this.arrow.setIcon(HeatMapParameters.this.iconArrow[1]);
            }
            HeatMapParameters.this.edgeOverlapPanel.clearPanel();
            HeatMapParameters.this.nodeOverlapPanel.clearPanel();
            HeatMapParameters.this.edgeOverlapPanel.updatePanel();
            HeatMapParameters.this.nodeOverlapPanel.updatePanel();
        }

        public void itemStateChanged(ItemEvent e) {
            HeatMapParameters.this.flipAscending(HeatMapParameters.this.getSortIndex());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Sort {
        RANK,
        COLUMN,
        CLUSTER,
        NONE,
        DEFAULT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Transformation {
        ROWNORM,
        ASIS,
        LOGTRANSFORM;

    }
}

