/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.SliderBarPanel;

public class SliderBarActionListener
implements ChangeListener {
    private SliderBarPanel panel;
    private EnrichmentMapParameters params;
    private ArrayList<HiddenNodes> hiddenNodes;
    private ArrayList<Edge> hiddenEdges;
    private String attrib_dataset1;
    private String attrib_dataset2;

    public SliderBarActionListener(SliderBarPanel panel, EnrichmentMapParameters params, String attrib1, String attrib2) {
        this.panel = panel;
        this.params = params;
        this.hiddenNodes = new ArrayList();
        this.hiddenEdges = new ArrayList();
        this.attrib_dataset1 = attrib1;
        this.attrib_dataset2 = attrib2;
    }

    public void stateChanged(ChangeEvent e) {
        JSlider source = (JSlider)e.getSource();
        Double max_cutoff = (double)source.getValue() / this.panel.getPrecision();
        Double min_cutoff = (double)source.getMinimum() / this.panel.getPrecision();
        this.panel.setLabel(source.getValue());
        CyNetwork network = Cytoscape.getCurrentNetwork();
        CyNetworkView view = Cytoscape.getCurrentNetworkView();
        CyAttributes attributes = Cytoscape.getNodeAttributes();
        int[] nodes = network.getNodeIndicesArray();
        String prefix = this.params.getAttributePrefix();
        for (int i = 0; i < nodes.length; ++i) {
            Double pvalue_dataset1;
            Node currentNode = network.getNode(nodes[i]);
            NodeView currentView = view.getNodeView(currentNode);
            if (attributes.hasAttribute(currentNode.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE) && !EnrichmentMapVisualStyle.GS_TYPE_ENRICHMENT.equalsIgnoreCase(attributes.getStringAttribute(currentNode.getIdentifier(), prefix + EnrichmentMapVisualStyle.GS_TYPE)) || !((pvalue_dataset1 = attributes.getDoubleAttribute(currentNode.getIdentifier(), prefix + this.attrib_dataset1)) > max_cutoff) && !(pvalue_dataset1 < min_cutoff)) continue;
            if (this.params.isTwoDatasets()) {
                Double pvalue_dataset2 = attributes.getDoubleAttribute(currentNode.getIdentifier(), prefix + this.attrib_dataset2);
                if (!(pvalue_dataset2 > max_cutoff) && !(pvalue_dataset2 < min_cutoff)) continue;
                int[] edges = network.getAdjacentEdgeIndicesArray(currentNode.getRootGraphIndex(), true, true, true);
                for (int m = 0; m < edges.length; ++m) {
                    this.hiddenEdges.add(network.getEdge(edges[m]));
                }
                this.hiddenNodes.add(new HiddenNodes(currentNode, currentView.getXPosition(), currentView.getYPosition()));
                network.hideNode(currentNode);
                continue;
            }
            int[] edges = network.getAdjacentEdgeIndicesArray(currentNode.getRootGraphIndex(), true, true, true);
            for (int m = 0; m < edges.length; ++m) {
                this.hiddenEdges.add(network.getEdge(edges[m]));
            }
            this.hiddenNodes.add(new HiddenNodes(currentNode, currentView.getXPosition(), currentView.getYPosition()));
            network.hideNode(currentNode);
        }
        ArrayList<HiddenNodes> unhiddenNodes = new ArrayList<HiddenNodes>();
        ArrayList<Edge> unhiddenEdges = new ArrayList<Edge>();
        for (HiddenNodes currentHN : this.hiddenNodes) {
            Double pvalue_dataset2;
            Node currentNode = currentHN.getNode();
            Double pvalue_dataset1 = attributes.getDoubleAttribute(currentNode.getIdentifier(), prefix + this.attrib_dataset1);
            if (pvalue_dataset1 <= max_cutoff && pvalue_dataset1 >= min_cutoff) {
                network.restoreNode(currentNode);
                NodeView currentNodeView = view.getNodeView(currentNode);
                currentNodeView.setXPosition(currentHN.getX());
                currentNodeView.setYPosition(currentHN.getY());
                view.updateView();
                unhiddenNodes.add(currentHN);
            }
            if (!this.params.isTwoDatasets() || !((pvalue_dataset2 = attributes.getDoubleAttribute(currentNode.getIdentifier(), prefix + this.attrib_dataset2)) <= max_cutoff) || !(pvalue_dataset2 >= min_cutoff)) continue;
            network.restoreNode(currentNode);
            NodeView currentNodeView = view.getNodeView(currentNode);
            currentNodeView.setXPosition(currentHN.getX());
            currentNodeView.setYPosition(currentHN.getY());
            unhiddenNodes.add(currentHN);
        }
        for (Edge currentEdge : this.hiddenEdges) {
            if (network.getNode(currentEdge.getSource().getRootGraphIndex()) == null || network.getNode(currentEdge.getTarget().getRootGraphIndex()) == null) continue;
            network.restoreEdge(currentEdge);
            unhiddenEdges.add(currentEdge);
        }
        Iterator<Object> k = unhiddenNodes.iterator();
        while (k.hasNext()) {
            this.hiddenNodes.remove(k.next());
        }
        k = unhiddenEdges.iterator();
        while (k.hasNext()) {
            this.hiddenEdges.remove(k.next());
        }
        view.redrawGraph(true, true);
        view.updateView();
    }

    private class HiddenNodes {
        Node node;
        double x;
        double y;

        public HiddenNodes(Node node, double x, double y) {
            this.node = node;
            this.x = x;
            this.y = y;
        }

        public Node getNode() {
            return this.node;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }
    }
}

