/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.CytoscapeInit;
import giny.model.Edge;
import giny.model.Node;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.SliderBarPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnrichmentMapParameters {
    private String NetworkName;
    private String attributePrefix;
    private String GMTFileName;
    private boolean Data = false;
    private String GCTFileName1;
    private boolean Data2 = false;
    private String GCTFileName2;
    private String enrichmentDataset1FileName1;
    private String enrichmentDataset1FileName2;
    private String enrichmentDataset2FileName1;
    private String enrichmentDataset2FileName2;
    private boolean twoDatasets = false;
    private double pvalue;
    private SliderBarPanel pvalueSlider;
    private boolean FDR = false;
    private double qvalue;
    private SliderBarPanel qvalueSlider;
    private double similarityCutOff;
    private boolean jaccard;
    private boolean similarityCutOffChanged = false;
    private boolean GSEA = true;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private HashSet<Integer> datasetGenes;
    private int NumberOfGenes = 0;
    private HashMap enrichmentResults1 = new HashMap();
    private HashMap enrichmentResults2 = new HashMap();
    private HashMap<String, GeneSet> genesets;
    private HashMap<String, GeneSet> filteredGenesets;
    private HashMap enrichmentResults1OfInterest;
    private HashMap enrichmentResults2OfInterest;
    private HashMap<String, GeneSet> genesetsOfInterest;
    private GeneExpressionMatrix expression;
    private GeneExpressionMatrix expression2;
    private String dataset1Phenotype1 = "UP";
    private String dataset1Phenotype2 = "DOWN";
    private String dataset2Phenotype1 = "UP";
    private String dataset2Phenotype2 = "DOWN";
    private String classFile1;
    private String classFile2;
    private String[] temp_class1 = null;
    private String[] temp_class2 = null;
    private HashMap<String, GenesetSimilarity> genesetSimilarity = null;
    private ArrayList<Node> selectedNodes;
    private ArrayList<Edge> selectedEdges;
    private HeatMapParameters hmParams;
    private String dataset1RankedFile = null;
    private String dataset2RankedFile = null;
    private HashMap<Integer, Ranking> dataset1Rankings;
    private HashMap<Integer, Ranking> dataset2Rankings;
    private HashMap<String, HashMap<Integer, Ranking>> ranks;
    private Properties cyto_prop;
    private double defaultPvalueCutOff;
    private double defaultQvalueCutOff;
    private double defaultJaccardCutOff;
    private double defaultOverlapCutOff;
    private String default_overlap_metric;
    private Boolean disable_heatmap_autofocus;
    private Boolean disable_genesetSummary_autofocus;
    public static final String ENRICHMENT_INTERACTION_TYPE = "pp";

    public EnrichmentMapParameters() {
        this.genes = new HashMap();
        this.hashkey2gene = new HashMap();
        this.datasetGenes = new HashSet();
        this.genesets = new HashMap();
        this.filteredGenesets = new HashMap();
        this.enrichmentResults1OfInterest = new HashMap();
        this.enrichmentResults2OfInterest = new HashMap();
        this.genesetsOfInterest = new HashMap();
        this.selectedNodes = new ArrayList();
        this.selectedEdges = new ArrayList();
        this.ranks = new HashMap();
        this.cyto_prop = CytoscapeInit.getProperties();
        this.defaultPvalueCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_pvalue", "0.05"));
        this.defaultQvalueCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_qvalue", "0.25"));
        this.defaultJaccardCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_jaccard", "0.25"));
        this.defaultOverlapCutOff = Double.parseDouble(this.cyto_prop.getProperty("EnrichmentMap.default_overlap", "0.50"));
        this.default_overlap_metric = this.cyto_prop.getProperty("EnrichmentMap.default_overlap_metric", "jaccard");
        this.disable_heatmap_autofocus = Boolean.parseBoolean(this.cyto_prop.getProperty("EnrichmentMap.disable_heatmap_autofocus", "false"));
        this.pvalue = this.defaultPvalueCutOff;
        this.qvalue = this.defaultQvalueCutOff;
        if (this.getOverlapMetricDefault().equalsIgnoreCase("overlap")) {
            this.similarityCutOff = this.defaultOverlapCutOff;
            this.jaccard = false;
        } else {
            this.similarityCutOff = this.defaultJaccardCutOff;
            this.jaccard = true;
        }
    }

    public EnrichmentMapParameters(String propFile) {
        this();
        String[] set;
        HashMap<String, String> props = new HashMap<String, String>();
        String[] lines = propFile.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (tokens.length != 2) continue;
            props.put(tokens[0], tokens[1]);
        }
        this.NetworkName = (String)props.get("NetworkName");
        this.attributePrefix = (String)props.get("attributePrefix");
        this.GMTFileName = (String)props.get("GMTFileName");
        this.GCTFileName1 = (String)props.get("GCTFileName1");
        this.enrichmentDataset1FileName1 = (String)props.get("enerichmentDataset1FileName1");
        this.enrichmentDataset1FileName2 = (String)props.get("enrichmentDataset1FileName2");
        this.dataset1Phenotype1 = (String)props.get("dataset1Phenotype1");
        this.dataset1Phenotype2 = (String)props.get("dataset1Phenotype2");
        this.dataset2Phenotype1 = (String)props.get("dataset2Phenotype1");
        this.dataset2Phenotype2 = (String)props.get("dataset2Phenotype2");
        if (props.get("rankFile1") != null) {
            this.dataset1RankedFile = ((String)props.get("rankFile1")).equalsIgnoreCase("null") ? null : (String)props.get("rankFile1");
        }
        if (props.get("classFile1") != null) {
            this.classFile1 = ((String)props.get("classFile1")).equalsIgnoreCase("null") ? null : (String)props.get("classFile1");
        }
        if (props.get("classFile2") != null) {
            this.classFile2 = ((String)props.get("classFile2")).equalsIgnoreCase("null") ? null : (String)props.get("classFile2");
        }
        if (props.get("class1") != null) {
            if (((String)props.get("class1")).equalsIgnoreCase("null")) {
                this.temp_class1 = null;
            } else {
                String classes = (String)props.get("class1");
                set = classes.split(",");
                this.temp_class1 = new String[set.length];
                for (int i = 0; i < set.length; ++i) {
                    this.temp_class1[i] = set[i];
                }
            }
        }
        if (props.get("class2") != null) {
            if (((String)props.get("class2")).equalsIgnoreCase("null")) {
                this.temp_class2 = null;
            } else {
                String classes = (String)props.get("class2");
                set = classes.split(",");
                this.temp_class2 = new String[set.length];
                for (int i = 0; i < set.length; ++i) {
                    this.temp_class2[i] = set[i];
                }
            }
        }
        if (((String)props.get("twoDatasets")).equalsIgnoreCase("true")) {
            this.twoDatasets = true;
        }
        if (((String)props.get("jaccard")).equalsIgnoreCase("false")) {
            this.jaccard = false;
        }
        if (((String)props.get("GSEA")).equalsIgnoreCase("false")) {
            this.GSEA = false;
        }
        if (((String)props.get("Data")).equalsIgnoreCase("true")) {
            this.Data = true;
        }
        if (((String)props.get("Data2")).equalsIgnoreCase("true")) {
            this.Data2 = true;
        }
        if (((String)props.get("FDR")).equalsIgnoreCase("true")) {
            this.FDR = true;
        }
        if (this.twoDatasets) {
            if (this.Data2) {
                this.GCTFileName2 = (String)props.get("GCTFileName2");
            }
            this.enrichmentDataset2FileName1 = (String)props.get("enerichmentDataset2FileName1");
            this.enrichmentDataset2FileName2 = (String)props.get("enrichmentDataset2FileName2");
            if (props.get("rankFile2") != null) {
                this.dataset2RankedFile = ((String)props.get("rankFile2")).equalsIgnoreCase("null") ? null : (String)props.get("rankFile2");
            }
        }
        this.setPvalue(Double.parseDouble((String)props.get("pvalue")));
        this.setQvalue(Double.parseDouble((String)props.get("qvalue")));
        String cutoff = null;
        cutoff = props.get("jaccardCutOff") != null ? (String)props.get("jaccardCutOff") : (String)props.get("similarityCutOff");
        if (cutoff != null) {
            this.similarityCutOff = Double.parseDouble(cutoff);
            this.similarityCutOffChanged = true;
        }
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth);
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth);
    }

    public EnrichmentMapParameters(EnrichmentMapParameters copy) {
        this();
        this.GMTFileName = copy.getGMTFileName();
        this.GCTFileName1 = copy.getGCTFileName1();
        this.GCTFileName2 = copy.getGCTFileName2();
        this.dataset1RankedFile = copy.getDataset1RankedFile();
        this.dataset2RankedFile = copy.getDataset2RankedFile();
        this.ranks = copy.getRanks();
        this.enrichmentDataset1FileName1 = copy.getEnrichmentDataset1FileName1();
        this.enrichmentDataset1FileName2 = copy.getEnrichmentDataset1FileName2();
        this.enrichmentDataset2FileName1 = copy.getEnrichmentDataset2FileName1();
        this.enrichmentDataset2FileName2 = copy.getEnrichmentDataset2FileName2();
        this.dataset1Phenotype1 = copy.getDataset1Phenotype1();
        this.dataset1Phenotype2 = copy.getDataset1Phenotype2();
        this.dataset2Phenotype1 = copy.getDataset2Phenotype1();
        this.dataset2Phenotype2 = copy.getDataset2Phenotype2();
        this.pvalue = copy.getPvalue();
        this.pvalueSlider = new SliderBarPanel(0.0, this.pvalue, "P-value Cutoff", this, EnrichmentMapVisualStyle.PVALUE_DATASET1, EnrichmentMapVisualStyle.PVALUE_DATASET2, ParametersPanel.summaryPanelWidth);
        this.qvalue = copy.getQvalue();
        this.qvalueSlider = new SliderBarPanel(0.0, this.qvalue, "Q-value Cutoff", this, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET1, EnrichmentMapVisualStyle.FDR_QVALUE_DATASET2, ParametersPanel.summaryPanelWidth);
        this.similarityCutOff = copy.getSimilarityCutOff();
        this.Data = copy.isData();
        this.Data2 = copy.isData2();
        this.twoDatasets = copy.isTwoDatasets();
        this.GSEA = copy.isGSEA();
        this.jaccard = copy.isJaccard();
        this.similarityCutOffChanged = copy.similarityCutOffChanged;
        this.genes = copy.getGenes();
        this.hashkey2gene = copy.getHashkey2gene();
        this.genesetsOfInterest = copy.getGenesetsOfInterest();
        this.datasetGenes = copy.getDatasetGenes();
        this.classFile1 = copy.getClassFile1();
        this.classFile2 = copy.getClassFile2();
    }

    public String checkMinimalRequirements() {
        String errors = "";
        if (this.GMTFileName.equalsIgnoreCase("") || !this.checkFile(this.GMTFileName)) {
            errors = errors + "GMT file can not be found \n";
        }
        if (this.enrichmentDataset1FileName1.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset1FileName1)) {
            errors = errors + "Dataset 1, enrichment file 1 can not be found\n";
        }
        if (this.twoDatasets && (this.enrichmentDataset2FileName1.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset2FileName1))) {
            errors = errors + "Dataset 2, enrichment file 1 can not be found\n";
        }
        if (this.GSEA) {
            if (this.enrichmentDataset1FileName2.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset1FileName2)) {
                errors = errors + "Dataset 1, enrichment file 2 can not be found\n";
            }
            if (this.twoDatasets && (this.enrichmentDataset2FileName2.equalsIgnoreCase("") || !this.checkFile(this.enrichmentDataset2FileName2))) {
                errors = errors + "Dataset 2, enrichment file 2 can not be found\n";
            }
        }
        if (this.twoDatasets && this.GCTFileName1.equalsIgnoreCase(this.GCTFileName2)) {
            this.Data2 = false;
            this.GCTFileName2 = "";
        }
        return errors;
    }

    private boolean checkFile(String filename) {
        File tempfile;
        return filename == null || (tempfile = new File(filename)).canRead();
    }

    public EnrichmentMapParameters(String GMTFileName, double pvalue, double qvalue) {
        this();
        this.GMTFileName = GMTFileName;
        this.pvalue = pvalue;
        this.qvalue = qvalue;
    }

    public boolean isJaccard() {
        return this.jaccard;
    }

    public void setJaccard(boolean jaccard) {
        this.jaccard = jaccard;
    }

    public HashMap getEnrichmentResults1() {
        return this.enrichmentResults1;
    }

    public void setEnrichmentResults1(HashMap enrichmentResults1) {
        this.enrichmentResults1 = enrichmentResults1;
    }

    public HashMap getEnrichmentResults2() {
        return this.enrichmentResults2;
    }

    public void setEnrichmentResults2(HashMap enrichmentResults2) {
        this.enrichmentResults2 = enrichmentResults2;
    }

    public HashMap getEnrichmentResults1OfInterest() {
        return this.enrichmentResults1OfInterest;
    }

    public void setEnrichmentResults1OfInterest(HashMap enrichmentResults1OfInterest) {
        this.enrichmentResults1OfInterest = enrichmentResults1OfInterest;
    }

    public HashMap getEnrichmentResults2OfInterest() {
        return this.enrichmentResults2OfInterest;
    }

    public void setEnrichmentResults2OfInterest(HashMap enrichmentResults2OfInterest) {
        this.enrichmentResults2OfInterest = enrichmentResults2OfInterest;
    }

    public HashMap<String, GeneSet> getGenesetsOfInterest() {
        return this.genesetsOfInterest;
    }

    public void setGenesetsOfInterest(HashMap<String, GeneSet> genesetsOfInterest) {
        this.genesetsOfInterest = genesetsOfInterest;
    }

    public HashMap<String, GeneSet> getGenesets() {
        return this.genesets;
    }

    public void setGenesets(HashMap<String, GeneSet> genesets) {
        this.genesets = genesets;
    }

    public HashMap<String, GeneSet> getFilteredGenesets() {
        return this.filteredGenesets;
    }

    public void setFilteredGenesets(HashMap<String, GeneSet> filteredGenesets) {
        this.filteredGenesets = filteredGenesets;
    }

    public String getGMTFileName() {
        return this.GMTFileName;
    }

    public void setGMTFileName(String GMTFileName) {
        this.GMTFileName = GMTFileName;
    }

    public String getGCTFileName1() {
        return this.GCTFileName1;
    }

    public void setGCTFileName1(String GCTFileName) {
        this.GCTFileName1 = GCTFileName;
    }

    public String getGCTFileName2() {
        return this.GCTFileName2;
    }

    public void setGCTFileName2(String GCTFileName) {
        this.GCTFileName2 = GCTFileName;
    }

    public String getEnrichmentDataset1FileName1() {
        return this.enrichmentDataset1FileName1;
    }

    public void setEnrichmentDataset1FileName1(String enrichmentDataset1FileName1) {
        this.enrichmentDataset1FileName1 = enrichmentDataset1FileName1;
    }

    public String getEnrichmentDataset1FileName2() {
        return this.enrichmentDataset1FileName2;
    }

    public void setEnrichmentDataset1FileName2(String enrichmentDataset1FileName2) {
        this.enrichmentDataset1FileName2 = enrichmentDataset1FileName2;
    }

    public String getEnrichmentDataset2FileName1() {
        return this.enrichmentDataset2FileName1;
    }

    public void setEnrichmentDataset2FileName1(String enrichmentDataset2FileName1) {
        this.enrichmentDataset2FileName1 = enrichmentDataset2FileName1;
    }

    public String getEnrichmentDataset2FileName2() {
        return this.enrichmentDataset2FileName2;
    }

    public void setEnrichmentDataset2FileName2(String enrichmentDataset2FileName2) {
        this.enrichmentDataset2FileName2 = enrichmentDataset2FileName2;
    }

    public double getPvalue() {
        return this.pvalue;
    }

    public void setPvalue(double pvalue) {
        this.pvalue = pvalue;
    }

    public double getQvalue() {
        return this.qvalue;
    }

    public void setQvalue(double qvalue) {
        this.qvalue = qvalue;
    }

    public HashMap<String, Integer> getGenes() {
        return this.genes;
    }

    public void setGenes(HashMap<String, Integer> genes) {
        this.genes = genes;
    }

    public HashSet<Integer> getDatasetGenes() {
        return this.datasetGenes;
    }

    public void setDatasetGenes(HashSet<Integer> datasetGenes) {
        this.datasetGenes = datasetGenes;
    }

    public int getNumberOfGenes() {
        return this.NumberOfGenes;
    }

    public void setNumberOfGenes(int numberOfGenes) {
        this.NumberOfGenes = numberOfGenes;
    }

    public double getSimilarityCutOff() {
        return this.similarityCutOff;
    }

    public void setSimilarityCutOff(double similarityCutOff) {
        this.similarityCutOff = similarityCutOff;
    }

    public String getNetworkName() {
        return this.NetworkName;
    }

    public void setNetworkName(String networkName) {
        this.NetworkName = networkName;
    }

    public String getAttributePrefix() {
        return this.attributePrefix;
    }

    public void setAttributePrefix(String attributePrefix) {
        this.attributePrefix = attributePrefix;
    }

    public boolean isTwoDatasets() {
        return this.twoDatasets;
    }

    public void setTwoDatasets(boolean twoDatasets) {
        this.twoDatasets = twoDatasets;
    }

    public void noFilter() {
        this.filteredGenesets = this.genesets;
    }

    public void filterGenesets() {
        Iterator<String> j = this.genesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset2_name = j.next().toString();
            GeneSet current_set = this.genesets.get(geneset2_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            HashSet<Integer> intersection = new HashSet<Integer>(geneset_genes);
            intersection.retainAll(this.datasetGenes);
            HashSet<Integer> new_geneset = new HashSet<Integer>(intersection);
            GeneSet new_set = new GeneSet(geneset2_name, current_set.getDescription());
            new_set.setGenes(new_geneset);
            this.filteredGenesets.put(geneset2_name, new_set);
        }
        this.genesets.clear();
    }

    public boolean checkGenesets() {
        Iterator<String> j = this.filteredGenesets.keySet().iterator();
        while (j.hasNext()) {
            String geneset2_name = j.next().toString();
            GeneSet current_set = this.filteredGenesets.get(geneset2_name);
            HashSet<Integer> geneset_genes = current_set.getGenes();
            if (geneset_genes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        this.genesets.clear();
        this.genesetsOfInterest.clear();
        this.enrichmentResults1.clear();
        this.enrichmentResults2.clear();
        this.genes.clear();
        this.datasetGenes.clear();
        this.filteredGenesets.clear();
        this.enrichmentResults1OfInterest.clear();
        this.enrichmentResults2OfInterest.clear();
    }

    public boolean isGSEA() {
        return this.GSEA;
    }

    public void setGSEA(boolean GSEA) {
        this.GSEA = GSEA;
    }

    public boolean isData() {
        return this.Data;
    }

    public void setData(boolean data) {
        this.Data = data;
    }

    public boolean isData2() {
        return this.Data2;
    }

    public void setData2(boolean data2) {
        this.Data2 = data2;
    }

    public boolean isFDR() {
        return this.FDR;
    }

    public void setFDR(boolean FDR) {
        this.FDR = FDR;
    }

    public GeneExpressionMatrix getExpression() {
        return this.expression;
    }

    public void setExpression(GeneExpressionMatrix expression) {
        this.expression = expression;
    }

    public GeneExpressionMatrix getExpression2() {
        return this.expression2;
    }

    public void setExpression2(GeneExpressionMatrix expression2) {
        this.expression2 = expression2;
    }

    public HashMap<String, GenesetSimilarity> getGenesetSimilarity() {
        return this.genesetSimilarity;
    }

    public void setGenesetSimilarity(HashMap<String, GenesetSimilarity> genesetSimilarity) {
        this.genesetSimilarity = genesetSimilarity;
    }

    public String getClassFile1() {
        return this.classFile1;
    }

    public void setClassFile1(String classFile1) {
        this.classFile1 = classFile1;
    }

    public String getClassFile2() {
        return this.classFile2;
    }

    public void setClassFile2(String classFile2) {
        this.classFile2 = classFile2;
    }

    public String getDataset1Phenotype1() {
        return this.dataset1Phenotype1;
    }

    public void setDataset1Phenotype1(String dataset1Phenotype1) {
        this.dataset1Phenotype1 = dataset1Phenotype1;
    }

    public String getDataset1Phenotype2() {
        return this.dataset1Phenotype2;
    }

    public void setDataset1Phenotype2(String dataset1Phenotype2) {
        this.dataset1Phenotype2 = dataset1Phenotype2;
    }

    public String getDataset2Phenotype1() {
        return this.dataset2Phenotype1;
    }

    public void setDataset2Phenotype1(String dataset2Phenotype1) {
        this.dataset2Phenotype1 = dataset2Phenotype1;
    }

    public String getDataset2Phenotype2() {
        return this.dataset2Phenotype2;
    }

    public void setDataset2Phenotype2(String dataset2Phenotype2) {
        this.dataset2Phenotype2 = dataset2Phenotype2;
    }

    public SliderBarPanel getPvalueSlider() {
        return this.pvalueSlider;
    }

    public SliderBarPanel getQvalueSlider() {
        return this.qvalueSlider;
    }

    public ArrayList<Node> getSelectedNodes() {
        return this.selectedNodes;
    }

    public ArrayList<Edge> getSelectedEdges() {
        return this.selectedEdges;
    }

    public void setSelectedNodes(ArrayList<Node> selectedNodes) {
        this.selectedNodes = selectedNodes;
    }

    public void setSelectedEdges(ArrayList<Edge> selectedEdges) {
        this.selectedEdges = selectedEdges;
    }

    public HeatMapParameters getHmParams() {
        return this.hmParams;
    }

    public void setHmParams(HeatMapParameters hmParams) {
        this.hmParams = hmParams;
    }

    public String getDataset1RankedFile() {
        return this.dataset1RankedFile;
    }

    public void setDataset1RankedFile(String dataset1RankedFile) {
        this.dataset1RankedFile = dataset1RankedFile;
    }

    public String getDataset2RankedFile() {
        return this.dataset2RankedFile;
    }

    public void setDataset2RankedFile(String dataset2RankedFile) {
        this.dataset2RankedFile = dataset2RankedFile;
    }

    public HashMap getDataset1Rankings() {
        return this.dataset1Rankings;
    }

    public void setDataset1Rankings(HashMap<Integer, Ranking> dataset1Rankings) {
        this.dataset1Rankings = dataset1Rankings;
        if (this.ranks != null) {
            this.ranks.put("Dataset 1 Ranking", this.dataset1Rankings);
        }
    }

    public HashMap getDataset2Rankings() {
        return this.dataset2Rankings;
    }

    public void setDataset2Rankings(HashMap<Integer, Ranking> dataset2Rankings) {
        this.dataset2Rankings = dataset2Rankings;
        if (this.ranks != null) {
            this.ranks.put("Dataset 2 Ranking", this.dataset2Rankings);
        }
    }

    public String toString() {
        int j;
        String output;
        String[] current_pheno;
        String paramVariables = "";
        paramVariables = paramVariables + "NetworkName\t" + this.NetworkName + "\n";
        paramVariables = paramVariables + "attributePrefix\t" + this.attributePrefix + "\n";
        paramVariables = paramVariables + "GMTFileName\t" + this.GMTFileName + "\n";
        paramVariables = paramVariables + "GCTFileName1\t" + this.GCTFileName1 + "\n";
        paramVariables = paramVariables + "GCTFileName2\t" + this.GCTFileName2 + "\n";
        paramVariables = paramVariables + "enerichmentDataset1FileName1\t" + this.enrichmentDataset1FileName1 + "\n";
        paramVariables = paramVariables + "enrichmentDataset1FileName2\t" + this.enrichmentDataset1FileName2 + "\n";
        paramVariables = paramVariables + "enerichmentDataset2FileName1\t" + this.enrichmentDataset2FileName1 + "\n";
        paramVariables = paramVariables + "enrichmentDataset2FileName2\t" + this.enrichmentDataset2FileName2 + "\n";
        paramVariables = paramVariables + "dataset1Phenotype1\t" + this.dataset1Phenotype1 + "\n";
        paramVariables = paramVariables + "dataset1Phenotype2\t" + this.dataset1Phenotype2 + "\n";
        paramVariables = paramVariables + "dataset2Phenotype1\t" + this.dataset2Phenotype1 + "\n";
        paramVariables = paramVariables + "dataset2Phenotype2\t" + this.dataset2Phenotype2 + "\n";
        paramVariables = paramVariables + "classFile1\t" + this.classFile1 + "\n";
        paramVariables = paramVariables + "classFile2\t" + this.classFile2 + "\n";
        if (this.isData() && (current_pheno = this.expression.getPhenotypes()) != null) {
            output = "";
            for (j = 0; j < current_pheno.length; ++j) {
                output = output + current_pheno[j] + ",";
            }
            paramVariables = paramVariables + "class1\t" + output + "\n";
        }
        if (this.isData2() && (current_pheno = this.expression2.getPhenotypes()) != null) {
            output = "";
            for (j = 0; j < current_pheno.length; ++j) {
                output = output + current_pheno[j] + ",";
            }
            paramVariables = paramVariables + "class2\t" + output + "\n";
        }
        paramVariables = paramVariables + "rankFile1\t" + this.dataset1RankedFile + "\n";
        paramVariables = paramVariables + "rankFile2\t" + this.dataset2RankedFile + "\n";
        paramVariables = paramVariables + "twoDatasets\t" + this.twoDatasets + "\n";
        paramVariables = paramVariables + "jaccard\t" + this.jaccard + "\n";
        paramVariables = paramVariables + "GSEA\t" + this.GSEA + "\n";
        paramVariables = paramVariables + "Data\t" + this.Data + "\n";
        paramVariables = paramVariables + "Data2\t" + this.Data2 + "\n";
        paramVariables = paramVariables + "FDR\t" + this.FDR + "\n";
        paramVariables = paramVariables + "pvalue\t" + this.pvalue + "\n";
        paramVariables = paramVariables + "qvalue\t" + this.qvalue + "\n";
        paramVariables = paramVariables + "similarityCutOff\t" + this.similarityCutOff + "\n";
        return paramVariables;
    }

    public String printHashmap(HashMap map) {
        String result = "";
        for (Object key : map.keySet()) {
            result = result + key.toString() + "\t" + map.get(key).toString() + "\n";
        }
        return result;
    }

    public HashMap repopulateHashmap(String fileInput, int type) {
        HashMap<Object, Object> newMap = type == 0 ? new HashMap<Object, Object>() : (type == 1 ? new HashMap() : (type == 2 ? new HashMap() : (type == 3 ? new HashMap() : (type == 4 ? new HashMap() : (type == 5 ? new HashMap() : (type == 6 ? new HashMap() : new HashMap()))))));
        String[] lines = fileInput.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            String[] tokens = line.split("\t");
            if (type == 0) {
                newMap.put(tokens[0], new GenesetSimilarity(tokens));
            }
            if (type == 1 && tokens.length >= 3) {
                newMap.put(tokens[0], new GeneSet(tokens));
            }
            if (type == 2) {
                newMap.put(tokens[0], Integer.parseInt(tokens[1]));
            }
            if (type == 3) {
                newMap.put(tokens[0], new GSEAResult(tokens));
            }
            if (type == 4) {
                newMap.put(tokens[0], new GenericResult(tokens));
            }
            if (type == 5) {
                newMap.put(Integer.parseInt(tokens[0]), tokens[1]);
            }
            if (type != 6) continue;
            newMap.put(Integer.parseInt(tokens[0]), new Ranking(tokens));
        }
        return newMap;
    }

    public String getOverlapMetricDefault() {
        return this.default_overlap_metric;
    }

    public void setDefaultJaccardCutOff(double defaultJaccardCutOff) {
        this.defaultJaccardCutOff = defaultJaccardCutOff;
    }

    public double getDefaultJaccardCutOff() {
        return this.defaultJaccardCutOff;
    }

    public void setDefaultOverlapCutOff(double defaultOverlapCutOff) {
        this.defaultOverlapCutOff = defaultOverlapCutOff;
    }

    public double getDefaultOverlapCutOff() {
        return this.defaultOverlapCutOff;
    }

    public boolean isDisableHeatmapAutofocus() {
        return this.disable_heatmap_autofocus;
    }

    public void setSimilarityCutOffChanged(boolean similarityCutOffChanged) {
        this.similarityCutOffChanged = similarityCutOffChanged;
    }

    public boolean isSimilarityCutOffChanged() {
        return this.similarityCutOffChanged;
    }

    public HashMap<Integer, String> getHashkey2gene() {
        return this.hashkey2gene;
    }

    public void setHashkey2gene(HashMap<Integer, String> hashkey2gene) {
        this.hashkey2gene = hashkey2gene;
    }

    public String getGeneFromHashKey(Integer hash) {
        String gene = null;
        if (this.hashkey2gene != null || !this.hashkey2gene.isEmpty()) {
            gene = this.hashkey2gene.get(hash);
        }
        return gene;
    }

    public HashMap<String, HashMap<Integer, Ranking>> getRanks() {
        return this.ranks;
    }

    public void setRanks(HashMap<String, HashMap<Integer, Ranking>> ranks) {
        this.ranks = ranks;
    }

    public void addRanks(String ranks_name, HashMap<Integer, Ranking> new_rank) {
        if (this.ranks != null) {
            this.ranks.put(ranks_name, new_rank);
        }
    }

    public HashMap<Integer, Ranking> getRanksByName(String ranks_name) {
        if (this.ranks != null) {
            return this.ranks.get(ranks_name);
        }
        return null;
    }

    public String[] getTemp_class1() {
        return this.temp_class1;
    }

    public void setTemp_class1(String[] temp_class1) {
        this.temp_class1 = temp_class1;
    }

    public String[] getTemp_class2() {
        return this.temp_class2;
    }

    public void setTemp_class2(String[] temp_class2) {
        this.temp_class2 = temp_class2;
    }
}

