/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;

public class GMTFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String GMTFileName;
    private HashMap<String, Integer> genes;
    private HashMap<Integer, String> hashkey2gene;
    private String fullText;
    private String[] lines;
    private HashMap<String, GeneSet> genesets;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public GMTFileReaderTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(EnrichmentMapParameters params) {
        this.params = params;
        this.GMTFileName = params.getGMTFileName();
        this.genes = params.getGenes();
        this.hashkey2gene = params.getHashkey2gene();
        this.genesets = params.getGenesets();
        TextFileReader reader = new TextFileReader(this.GMTFileName);
        reader.read();
        this.fullText = reader.getText();
        this.lines = this.fullText.split("\n");
    }

    public GMTFileReaderTask(PostAnalysisParameters params, TaskMonitor taskMonitor, int genesets_file) {
        this(params, genesets_file);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(PostAnalysisParameters params, int genesets_file) {
        this.params = params;
        this.genes = params.getGenes();
        this.hashkey2gene = params.getHashkey2gene();
        if (genesets_file == 1) {
            this.GMTFileName = params.getGMTFileName();
            this.genesets = params.getGenesets();
        } else {
            this.GMTFileName = params.getSignatureGMTFileName();
            this.genesets = params.getSignatureGenesets();
        }
        TextFileReader reader = new TextFileReader(this.GMTFileName);
        reader.read();
        this.fullText = reader.getText();
        this.lines = this.fullText.split("\n");
    }

    public void parse() {
        int currentProgress = 0;
        this.maxValue = this.lines.length;
        try {
            for (int i = 0; i < this.lines.length; ++i) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String line = this.lines[i];
                String[] tokens = line.split("\t");
                String Name = tokens[0].toUpperCase().trim();
                String description = tokens[1].trim();
                GeneSet gs = new GeneSet(Name, description);
                int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
                long timeRemaining = this.maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + this.maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                for (int j = 2; j < tokens.length; ++j) {
                    if (this.genes.containsKey(tokens[j])) {
                        gs.addGene(this.genes.get(tokens[j]));
                        continue;
                    }
                    int value = this.params.getNumberOfGenes();
                    this.genes.put(tokens[j], value);
                    this.hashkey2gene.put(value, tokens[j]);
                    this.params.setNumberOfGenes(value + 1);
                    gs.addGene(this.genes.get(tokens[j]));
                }
                this.genesets.put(Name, gs);
            }
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException((Throwable)e, "Loading of GMT file cancelled");
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GMT file");
    }
}

