/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import java.awt.Component;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.OverlappingGenesPanel;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.selectDataViewActionListener;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class HeatMapParameters {
    private ColorGradientRange range;
    private ColorGradientTheme theme;
    private boolean rowNorm = false;
    private boolean asIS = false;
    private boolean logtransform = false;
    private boolean noSort = false;
    private boolean sortbyrank = false;
    private boolean sortbycolumn = false;
    private String sortbycolumnName;
    private boolean sortbycolumn_event_triggered = false;
    private int sortIndex = 0;
    private String rankFileIndex;
    private double minExpression;
    private double maxExpression;
    private double minExpression_rownorm;
    private double maxExpression_rownorm;
    private JPanel heatmapOptions;
    private JPanel RankOptions;
    private JComboBox hmOptionComboBox;
    private JComboBox rankOptionComboBox;
    private OverlappingGenesPanel edgeOverlapPanel;
    private OverlappingGenesPanel nodeOverlapPanel;

    public HeatMapParameters(OverlappingGenesPanel edgeOverlapPanel, OverlappingGenesPanel nodeOverlapPanel) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
    }

    public OverlappingGenesPanel getEdgeOverlapPanel() {
        return this.edgeOverlapPanel;
    }

    public OverlappingGenesPanel getNodeOverlapPanel() {
        return this.nodeOverlapPanel;
    }

    public void initColorGradients(GeneExpressionMatrix expression) {
        this.minExpression = expression.getMinExpression();
        this.maxExpression = expression.getMaxExpression();
        this.minExpression_rownorm = expression.getMinExpression(expression.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm = expression.getMaxExpression(expression.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        double median = 0.0;
        if (this.minExpression >= 0.0) {
            this.range = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient() {
        double max;
        double min;
        if (this.rowNorm) {
            min = this.minExpression_rownorm;
            max = this.maxExpression_rownorm;
            if (min == 0.0 && max == 0.0) {
                JOptionPane.showMessageDialog((Component)Cytoscape.getDesktop(), "Row normalization does not work with only one data column per dataset.", "Row normalization error", 2);
            }
            max = Math.max(Math.abs(min), max);
        } else if (this.logtransform) {
            min = Math.log1p(this.minExpression);
            max = Math.log1p(this.maxExpression);
            max = Math.max(Math.abs(min), max);
        } else {
            min = this.minExpression;
            max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public JPanel createRankOptionsPanel(EnrichmentMapParameters params) {
        String ranks_name;
        Iterator<String> j;
        TitledBorder RankBorder = BorderFactory.createTitledBorder("Sorting");
        HashMap<String, HashMap<Integer, Ranking>> ranks = params.getRanks();
        RankBorder.setTitleJustification(1);
        this.RankOptions = new JPanel();
        this.rankOptionComboBox = new JComboBox();
        this.rankOptionComboBox.addItem("Hierarchical Cluster");
        if (ranks != null) {
            j = ranks.keySet().iterator();
            while (j.hasNext()) {
                ranks_name = j.next().toString();
                this.rankOptionComboBox.addItem(ranks_name);
            }
        }
        if (this.noSort) {
            this.rankOptionComboBox.setSelectedItem("Hierarchical Cluster");
        } else if (this.sortbyrank) {
            j = ranks.keySet().iterator();
            while (j.hasNext()) {
                ranks_name = j.next().toString();
                if (!ranks_name.equalsIgnoreCase(this.rankFileIndex)) continue;
                this.rankOptionComboBox.setSelectedItem(ranks_name);
            }
        } else if (this.sortbycolumn) {
            this.rankOptionComboBox.addItem("Column: " + this.sortbycolumnName);
            this.rankOptionComboBox.setSelectedItem("Column: " + this.sortbycolumnName);
        }
        this.rankOptionComboBox.addItem("Add Rankings ... ");
        this.rankOptionComboBox.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this.rankOptionComboBox, this, params));
        this.RankOptions.add(this.rankOptionComboBox);
        this.RankOptions.setBorder(RankBorder);
        return this.RankOptions;
    }

    public JPanel createHeatMapOptionsPanel(EnrichmentMapParameters params) {
        TitledBorder HMBorder = BorderFactory.createTitledBorder("Normalization");
        HMBorder.setTitleJustification(1);
        this.heatmapOptions = new JPanel();
        this.hmOptionComboBox = new JComboBox();
        this.hmOptionComboBox.addItem("Data As Is");
        this.hmOptionComboBox.addItem("Row Normalize Data");
        this.hmOptionComboBox.addItem("Log Transform Data");
        if (this.isAsIS()) {
            this.hmOptionComboBox.setSelectedItem("Data As Is");
        } else if (this.isRowNorm()) {
            this.hmOptionComboBox.setSelectedItem("Row Normalize Data");
        } else if (this.isLogtransform()) {
            this.hmOptionComboBox.setSelectedItem("Log Transform Data");
        }
        this.hmOptionComboBox.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this.hmOptionComboBox, this, params));
        this.heatmapOptions.add(this.hmOptionComboBox);
        this.heatmapOptions.setBorder(HMBorder);
        return this.heatmapOptions;
    }

    public ColorGradientRange getRange() {
        return this.range;
    }

    public void setRange(ColorGradientRange range) {
        this.range = range;
    }

    public ColorGradientTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ColorGradientTheme theme) {
        this.theme = theme;
    }

    public boolean isRowNorm() {
        return this.rowNorm;
    }

    public void setRowNorm(boolean rowNorm) {
        this.rowNorm = rowNorm;
    }

    public boolean isLogtransform() {
        return this.logtransform;
    }

    public void setLogtransform(boolean logtransform) {
        this.logtransform = logtransform;
    }

    public void setAsIS(boolean asIS) {
        this.asIS = asIS;
    }

    public boolean isAsIS() {
        return this.asIS;
    }

    public boolean isNoSort() {
        return this.noSort;
    }

    public void setNoSort(boolean nosort) {
        this.noSort = nosort;
    }

    public boolean isSortbyrank() {
        return this.sortbyrank;
    }

    public void setSortbyrank(boolean sortbyrank) {
        this.sortbyrank = sortbyrank;
    }

    public boolean isSortbycolumn() {
        return this.sortbycolumn;
    }

    public void setSortbycolumn(boolean sortbycolumn) {
        this.sortbycolumn = sortbycolumn;
    }

    public int getSortIndex() {
        return this.sortIndex;
    }

    public void setSortIndex(int sortIndex) {
        this.sortIndex = sortIndex;
    }

    public void changeRankComboBoxToColumnSorted() {
        int columnNumber = this.sortIndex + 1;
        this.rankOptionComboBox.addItem("Column: " + this.sortbycolumnName);
        this.rankOptionComboBox.setSelectedItem("Column: " + this.sortbycolumnName);
    }

    public boolean isSortbycolumn_event_triggered() {
        return this.sortbycolumn_event_triggered;
    }

    public void setSortbycolumn_event_triggered(boolean sortbycolumn_event_triggered) {
        this.sortbycolumn_event_triggered = sortbycolumn_event_triggered;
    }

    public String getSortbycolumnName() {
        return this.sortbycolumnName;
    }

    public void setSortbycolumnName(String sortbycolumnName) {
        this.sortbycolumnName = sortbycolumnName;
    }

    public String getRankFileIndex() {
        return this.rankFileIndex;
    }

    public void setRankFileIndex(String rankFileIndex) {
        this.rankFileIndex = rankFileIndex;
    }
}

