/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GSEAResult;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenericResult;

public class InitializeGenesetsOfInterestTask
implements Task {
    EnrichmentMapParameters params;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public InitializeGenesetsOfInterestTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public InitializeGenesetsOfInterestTask(EnrichmentMapParameters params) {
        this.params = params;
    }

    public boolean initializeSets() {
        GeneSet current_set;
        Object current_result;
        String current_name;
        long timeRemaining;
        int percentComplete;
        if (this.taskMonitor == null) {
            throw new IllegalStateException("Task Monitor is not set");
        }
        HashMap enrichmentResults1 = this.params.getEnrichmentResults1();
        HashMap enrichmentResults2 = this.params.getEnrichmentResults2();
        HashMap<String, GeneSet> genesets = this.params.getFilteredGenesets();
        HashMap enrichmentResults1OfInterest = this.params.getEnrichmentResults1OfInterest();
        HashMap enrichmentResults2OfInterest = this.params.getEnrichmentResults2OfInterest();
        HashMap<String, GeneSet> genesetsOfInterest = this.params.getGenesetsOfInterest();
        int currentProgress = 0;
        int maxValue = enrichmentResults1.size() + enrichmentResults2.size();
        Iterator i = enrichmentResults1.keySet().iterator();
        while (i.hasNext()) {
            percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
            timeRemaining = maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            current_name = i.next().toString();
            if (this.params.isGSEA()) {
                current_result = (GSEAResult)enrichmentResults1.get(current_name);
                if (!((GSEAResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue())) continue;
                enrichmentResults1OfInterest.put(current_name, current_result);
                if (genesets.containsKey(current_name)) {
                    current_set = genesets.get(current_name);
                    genesetsOfInterest.put(current_name, current_set);
                    continue;
                }
                System.out.println(current_name);
                throw new IllegalThreadStateException("GMT file and GSEA Results file Do not match up.");
            }
            current_result = (GenericResult)enrichmentResults1.get(current_name);
            if (!((GenericResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue(), this.params.isFDR())) continue;
            enrichmentResults1OfInterest.put(current_name, current_result);
            if (genesets.containsKey(current_name)) {
                current_set = genesets.get(current_name);
                genesetsOfInterest.put(current_name, current_set);
                continue;
            }
            System.out.println(current_name);
            throw new IllegalThreadStateException("GMT file and Results file Do not match up.");
        }
        if (this.params.isTwoDatasets()) {
            Iterator j = enrichmentResults2.keySet().iterator();
            while (j.hasNext()) {
                percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Initializing genesets and gsea results of interest " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                current_name = j.next().toString();
                if (this.params.isGSEA()) {
                    current_result = (GSEAResult)enrichmentResults2.get(current_name);
                    if (!((GSEAResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue())) continue;
                    enrichmentResults2OfInterest.put(current_name, current_result);
                    if (genesets.containsKey(current_name)) {
                        current_set = genesets.get(current_name);
                        genesetsOfInterest.put(current_name, current_set);
                        continue;
                    }
                    System.out.println(current_name);
                    throw new IllegalThreadStateException("GMT file and GSEA Results file Do not match up.");
                }
                current_result = (GenericResult)enrichmentResults2.get(current_name);
                if (!((GenericResult)current_result).geneSetOfInterest(this.params.getPvalue(), this.params.getQvalue(), this.params.isFDR())) continue;
                enrichmentResults2OfInterest.put(current_name, current_result);
                if (genesets.containsKey(current_name)) {
                    current_set = genesets.get(current_name);
                    genesetsOfInterest.put(current_name, current_set);
                    continue;
                }
                System.out.println(current_name);
                throw new IllegalThreadStateException("GMT file and Results file Do not match up.");
            }
        }
        genesets.clear();
        return true;
    }

    public void run() {
        this.initializeSets();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Initializing subset of genesets and GSEA results of interest");
    }
}

