/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.GeneExpression;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneExpressionMatrix {
    private String[] columnNames;
    private int numConditions;
    private int numGenes;
    private HashMap<Integer, GeneExpression> expressionMatrix;
    private HashMap<Integer, GeneExpression> expressionMatrix_rowNormalized;
    private double maxExpression = 0.0;
    private double minExpression = 0.0;
    private String[] phenotypes;

    public GeneExpressionMatrix(String[] columnNames) {
        this.numConditions = columnNames.length;
        this.columnNames = columnNames;
        if (this.numConditions == 2) {
            this.numConditions = 3;
            String[] newNames = new String[3];
            if (columnNames[1].equalsIgnoreCase("description")) {
                newNames[0] = columnNames[0];
                newNames[1] = columnNames[1];
                newNames[2] = "NO DATA";
            } else {
                newNames[0] = columnNames[0];
                newNames[1] = "description";
                newNames[2] = columnNames[1];
            }
            this.columnNames = newNames;
        }
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public void setNumConditions(int numConditions) {
        this.numConditions = numConditions;
    }

    public int getNumGenes() {
        return this.numGenes;
    }

    public void setNumGenes(int numGenes) {
        this.numGenes = numGenes;
    }

    public HashMap getExpressionMatrix() {
        return this.expressionMatrix;
    }

    public void setExpressionMatrix(HashMap expressionMatrix) {
        this.expressionMatrix = expressionMatrix;
    }

    public HashMap getExpressionMatrix_rowNormalized() {
        return this.expressionMatrix_rowNormalized;
    }

    public void setExpressionMatrix_rowNormalized(HashMap expressionMatrix_rowNormalized) {
        this.expressionMatrix_rowNormalized = expressionMatrix_rowNormalized;
    }

    public HashMap getExpressionMatrix(HashSet<Integer> subset) {
        HashMap<Integer, GeneExpression> expression_subset = new HashMap<Integer, GeneExpression>();
        for (Integer k : subset) {
            if (this.expressionMatrix.containsKey(k)) {
                expression_subset.put(k, this.expressionMatrix.get(k));
                continue;
            }
            System.out.println("how is this key not in the hashmap?");
        }
        return expression_subset;
    }

    public double getMaxExpression() {
        return this.maxExpression;
    }

    public void setMaxExpression(double maxExpression) {
        this.maxExpression = maxExpression;
    }

    public double getMinExpression() {
        return this.minExpression;
    }

    public void setMinExpression(double minExpression) {
        this.minExpression = minExpression;
    }

    public double getMeanExpression(HashMap currentMatrix) {
        double sum = 0.0;
        int k = 0;
        Iterator i = currentMatrix.keySet().iterator();
        while (i.hasNext()) {
            Double[] currentRow = ((GeneExpression)currentMatrix.get(i.next())).getExpression();
            for (int j = 0; j < currentRow.length; ++j) {
                sum += currentRow[j].doubleValue();
                ++k;
            }
        }
        return sum / (double)k;
    }

    public double getMaxExpression(HashMap currentMatrix) {
        double max = 0.0;
        if (currentMatrix != null) {
            Iterator i = currentMatrix.keySet().iterator();
            while (i.hasNext()) {
                Double[] currentRow = ((GeneExpression)currentMatrix.get(i.next())).getExpression();
                for (int j = 0; j < currentRow.length; ++j) {
                    if (!(max < currentRow[j])) continue;
                    max = currentRow[j];
                }
            }
        }
        return max;
    }

    public double getMinExpression(HashMap currentMatrix) {
        double min = 0.0;
        if (currentMatrix != null) {
            Iterator i = currentMatrix.keySet().iterator();
            while (i.hasNext()) {
                Double[] currentRow = ((GeneExpression)currentMatrix.get(i.next())).getExpression();
                for (int j = 0; j < currentRow.length; ++j) {
                    if (!(min > currentRow[j])) continue;
                    min = currentRow[j];
                }
            }
        }
        return min;
    }

    public double getSTDExpression(double mean, HashMap currentMatrix) {
        double sum = 0.0;
        int k = 0;
        Iterator i = currentMatrix.keySet().iterator();
        while (i.hasNext()) {
            Double[] currentRow = ((GeneExpression)currentMatrix.get(i.next())).getExpression();
            for (int j = 0; j < currentRow.length; ++j) {
                sum += Math.pow(currentRow[j] - mean, 2.0);
                ++k;
            }
        }
        return Math.sqrt(sum) / (double)k;
    }

    public void rowNormalizeMatrix() {
        if (this.expressionMatrix == null) {
            return;
        }
        this.expressionMatrix_rowNormalized = new HashMap();
        boolean k = false;
        for (Integer key : this.expressionMatrix.keySet()) {
            GeneExpression currentexpression = this.expressionMatrix.get(key);
            String Name = currentexpression.getName();
            String description = currentexpression.getDescription();
            GeneExpression norm_row = new GeneExpression(Name, description);
            Double[] currentexpression_row_normalized = currentexpression.rowNormalize();
            norm_row.setExpression(currentexpression_row_normalized);
            this.expressionMatrix_rowNormalized.put(key, norm_row);
        }
    }

    public String[] getPhenotypes() {
        return this.phenotypes;
    }

    public void setPhenotypes(String[] phenotypes) {
        this.phenotypes = phenotypes;
    }

    public String toString() {
        String expressionString = "";
        for (int i = 0; i < this.columnNames.length; ++i) {
            expressionString = expressionString + this.columnNames[i] + "\t";
        }
        expressionString = expressionString + "\n";
        Iterator<Integer> i = this.expressionMatrix.keySet().iterator();
        while (i.hasNext()) {
            expressionString = expressionString + this.expressionMatrix.get(i.next()).toString();
        }
        return expressionString;
    }
}

