/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.Dimension;
import java.awt.GridLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.baderlab.csplugins.enrichmentmap.GeneExpressionMatrix;
import org.baderlab.csplugins.enrichmentmap.OverlappingGenesPanel;
import org.baderlab.csplugins.enrichmentmap.selectDataViewActionListener;
import org.mskcc.colorgradient.ColorGradientRange;
import org.mskcc.colorgradient.ColorGradientTheme;

public class HeatMapParameters {
    private ColorGradientRange range;
    private ColorGradientTheme theme;
    private boolean rowNorm = false;
    private boolean logtransform = false;
    private int num_ranks = 0;
    private boolean rank_dataset1 = false;
    private boolean rank_dataset2 = false;
    private double minExpression;
    private double maxExpression;
    private double minExpression_rownorm;
    private double maxExpression_rownorm;
    private OverlappingGenesPanel edgeOverlapPanel;
    private OverlappingGenesPanel nodeOverlapPanel;

    public HeatMapParameters(OverlappingGenesPanel edgeOverlapPanel, OverlappingGenesPanel nodeOverlapPanel) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
    }

    public void initColorGradients(GeneExpressionMatrix expression) {
        this.minExpression = expression.getMinExpression();
        this.maxExpression = expression.getMaxExpression();
        this.minExpression_rownorm = expression.getMinExpression(expression.getExpressionMatrix_rowNormalized());
        this.maxExpression_rownorm = expression.getMaxExpression(expression.getExpressionMatrix_rowNormalized());
        double max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        double median = 0.0;
        if (this.minExpression >= 0.0) {
            this.range = ColorGradientRange.getInstance(0.0, max / 2.0, max / 2.0, max, 0.0, max / 2.0, max / 2.0, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            this.range = ColorGradientRange.getInstance(-max, median, median, max, -max, median, median, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public void ResetColorGradient() {
        double max;
        double min;
        if (this.rowNorm) {
            min = this.minExpression_rownorm;
            max = this.maxExpression_rownorm;
            max = Math.max(Math.abs(min), max);
        } else if (this.logtransform) {
            min = Math.log1p(this.minExpression);
            max = Math.log1p(this.maxExpression);
            max = Math.max(Math.abs(min), max);
        } else {
            min = this.minExpression;
            max = Math.max(Math.abs(this.minExpression), this.maxExpression);
        }
        double median = max / 2.0;
        if (min >= 0.0) {
            median = max / 2.0;
            this.range = ColorGradientRange.getInstance(0.0, median, median, max, 0.0, median, median, max);
            this.theme = ColorGradientTheme.GREEN_ONECOLOR_GRADIENT_THEME;
        } else {
            median = 0.0;
            this.range = ColorGradientRange.getInstance(-max, 0.0, 0.0, max, -max, 0.0, 0.0, max);
            this.theme = ColorGradientTheme.GREEN_MAGENTA_GRADIENT_THEME;
        }
    }

    public JPanel createRankOptionsPanel() {
        JPanel RankOptions = new JPanel();
        RankOptions.setLayout(new GridLayout(3, 1));
        JRadioButton noSort = new JRadioButton("No Sorting");
        noSort.setActionCommand("noSort");
        JRadioButton RankDataset1 = new JRadioButton("Sort by Dataset1 Rank");
        RankDataset1.setActionCommand("dataset1");
        JRadioButton RankDataset2 = new JRadioButton("Sort by Dataset2 Rank");
        RankDataset2.setActionCommand("dataset2");
        if (this.rank_dataset1) {
            RankDataset1.setSelected(true);
        } else if (this.rank_dataset2) {
            RankDataset2.setSelected(true);
        } else {
            noSort.setSelected(true);
        }
        ButtonGroup rankView = new ButtonGroup();
        rankView.add(noSort);
        rankView.add(RankDataset1);
        noSort.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
        RankDataset1.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
        RankOptions.add(noSort);
        RankOptions.add(RankDataset1);
        if (this.num_ranks == 2) {
            rankView.add(RankDataset2);
            RankDataset2.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
            RankOptions.add(RankDataset2);
        }
        return RankOptions;
    }

    public JPanel createHeatMapOptionsPanel() {
        JPanel heatmapOptions = new JPanel();
        heatmapOptions.setPreferredSize(new Dimension(200, 75));
        heatmapOptions.setLayout(new GridLayout(3, 1));
        JRadioButton asIs = new JRadioButton("Data As Is");
        asIs.setActionCommand("asis");
        JRadioButton rowNormalized = new JRadioButton("Row Normalize Data");
        rowNormalized.setActionCommand("rownorm");
        JRadioButton logTransform = new JRadioButton("Log Transform Data");
        logTransform.setActionCommand("logtransform");
        if (this.rowNorm) {
            rowNormalized.setSelected(true);
        } else if (this.logtransform) {
            logTransform.setSelected(true);
        } else {
            asIs.setSelected(true);
        }
        ButtonGroup dataView = new ButtonGroup();
        dataView.add(asIs);
        dataView.add(rowNormalized);
        dataView.add(logTransform);
        asIs.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
        rowNormalized.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
        logTransform.addActionListener(new selectDataViewActionListener(this.edgeOverlapPanel, this.nodeOverlapPanel, this));
        heatmapOptions.add(asIs);
        heatmapOptions.add(rowNormalized);
        heatmapOptions.add(logTransform);
        return heatmapOptions;
    }

    public ColorGradientRange getRange() {
        return this.range;
    }

    public void setRange(ColorGradientRange range) {
        this.range = range;
    }

    public ColorGradientTheme getTheme() {
        return this.theme;
    }

    public void setTheme(ColorGradientTheme theme) {
        this.theme = theme;
    }

    public boolean isRowNorm() {
        return this.rowNorm;
    }

    public void setRowNorm(boolean rowNorm) {
        this.rowNorm = rowNorm;
    }

    public boolean isLogtransform() {
        return this.logtransform;
    }

    public void setLogtransform(boolean logtransform) {
        this.logtransform = logtransform;
    }

    public boolean isRank_dataset1() {
        return this.rank_dataset1;
    }

    public void setRank_dataset1(boolean rank_dataset1) {
        this.rank_dataset1 = rank_dataset1;
    }

    public boolean isRank_dataset2() {
        return this.rank_dataset2;
    }

    public void setRank_dataset2(boolean rank_dataset2) {
        this.rank_dataset2 = rank_dataset2;
    }

    public int getNum_ranks() {
        return this.num_ranks;
    }

    public void setNum_ranks(int num_ranks) {
        this.num_ranks = num_ranks;
    }
}

