/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComputeSimilarityTask
implements Task {
    private EnrichmentMapParameters params;
    private HashMap<String, GenesetSimilarity> geneset_similarities;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public ComputeSimilarityTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public ComputeSimilarityTask(EnrichmentMapParameters params) {
        this.params = params;
        this.geneset_similarities = new HashMap();
    }

    public boolean computeMap() {
        try {
            HashMap genesetsOfInterest = this.params.getGenesetsOfInterest();
            int currentProgress = 0;
            int maxValue = genesetsOfInterest.size();
            Iterator i = genesetsOfInterest.keySet().iterator();
            while (i.hasNext()) {
                int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                long timeRemaining = maxValue - currentProgress;
                if (this.taskMonitor != null) {
                    this.taskMonitor.setPercentCompleted(percentComplete);
                    this.taskMonitor.setStatus("Computing Geneset similirity " + currentProgress + " of " + maxValue);
                    this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                }
                ++currentProgress;
                String geneset1_name = i.next().toString();
                Iterator j = genesetsOfInterest.keySet().iterator();
                while (j.hasNext()) {
                    String geneset2_name = j.next().toString();
                    String similarity_key1 = geneset1_name + " (pp) " + geneset2_name;
                    String similarity_key2 = geneset2_name + " (pp) " + geneset1_name;
                    if (geneset1_name.equalsIgnoreCase(geneset2_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                    GeneSet geneset1 = (GeneSet)genesetsOfInterest.get(geneset1_name);
                    GeneSet geneset2 = (GeneSet)genesetsOfInterest.get(geneset2_name);
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    double coeffecient = this.params.isJaccard() ? (double)intersection.size() / (double)union.size() : (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size());
                    GenesetSimilarity comparison = new GenesetSimilarity(geneset1_name, geneset2_name, coeffecient, intersection);
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
            }
        }
        catch (IllegalThreadStateException e) {
            this.taskMonitor.setException((Throwable)e, "Unable to compute jaccard coeffecients");
            return false;
        }
        return true;
    }

    public HashMap<String, GenesetSimilarity> getGeneset_similarities() {
        return this.geneset_similarities;
    }

    public void run() {
        this.computeMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Computing geneset similarities");
    }
}

