/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.readers.TextFileReader;
import cytoscape.plugin.CytoscapePlugin;
import cytoscape.view.CyNetworkView;
import giny.view.GraphViewChangeListener;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.baderlab.csplugins.enrichmentmap.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapActionListener;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.GCTFileReaderTask;
import org.baderlab.csplugins.enrichmentmap.LoadGSEAPanelAction;
import org.baderlab.csplugins.enrichmentmap.ParametersPanel;
import org.baderlab.csplugins.enrichmentmap.ShowAboutPanelAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Enrichment_Map_Plugin
extends CytoscapePlugin {
    static Properties build_props = new Properties();
    static Properties plugin_props = new Properties();
    static String buildId;

    public Enrichment_Map_Plugin() {
        JMenu menu = Cytoscape.getDesktop().getCyMenus().getOperationsMenu();
        JMenu submenu = new JMenu("Enrichment Maps");
        JMenuItem item = new JMenuItem("Load Enrichment Results");
        item.addActionListener((ActionListener)((Object)new LoadGSEAPanelAction()));
        submenu.add(item);
        item = new JMenuItem("About");
        item.addActionListener((ActionListener)((Object)new ShowAboutPanelAction()));
        submenu.add(item);
        menu.add(submenu);
        try {
            build_props = this.getPropertiesFromClasspath("buildID.props");
        }
        catch (IOException e) {
            build_props.setProperty("build.number", "0");
            build_props.setProperty("svn.revision", "0");
            build_props.setProperty("build.user", "user");
            build_props.setProperty("build.host", "host");
            build_props.setProperty("build.timestemp", "1900/01/01 00:00:00 +0000 (GMT)");
        }
        buildId = "Build: " + build_props.getProperty("build.number") + " from SVN: " + build_props.getProperty("svn.revision") + " by: " + build_props.getProperty("build.user") + "@" + build_props.getProperty("build.host") + " at: " + build_props.getProperty("build.timestamp");
        try {
            plugin_props = this.getPropertiesFromClasspath("org/baderlab/csplugins/enrichmentmap/plugin.props");
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public void onCytoscapeExit() {
        File propFile = CytoscapeInit.getConfigFile((String)"enrichmentMap.props");
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(propFile));
            writer.write("line 1:");
            writer.newLine();
            writer.write("line2:");
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void saveSessionStateFiles(List<File> pFileList) {
        String tmpDir = System.getProperty("java.io.tmpdir");
        System.out.println("java.io.tmpdir: [" + tmpDir + "]");
        HashMap<String, EnrichmentMapParameters> networks = EnrichmentMapManager.getInstance().getCyNetworkList();
        Iterator<String> i = networks.keySet().iterator();
        while (i.hasNext()) {
            String networkId = i.next().toString();
            EnrichmentMapParameters params = networks.get(networkId);
            String name = Cytoscape.getNetwork((String)networkId).getTitle();
            File session_prop_file = new File(tmpDir, name + ".props");
            File gmt = new File(tmpDir, name + ".gmt");
            File genes = new File(tmpDir, name + ".genes.txt");
            File enrichmentresults1 = new File(tmpDir, name + ".ENR1.txt");
            File enrichmentresults1Ofinterest = new File(tmpDir, name + ".SubENR1.txt");
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(session_prop_file));
                writer.write(params.toString());
                writer.close();
                BufferedWriter gmtwriter = new BufferedWriter(new FileWriter(gmt));
                gmtwriter.write(params.printHashmap(params.getGenesetsOfInterest()));
                gmtwriter.close();
                pFileList.add(gmt);
                BufferedWriter geneswriter = new BufferedWriter(new FileWriter(genes));
                geneswriter.write(params.printHashmap(params.getGenes()));
                geneswriter.close();
                pFileList.add(genes);
                BufferedWriter enr1writer = new BufferedWriter(new FileWriter(enrichmentresults1));
                enr1writer.write(params.printHashmap(params.getEnrichmentResults1()));
                enr1writer.close();
                pFileList.add(enrichmentresults1);
                BufferedWriter subenr1writer = new BufferedWriter(new FileWriter(enrichmentresults1Ofinterest));
                subenr1writer.write(params.printHashmap(params.getEnrichmentResults1OfInterest()));
                subenr1writer.close();
                pFileList.add(enrichmentresults1Ofinterest);
                if (params.isTwoDatasets()) {
                    File enrichmentresults2 = new File(tmpDir, name + ".ENR2.txt");
                    BufferedWriter enr2writer = new BufferedWriter(new FileWriter(enrichmentresults2));
                    enr2writer.write(params.printHashmap(params.getEnrichmentResults2()));
                    enr2writer.close();
                    pFileList.add(enrichmentresults2);
                    File enrichmentresults2Ofinterest = new File(tmpDir, name + ".SubENR2.txt");
                    BufferedWriter subenr2writer = new BufferedWriter(new FileWriter(enrichmentresults2Ofinterest));
                    subenr2writer.write(params.printHashmap(params.getEnrichmentResults1OfInterest()));
                    subenr2writer.close();
                    pFileList.add(enrichmentresults2Ofinterest);
                }
                if (params.isData()) {
                    File expression1 = new File(tmpDir, name + ".expression1.txt");
                    BufferedWriter expression1writer = new BufferedWriter(new FileWriter(expression1));
                    expression1writer.write(params.getExpression().toString());
                    expression1writer.close();
                    pFileList.add(expression1);
                }
                if (params.isData2()) {
                    File expression2 = new File(tmpDir, name + ".expression2.txt");
                    BufferedWriter expression2writer = new BufferedWriter(new FileWriter(expression2));
                    expression2writer.write(params.getExpression2().toString());
                    expression2writer.close();
                    pFileList.add(expression2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            pFileList.add(session_prop_file);
        }
    }

    public void restoreSessionState(List<File> pStateFileList) {
        if (pStateFileList == null || pStateFileList.size() == 0) {
            return;
        }
        try {
            String name;
            String[] fullname;
            EnrichmentMapParameters params;
            File prop_file;
            int i;
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (!prop_file.getName().contains(".props")) continue;
                TextFileReader reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                String fullText = reader.getText();
                params = new EnrichmentMapParameters(fullText);
                String name2 = params.getNetworkName();
                EnrichmentMapManager.getInstance().registerNetwork(Cytoscape.getNetwork((String)name2), params);
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                name = fullname[1].split("\\.")[0];
                params = EnrichmentMapManager.getInstance().getParameters(name);
                if (params == null) {
                    System.out.println("network for file" + prop_file.getName() + " does not exist.");
                    continue;
                }
                if (prop_file.getName().contains(".props") || prop_file.getName().contains(".expression1.txt") || prop_file.getName().contains(".expression2.txt")) continue;
                TextFileReader reader = new TextFileReader(prop_file.getAbsolutePath());
                reader.read();
                String fullText = reader.getText();
                if (prop_file.getName().contains(".gmt")) {
                    params.setGenesetsOfInterest(params.repopulateHashmap(fullText, 1));
                }
                if (prop_file.getName().contains(".genes.txt")) {
                    params.setGenes(params.repopulateHashmap(fullText, 2));
                }
                if (prop_file.getName().contains(".ENR1.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults1(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults1(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (prop_file.getName().contains(".SubENR1.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults1OfInterest(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults1OfInterest(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (!params.isTwoDatasets()) continue;
                if (prop_file.getName().contains(".ENR2.txt")) {
                    if (params.isGSEA()) {
                        params.setEnrichmentResults2(params.repopulateHashmap(fullText, 3));
                    } else {
                        params.setEnrichmentResults2(params.repopulateHashmap(fullText, 4));
                    }
                }
                if (!prop_file.getName().contains(".SubENR2.txt")) continue;
                if (params.isGSEA()) {
                    params.setEnrichmentResults2OfInterest(params.repopulateHashmap(fullText, 3));
                    continue;
                }
                params.setEnrichmentResults2OfInterest(params.repopulateHashmap(fullText, 4));
            }
            for (i = 0; i < pStateFileList.size(); ++i) {
                prop_file = pStateFileList.get(i);
                if (prop_file.getName().contains("expression1.txt")) {
                    fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                    name = fullname[1].split("\\.")[0];
                    params = EnrichmentMapManager.getInstance().getParameters(name);
                    GCTFileReaderTask gctFile1 = new GCTFileReaderTask(params, prop_file.getAbsolutePath(), 1);
                    gctFile1.run();
                    params.getExpression().rowNormalizeMatrix();
                }
                if (!prop_file.getName().contains("expression2.txt")) continue;
                fullname = prop_file.getName().split("Enrichment_Map_Plugin_");
                name = fullname[1].split("\\.")[0];
                params = EnrichmentMapManager.getInstance().getParameters(name);
                GCTFileReaderTask gctFile2 = new GCTFileReaderTask(params, prop_file.getAbsolutePath(), 2);
                gctFile2.run();
                params.getExpression2().rowNormalizeMatrix();
            }
            EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
            HashMap<String, EnrichmentMapParameters> networks = manager.getCyNetworkList();
            Iterator<String> j = networks.keySet().iterator();
            while (j.hasNext()) {
                String currentNetwork = j.next();
                CyNetworkView view = Cytoscape.getNetworkView((String)currentNetwork);
                EnrichmentMapParameters params2 = networks.get(currentNetwork);
                ComputeSimilarityTask similarities = new ComputeSimilarityTask(params2);
                similarities.run();
                HashMap similarity_results = similarities.getGeneset_similarities();
                params2.setGenesetSimilarity(similarity_results);
                view.addGraphViewChangeListener((GraphViewChangeListener)new EnrichmentMapActionListener(params2));
                if (j.hasNext()) continue;
                Cytoscape.setCurrentNetwork((String)currentNetwork);
                ParametersPanel paramPanel = manager.getParameterPanel();
                paramPanel.updatePanel(params2);
                paramPanel.revalidate();
            }
        }
        catch (Exception ee) {
            ee.printStackTrace();
        }
    }

    private Properties getPropertiesFromClasspath(String propFileName) throws IOException {
        Properties props = new Properties();
        InputStream inputStream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(propFileName);
        if (inputStream == null) {
            throw new FileNotFoundException("property file '" + propFileName + "' not found in the classpath");
        }
        props.load(inputStream);
        return props;
    }
}

