/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.OverlappingGenesPanel;
import org.baderlab.csplugins.enrichmentmap.SummaryPanel;

public class EnrichmentMapActionListener
implements GraphViewChangeListener {
    private EnrichmentMapParameters params;
    private OverlappingGenesPanel edgeOverlapPanel;
    private OverlappingGenesPanel nodeOverlapPanel;
    private SummaryPanel summaryPanel;
    private List<Node> Nodes;
    private List<Edge> Edges;
    private final CytoPanel cytoPanel;
    private final CytoPanel cytoSidePanel;

    public EnrichmentMapActionListener(EnrichmentMapParameters params) {
        this.params = params;
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        this.cytoPanel = desktop.getCytoPanel(5);
        this.cytoSidePanel = desktop.getCytoPanel(3);
        if (params.isData()) {
            this.edgeOverlapPanel = manager.getEdgesOverlapPanel();
            this.nodeOverlapPanel = manager.getNodesOverlapPanel();
            HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel);
            hmParams.initColorGradients(params.getExpression());
            params.setHmParams(hmParams);
        }
        this.summaryPanel = EnrichmentMapManager.getInstance().getSummaryPanel();
        this.Nodes = params.getSelectedNodes();
        this.Edges = params.getSelectedEdges();
    }

    public void graphViewChanged(GraphViewChangeEvent event) {
        int i;
        if (event.isEdgesSelectedType()) {
            Edge[] selectedEdges = event.getSelectedEdges();
            for (i = 0; i < selectedEdges.length; ++i) {
                if (this.Edges.contains(selectedEdges[i])) continue;
                this.Edges.add(selectedEdges[i]);
            }
            this.createEdgesData();
        }
        if (event.isNodesSelectedType()) {
            Node[] selectedNodes = event.getSelectedNodes();
            for (i = 0; i < selectedNodes.length; ++i) {
                if (this.Nodes.contains(selectedNodes[i])) continue;
                this.Nodes.add(selectedNodes[i]);
            }
            this.createNodesData();
        }
        if (event.isNodesUnselectedType()) {
            Node[] unselectedNodes = event.getUnselectedNodes();
            for (i = 0; i < unselectedNodes.length; ++i) {
                if (!this.Nodes.contains(unselectedNodes[i])) continue;
                this.Nodes.remove(unselectedNodes[i]);
            }
            if (!this.Nodes.isEmpty()) {
                this.createNodesData();
            }
            if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
                this.clearPanels();
            }
        }
        if (event.isEdgesUnselectedType()) {
            Edge[] unselectedEdges = event.getUnselectedEdges();
            for (i = 0; i < unselectedEdges.length; ++i) {
                if (!this.Edges.contains(unselectedEdges[i])) continue;
                this.Edges.remove(unselectedEdges[i]);
            }
            if (!this.Edges.isEmpty()) {
                this.createEdgesData();
            }
            if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
                this.clearPanels();
            }
        }
    }

    public void createEdgesData() {
        this.summaryPanel.updateEdgeInfo(this.Edges.toArray());
        if (!this.params.isDisableGenesetSummaryAutofocus()) {
            this.cytoSidePanel.setSelectedIndex(this.cytoSidePanel.indexOfComponent((Component)this.summaryPanel));
        }
        this.summaryPanel.revalidate();
        if (this.params.isData()) {
            this.edgeOverlapPanel.updatePanel(this.params);
            if (!this.params.isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.edgeOverlapPanel));
            }
            this.edgeOverlapPanel.revalidate();
        }
    }

    private void createNodesData() {
        this.summaryPanel.updateNodeInfo(this.Nodes.toArray());
        if (!this.params.isDisableGenesetSummaryAutofocus()) {
            this.cytoSidePanel.setSelectedIndex(this.cytoSidePanel.indexOfComponent((Component)this.summaryPanel));
        }
        this.summaryPanel.revalidate();
        if (this.params.isData()) {
            this.nodeOverlapPanel.updatePanel(this.params);
            if (!this.params.isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.nodeOverlapPanel));
            }
            this.nodeOverlapPanel.revalidate();
        }
    }

    public void clearPanels() {
        this.summaryPanel.clearInfo();
        if (this.params.isData()) {
            this.nodeOverlapPanel.clearPanel();
            this.edgeOverlapPanel.clearPanel();
            if (!this.params.isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.nodeOverlapPanel));
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.edgeOverlapPanel));
            }
        }
    }
}

