/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.util.HashSet;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenesetSimilarity {
    private String geneset1_Name;
    private String geneset2_Name;
    private double jaccard_coeffecient;
    private HashSet<Integer> overlapping_genes;

    public GenesetSimilarity(String geneset1_Name, String geneset2_Name, double jaccard_coeffecient, HashSet<Integer> overlapping_genes) {
        this.geneset1_Name = geneset1_Name;
        this.geneset2_Name = geneset2_Name;
        this.jaccard_coeffecient = jaccard_coeffecient;
        this.overlapping_genes = overlapping_genes;
    }

    public GenesetSimilarity(String[] tokens) {
        if (tokens.length < 4) {
            return;
        }
        this.geneset1_Name = tokens[1];
        this.geneset2_Name = tokens[2];
        this.jaccard_coeffecient = Double.parseDouble(tokens[3]);
        this.overlapping_genes = new HashSet();
        for (int i = 4; i < tokens.length; ++i) {
            this.overlapping_genes.add(Integer.parseInt(tokens[i]));
        }
    }

    public String getGeneset1_Name() {
        return this.geneset1_Name;
    }

    public void setGeneset1_Name(String geneset1_Name) {
        this.geneset1_Name = geneset1_Name;
    }

    public String getGeneset2_Name() {
        return this.geneset2_Name;
    }

    public void setGeneset2_Name(String geneset2_Name) {
        this.geneset2_Name = geneset2_Name;
    }

    public double getJaccard_coeffecient() {
        return this.jaccard_coeffecient;
    }

    public void setJaccard_coeffecient(double jaccard_coeffecient) {
        this.jaccard_coeffecient = jaccard_coeffecient;
    }

    public HashSet<Integer> getOverlapping_genes() {
        return this.overlapping_genes;
    }

    public void setOverlapping_genes(HashSet<Integer> overlapping_genes) {
        this.overlapping_genes = overlapping_genes;
    }

    public int getSizeOfOverlap() {
        return this.overlapping_genes.size();
    }

    public String toString() {
        String similarity = "";
        similarity = similarity + this.geneset1_Name + "\t" + this.geneset2_Name + "\t" + this.jaccard_coeffecient + "\t";
        Iterator<Integer> i = this.overlapping_genes.iterator();
        while (i.hasNext()) {
            similarity = similarity + ((Object)i.next()).toString() + "\t";
        }
        return similarity;
    }
}

