/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import javax.swing.JOptionPane;

public class BuildGSEAEnrichmentMapTask
implements Task {
    private GenericInputFilesPanel inputPanel;
    private EnrichmentMapParameters params;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public BuildGSEAEnrichmentMapTask(GenericInputFilesPanel inputPanel, EnrichmentMapParameters params) {
        this.inputPanel = inputPanel;
        this.params = params;
    }

    public void buildGSEAMap() {
        try {
            GMTFileReaderTask gmtFile = new GMTFileReaderTask(this.params, this.taskMonitor);
            gmtFile.run();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.inputPanel, "unable to load GMT file");
        }
        try {
            GCTFileReaderTask gctFile1 = new GCTFileReaderTask(this.params, this.params.getGCTFileName1(), 1, this.taskMonitor);
            gctFile1.run();
            this.params.getExpression().rowNormalizeMatrix();
            if (this.params.isData2()) {
                GCTFileReaderTask gctFile2 = new GCTFileReaderTask(this.params, this.params.getGCTFileName2(), 2, this.taskMonitor);
                gctFile2.run();
                this.params.getExpression2().rowNormalizeMatrix();
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.inputPanel, "unable to load GSEA DATA (.GCT) file");
        }
        this.params.filterGenesets();
        try {
            GSEAResultFileReaderTask gseaResultsFilesDataset1File1 = new GSEAResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset1FileName1(), 1);
            gseaResultsFilesDataset1File1.run();
            GSEAResultFileReaderTask gseaResultsFilesDataset1File2 = new GSEAResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset1FileName2(), 1);
            gseaResultsFilesDataset1File2.run();
            if (this.params.getDataset1RankedFile() != null) {
                RanksFileReaderTask ranking1 = new RanksFileReaderTask(this.params, this.params.getDataset1RankedFile(), 1, this.taskMonitor);
                ranking1.run();
            }
            if (this.params.isTwoDatasets()) {
                GSEAResultFileReaderTask gseaResultsFilesDataset2File1 = new GSEAResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset2FileName1(), 2);
                gseaResultsFilesDataset2File1.run();
                GSEAResultFileReaderTask gseaResultsFilesDataset2File2 = new GSEAResultFileReaderTask(this.params, this.taskMonitor, this.params.getEnrichmentDataset2FileName2(), 2);
                gseaResultsFilesDataset2File2.run();
                if (this.params.getDataset2RankedFile() != null) {
                    RanksFileReaderTask ranking2 = new RanksFileReaderTask(this.params, this.params.getDataset2RankedFile(), 2, this.taskMonitor);
                    ranking2.run();
                }
            }
            InitializeGenesetsOfInterestTask genesets_init = new InitializeGenesetsOfInterestTask(this.params, this.taskMonitor);
            genesets_init.run();
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(this.params, this.taskMonitor);
            similarities.run();
            HashMap similarity_results = similarities.getGeneset_similarities();
            this.params.setGenesetSimilarity(similarity_results);
            VisualizeEnrichmentMapTask map = new VisualizeEnrichmentMapTask(this.params, this.taskMonitor);
            map.run();
            this.inputPanel.close();
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(this.inputPanel, "unable to build map");
        }
    }

    public void run() {
        this.buildGSEAMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GSEA results");
    }
}

