/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JTextField;

public class GSEAInputFilesPanelMac
extends GenericInputFilesPanel {
    private final int DIM_HEIGHT = 350;
    private final int DIM_WIDTH = 350;
    private boolean status = false;
    private JTextField Dataset1FileNameTextField;
    private JButton selectDataset1FileButton;
    private JTextField Dataset1FileName2TextField;
    private JButton selectDataset1File2Button;
    private JTextField Dataset2FileNameTextField;
    private JButton selectDataset2FileButton;
    private JTextField Dataset2FileName2TextField;
    private JButton selectDataset2File2Button;

    public GSEAInputFilesPanelMac(Frame parent, boolean modal) {
        super(parent, modal, true);
        this.initComponents();
        this.status = false;
        this.pack();
    }

    public void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.insets = new Insets(5, 5, 10, 10);
        c.fill = 2;
        int current_row = 0;
        current_row = this.initTitleComponent(gridbag, c, current_row, "Import GSEA Result files used to calculate enrichment maps");
        current_row = this.initGMTComponent(gridbag, c, current_row);
        current_row = this.initEnrichmentFilesComponent(gridbag, c, current_row);
        current_row = this.initCutoffsComponent(gridbag, c, current_row);
        current_row = this.initActionButtonsComponent(gridbag, c, current_row);
    }

    public int initEnrichmentFilesComponent(GridBagLayout gridbag, GridBagConstraints c, int current_row) {
        this.Dataset1FileNameTextField = new JTextField();
        this.Dataset1FileName2TextField = new JTextField();
        this.Dataset2FileNameTextField = new JTextField();
        this.Dataset2FileName2TextField = new JTextField();
        this.selectDataset1FileButton = new JButton();
        this.selectDataset1File2Button = new JButton();
        this.selectDataset2FileButton = new JButton();
        this.selectDataset2File2Button = new JButton();
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset1_title);
        current_row = this.initGCTComponent(gridbag, c, current_row);
        this.Dataset1FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset1FileNameTextField.setText(dataset_instruction);
        this.selectDataset1FileButton.setText("Select");
        this.selectDataset1FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanelMac.this.selectDataset1FileButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset1FileNameTextField, this.selectDataset1FileButton);
        this.Dataset1FileName2TextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset1FileName2TextField.setText(dataset_instruction);
        this.selectDataset1File2Button.setText("Select");
        this.selectDataset1File2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanelMac.this.selectDataset1File2ButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset1FileName2TextField, this.selectDataset1File2Button);
        current_row = this.addSeparator(gridbag, c, current_row);
        current_row = this.initTitleComponent(gridbag, c, current_row, dataset2_title);
        current_row = this.initGCT2Component(gridbag, c, current_row);
        this.Dataset2FileNameTextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset2FileNameTextField.setText("(OPTIONAL) " + dataset_instruction);
        this.selectDataset2FileButton.setText("Select");
        this.selectDataset2FileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanelMac.this.selectDataset2FileButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset2FileNameTextField, this.selectDataset2FileButton);
        this.Dataset2FileName2TextField.setFont(new Font("Dialog", 1, 12));
        this.Dataset2FileName2TextField.setText("(OPTIONAL)" + dataset_instruction);
        this.selectDataset2File2Button.setText("Select");
        this.selectDataset2File2Button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                GSEAInputFilesPanelMac.this.selectDataset2File2ButtonActionPerformed(evt);
            }
        });
        current_row = this.addTextButtonRow(gridbag, c, current_row, this.Dataset2FileName2TextField, this.selectDataset2File2Button);
        current_row = this.addSeparator(gridbag, c, current_row);
        return current_row;
    }

    private void selectDataset1FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA result files");
        File file = FileUtil.getFile((String)"import GSEA dataset 1 result file 1", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1FileNameTextField.setText(file.getAbsolutePath());
            this.setGSEADataset1FileName1(file.getAbsolutePath());
            this.Dataset1FileNameTextField.setToolTipText(file.getAbsolutePath());
            if (this.isGMTFileSelected() && this.isGCTFileSelected() && this.isDataset1FileSelected()) {
                this.enableImport();
            }
            this.setDataset1FileSelected(true);
        }
    }

    private void selectDataset1File2ButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA result files");
        File file = FileUtil.getFile((String)"import GSEA dataset 1 result file 2", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset1FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset1FileName2TextField.setText(file.getAbsolutePath());
            this.setGSEADataset1FileName2(file.getAbsolutePath());
            this.Dataset1FileName2TextField.setToolTipText(file.getAbsolutePath());
            if (this.isGMTFileSelected() && this.isGCTFileSelected() && this.isDataset1FileSelected()) {
                this.enableImport();
            }
            this.setDataset1FileSelected(true);
        }
    }

    private void selectDataset2FileButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA result files");
        File file = FileUtil.getFile((String)"import GSEA dataset 2 result file 1", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2FileNameTextField.setText(file.getAbsolutePath());
            this.setGSEADataset2FileName1(file.getAbsolutePath());
            this.Dataset2FileNameTextField.setToolTipText(file.getAbsolutePath());
            if (this.isGMTFileSelected() && this.isGCTFileSelected() && this.isDataset1FileSelected()) {
                this.enableImport();
            }
        }
    }

    private void selectDataset2File2ButtonActionPerformed(ActionEvent evt) {
        CyFileFilter filter = new CyFileFilter();
        filter.addExtension("txt");
        filter.addExtension("xls");
        filter.setDescription("All GSEA result files");
        File file = FileUtil.getFile((String)"import GSEA dataset 2 result file 2", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
        if (file != null) {
            this.Dataset2FileName2TextField.setForeground(this.checkFile(file.getAbsolutePath()));
            this.Dataset2FileName2TextField.setText(file.getAbsolutePath());
            this.setGSEADataset2FileName2(file.getAbsolutePath());
            this.Dataset2FileName2TextField.setToolTipText(file.getAbsolutePath());
            if (this.isGMTFileSelected() && this.isGCTFileSelected() && this.isDataset1FileSelected()) {
                this.enableImport();
            }
            this.setTwoDatasets(true);
        }
    }

    protected void setDatasetnames(String file1, String file2, boolean dataset1) {
        if (dataset1) {
            this.Dataset1FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset1FileNameTextField.setText(file1);
            this.Dataset1FileNameTextField.setToolTipText(file1);
            this.Dataset1FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset1FileName2TextField.setText(file2);
            this.Dataset1FileName2TextField.setToolTipText(file2);
        } else {
            this.Dataset2FileNameTextField.setForeground(this.checkFile(file1));
            this.Dataset2FileNameTextField.setText(file1);
            this.Dataset2FileNameTextField.setToolTipText(file1);
            this.Dataset2FileName2TextField.setForeground(this.checkFile(file2));
            this.Dataset2FileName2TextField.setText(file2);
            this.Dataset2FileName2TextField.setToolTipText(file2);
        }
    }

    public boolean checkResultsFiles() {
        int answer;
        if (!this.getGSEADataset1FileName1().equalsIgnoreCase(this.Dataset1FileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 1 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.checkFile(this.Dataset1FileNameTextField.getText()) == Color.RED) {
                JOptionPane.showMessageDialog(this, "The file specified in the Dataset 1 file 1 does not exist.");
                return false;
            }
            this.setGSEADataset1FileName1(this.Dataset1FileNameTextField.getText());
        }
        if (!this.getGSEADataset1FileName2().equalsIgnoreCase(this.Dataset1FileName2TextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 1 Filename 2 has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
            if (this.checkFile(this.Dataset1FileName2TextField.getText()) == Color.RED) {
                JOptionPane.showMessageDialog(this, "The file specified in the Dataset 1 file 2 does not exist.");
                return false;
            }
            this.setGSEADataset1FileName2(this.Dataset1FileName2TextField.getText());
        }
        if (this.isTwoDatasets()) {
            if (!this.getGSEADataset2FileName1().equalsIgnoreCase(this.Dataset2FileNameTextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 2 Filename has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
                if (this.checkFile(this.Dataset2FileNameTextField.getText()) == Color.RED) {
                    JOptionPane.showMessageDialog(this, "The file specified in the Dataset 2 file 1 does not exist.");
                    return false;
                }
                this.setGSEADataset2FileName1(this.Dataset2FileNameTextField.getText());
            }
            if (!this.getGSEADataset2FileName2().equalsIgnoreCase(this.Dataset2FileName2TextField.getText()) && (answer = JOptionPane.showConfirmDialog(this, "The Dataset 2 Filename 2 has been modified from the original one loaded.  Would you like to use the original file specified??", "File changed", 0)) != 0) {
                if (this.checkFile(this.Dataset2FileName2TextField.getText()) == Color.RED) {
                    JOptionPane.showMessageDialog(this, "The file specified in the Dataset 2 file 2 does not exist.");
                    return false;
                }
                this.setGSEADataset2FileName2(this.Dataset2FileName2TextField.getText());
            }
        }
        return true;
    }
}

