/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;

public class GMTFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String GMTFileName;
    private HashMap genes;
    private String fullText;
    private String[] lines;
    private HashMap genesets;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public GMTFileReaderTask(EnrichmentMapParameters params, TaskMonitor taskMonitor) {
        this(params);
        this.taskMonitor = taskMonitor;
    }

    public GMTFileReaderTask(EnrichmentMapParameters params) {
        this.params = params;
        this.GMTFileName = params.getGMTFileName();
        this.genes = params.getGenes();
        this.genesets = params.getGenesets();
        TextFileReader reader = new TextFileReader(this.GMTFileName);
        reader.read();
        this.fullText = reader.getText();
        this.lines = this.fullText.split("\n");
    }

    public void parse() {
        int currentProgress = 0;
        this.maxValue = this.lines.length;
        for (int i = 0; i < this.lines.length; ++i) {
            String line = this.lines[i];
            String[] tokens = line.split("\t");
            String Name = tokens[0].toUpperCase().trim();
            String description = tokens[1].trim();
            GeneSet gs = new GeneSet(Name, description);
            int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
            long timeRemaining = this.maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GMT file " + currentProgress + " of " + this.maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
            for (int j = 2; j < tokens.length; ++j) {
                if (this.genes.containsKey(tokens[j])) {
                    gs.addGene((Integer)this.genes.get(tokens[j]));
                    continue;
                }
                int value = this.params.getNumberOfGenes();
                this.genes.put(tokens[j], value);
                this.params.setNumberOfGenes(value + 1);
                gs.addGene((Integer)this.genes.get(tokens[j]));
            }
            this.genesets.put(Name, gs);
        }
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GMT file");
    }
}

