/*
 * Decompiled with CFR 0.152.
 */
import cytoscape.data.readers.TextFileReader;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.HashSet;

public class GCTFileReaderTask
implements Task {
    private EnrichmentMapParameters params;
    private String GCTFileName;
    private int dataset;
    private String fullText;
    private String[] lines;
    private HashSet datasetGenes;
    private HashMap genes;
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;

    public GCTFileReaderTask(EnrichmentMapParameters params, String fileName, int dataset, TaskMonitor taskMonitor) {
        this(params, fileName, dataset);
        this.taskMonitor = taskMonitor;
    }

    public GCTFileReaderTask(EnrichmentMapParameters params, String fileName, int dataset) {
        this.params = params;
        this.genes = params.getGenes();
        this.datasetGenes = params.getDatasetGenes();
        this.GCTFileName = fileName;
        this.dataset = dataset;
    }

    public void parse() {
        TextFileReader reader = new TextFileReader(this.GCTFileName);
        reader.read();
        this.fullText = reader.getText();
        this.lines = this.fullText.split("\n");
        int currentProgress = 0;
        this.maxValue = this.lines.length;
        GeneExpressionMatrix expressionMatrix = new GeneExpressionMatrix(this.lines[0].split("\t"));
        HashMap<Integer, GeneExpression> expression = new HashMap<Integer, GeneExpression>();
        for (int i = 0; i < this.lines.length; ++i) {
            String line = this.lines[i];
            String[] tokens = line.split("\t");
            String Name = tokens[0];
            if (i == 0) {
                if (Name.equalsIgnoreCase("#1.2")) {
                    line = this.lines[2];
                    i = 2;
                } else {
                    line = this.lines[0];
                }
                tokens = line.split("\t");
                expressionMatrix = new GeneExpressionMatrix(tokens);
                expressionMatrix.setExpressionMatrix(expression);
                continue;
            }
            if (this.genes.containsKey(Name)) {
                double newMin;
                Integer genekey = (Integer)this.genes.get(Name);
                this.datasetGenes.add(this.genes.get(Name));
                String description = tokens[1];
                GeneExpression expres = new GeneExpression(Name, description);
                expres.setExpression(tokens);
                double newMax = expres.newMax(expressionMatrix.getMaxExpression());
                if (newMax != -100.0) {
                    expressionMatrix.setMaxExpression(newMax);
                }
                if ((newMin = expres.newMin(expressionMatrix.getMinExpression())) != -100.0) {
                    expressionMatrix.setMinExpression(newMin);
                }
                expression.put(genekey, expres);
            }
            int percentComplete = (int)((double)currentProgress / (double)this.maxValue * 100.0);
            long timeRemaining = this.maxValue - currentProgress;
            if (this.taskMonitor != null) {
                this.taskMonitor.setPercentCompleted(percentComplete);
                this.taskMonitor.setStatus("Parsing GCT file " + currentProgress + " of " + this.maxValue);
                this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
            }
            ++currentProgress;
        }
        if (this.dataset == 1) {
            if (this.params.getClassFile1() != null) {
                expressionMatrix.setPhenotypes(this.setClasses(expressionMatrix, this.params.getClassFile1()));
            }
            this.params.setExpression(expressionMatrix);
        } else {
            if (this.params.getClassFile2() != null) {
                expressionMatrix.setPhenotypes(this.setClasses(expressionMatrix, this.params.getClassFile2()));
            }
            this.params.setExpression2(expressionMatrix);
        }
    }

    private String[] setClasses(GeneExpressionMatrix expresson, String classFile) {
        if (!classFile.equalsIgnoreCase(null)) {
            TextFileReader reader2 = new TextFileReader(classFile);
            reader2.read();
            String fullText2 = reader2.getText();
            String[] lines2 = fullText2.split("\n");
            return lines2[2].split(" ");
        }
        String[] def_pheno = new String[]{"Na_pos", "NA_neg"};
        return def_pheno;
    }

    public void run() {
        this.parse();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Parsing GCT file");
    }
}

