/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.test;

import cytoscape.data.readers.TextFileReader;
import java.io.Reader;
import junit.framework.TestCase;
import org.baderlab.csplugins.enrichmentmap.BuildDiseaseSignatureTask;

public class HypergeometricTest
extends TestCase {
    int N;
    int n;
    int m;
    int k;
    double pValue;
    double expected_pVal;
    Reader testData = null;

    public void setUp() throws Exception {
    }

    public void testHyperGeomPvalueSmall() {
        this.N = 50;
        this.n = 10;
        this.m = 5;
        this.k = 4;
        this.pValue = BuildDiseaseSignatureTask.hyperGeomPvalue(this.N, this.n, this.m, this.k);
        HypergeometricTest.assertEquals((double)0.003964583, (double)this.pValue, (double)5.0E-4);
        this.k = 5;
        this.pValue = BuildDiseaseSignatureTask.hyperGeomPvalue(this.N, this.n, this.m, this.k);
        HypergeometricTest.assertEquals((double)1.189375E-4, (double)this.pValue, (double)5.0E-4);
    }

    public void testHyperGeomPvalueBig() {
        String testDataFileName = "src/org/baderlab/csplugins/enrichmentmap/test/resources/HypergeometricTest_pvalues.csv";
        TextFileReader reader = new TextFileReader(testDataFileName);
        reader.read();
        String fullText = reader.getText();
        String[] lines = fullText.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (i == 0) continue;
            String[] tokens = lines[i].split(",");
            this.N = Integer.parseInt(tokens[0]);
            this.n = Integer.parseInt(tokens[1]);
            this.m = Integer.parseInt(tokens[2]);
            this.k = Integer.parseInt(tokens[3]);
            this.expected_pVal = Double.parseDouble(tokens[4]);
            this.pValue = BuildDiseaseSignatureTask.hyperGeomPvalue_sum(this.N, this.n, this.m, this.k, 1);
            HypergeometricTest.assertEquals((double)this.expected_pVal, (double)this.pValue, (double)5.0E-8);
        }
    }
}

