/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cern.jet.stat.Gamma;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import cytoscape.view.CyNetworkView;
import giny.model.Edge;
import giny.model.Node;
import giny.view.NodeView;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.GeneSet;
import org.baderlab.csplugins.enrichmentmap.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.PostAnalysisParameters;
import org.baderlab.csplugins.enrichmentmap.VisualizeEnrichmentMapTask;

public class BuildDiseaseSignatureTask
implements Task {
    private PostAnalysisParameters paParams = new PostAnalysisParameters();
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private HashMap<String, GeneSet> EnrichmentGenesets;
    private HashMap<String, GeneSet> SignatureGenesets;
    private HashMap<String, GeneSet> SelectedSignatureGenesets;
    private HashSet<Integer> EnrichmentGenes;
    private HashSet<Integer> SignatureGenes;
    private HashMap<String, GenesetSimilarity> geneset_similarities;

    public BuildDiseaseSignatureTask(PostAnalysisParameters paParams) {
        this.paParams.copyFrom(paParams);
        this.EnrichmentGenesets = this.getPaParams().getGenesets();
        this.SignatureGenesets = this.getPaParams().getSignatureGenesets();
        this.geneset_similarities = this.paParams.getGenesetSimilarity() == null ? new HashMap() : this.paParams.getGenesetSimilarity();
        this.SelectedSignatureGenesets = new HashMap();
        for (int i = 0; i < paParams.getSelectedSignatureSetNames().getSize(); ++i) {
            this.SelectedSignatureGenesets.put(paParams.getSelectedSignatureSetNames().get(i).toString(), this.SignatureGenesets.get(paParams.getSelectedSignatureSetNames().get(i)));
        }
        this.EnrichmentGenes = new HashSet();
        for (String setName : this.EnrichmentGenesets.keySet()) {
            this.EnrichmentGenes.addAll(this.EnrichmentGenesets.get(setName).getGenes());
        }
        this.SignatureGenes = new HashSet();
        for (String setName : this.SignatureGenesets.keySet()) {
            this.SignatureGenes.addAll(this.SignatureGenesets.get(setName).getGenes());
        }
    }

    public void buildDiseaseSignature() {
        int maxValue = this.SelectedSignatureGenesets.size() * this.EnrichmentGenesets.size();
        int currentProgress = 0;
        double currentNodeY_offset = this.paParams.getCurrentNodePlacementY_Offset();
        double currentNodeY_increment = 150.0;
        try {
            CyNetwork current_network = Cytoscape.getCurrentNetwork();
            CyNetworkView currentNetworkView = Cytoscape.getCurrentNetworkView();
            CyAttributes cyNodeAttrs = Cytoscape.getNodeAttributes();
            CyAttributes cyEdgeAttrs = Cytoscape.getEdgeAttributes();
            String prefix = this.paParams.getAttributePrefix();
            if (prefix == null) {
                prefix = "EM1_";
                this.paParams.setAttributePrefix(prefix);
            }
            HashMap<String, CyNode> nodesMap = new HashMap<String, CyNode>();
            List nodesList = current_network.nodesList();
            for (CyNode aNode : nodesList) {
                nodesMap.put(aNode.getIdentifier(), aNode);
            }
            HashSet<Integer> geneUniverse = new HashSet<Integer>();
            geneUniverse.addAll(this.EnrichmentGenes);
            geneUniverse.retainAll(this.SignatureGenes);
            int universeSize = geneUniverse.size();
            Iterator<String> i = this.SelectedSignatureGenesets.keySet().iterator();
            while (i.hasNext()) {
                String hub_name = i.next().toString();
                Iterator<String> j = this.EnrichmentGenesets.keySet().iterator();
                while (j.hasNext()) {
                    String geneset_name = j.next().toString();
                    int percentComplete = (int)((double)currentProgress / (double)maxValue * 100.0);
                    long timeRemaining = maxValue - currentProgress;
                    if (this.taskMonitor != null) {
                        this.taskMonitor.setPercentCompleted(percentComplete);
                        this.taskMonitor.setStatus("Computing Geneset similirity " + currentProgress + " of " + maxValue);
                        this.taskMonitor.setEstimatedTimeRemaining(timeRemaining);
                    }
                    ++currentProgress;
                    if (this.interrupted) {
                        throw new InterruptedException();
                    }
                    String similarity_key1 = hub_name + " (" + "sig" + ") " + geneset_name;
                    String similarity_key2 = geneset_name + " (" + "sig" + ") " + hub_name;
                    if (hub_name.equalsIgnoreCase(geneset_name) || !nodesMap.containsKey(geneset_name) || this.geneset_similarities.containsKey(similarity_key1) || this.geneset_similarities.containsKey(similarity_key2)) continue;
                    GeneSet geneset1 = this.SelectedSignatureGenesets.get(hub_name);
                    GeneSet geneset2 = this.EnrichmentGenesets.get(geneset_name);
                    HashSet<Integer> genes1 = geneset1.getGenes();
                    HashSet<Integer> genes2 = geneset2.getGenes();
                    genes1.retainAll(geneUniverse);
                    genes2.retainAll(geneUniverse);
                    HashSet<Integer> intersection = new HashSet<Integer>(genes1);
                    intersection.retainAll(genes2);
                    HashSet<Integer> union = new HashSet<Integer>(genes1);
                    union.addAll(genes2);
                    double coeffecient = this.paParams.getSignature_CutoffMetric() == 2 ? (double)intersection.size() / (double)union.size() : (this.paParams.getSignature_CutoffMetric() == 3 ? (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size()) : (this.paParams.isJaccard() ? (double)intersection.size() / (double)union.size() : (double)intersection.size() / Math.min((double)genes1.size(), (double)genes2.size())));
                    GenesetSimilarity comparison = new GenesetSimilarity(hub_name, geneset_name, coeffecient, intersection);
                    int N = universeSize;
                    int n = genes1.size();
                    int m = genes2.size();
                    int k = intersection.size();
                    double hyperPval = k > 0 ? BuildDiseaseSignatureTask.hyperGeomPvalue_sum(N, n, m, k, 0) : 1.0;
                    comparison.setHypergeom_pvalue(hyperPval);
                    comparison.setInteractionType("sig");
                    this.geneset_similarities.put(similarity_key1, comparison);
                }
                CyNode hub_node = Cytoscape.getCyNode((String)hub_name, (boolean)true);
                current_network.addNode((Node)hub_node);
                NodeView hubNodeView = currentNetworkView.getNodeView((Node)hub_node);
                double hubNodeY = hubNodeView.getYPosition();
                hubNodeView.setYPosition(hubNodeY + currentNodeY_offset);
                currentNodeY_offset += currentNodeY_increment;
                String formatted_label = VisualizeEnrichmentMapTask.formatLabel(hub_node.getIdentifier());
                cyNodeAttrs.setAttribute(hub_node.getIdentifier(), prefix + EnrichmentMapVisualStyle.FORMATTED_NAME, formatted_label);
                GeneSet sigGeneSet = this.SelectedSignatureGenesets.get(hub_name);
                if (this.paParams.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = sigGeneSet.getGenes();
                    for (Integer current : genes_hash) {
                        String gene = this.paParams.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    cyNodeAttrs.setListAttribute(hub_node.getIdentifier(), prefix + EnrichmentMapVisualStyle.GENES, gene_list);
                }
                sigGeneSet.getGenes().retainAll(this.paParams.getDatasetGenes());
                this.paParams.getGenesetsOfInterest().put(hub_name, sigGeneSet);
                cyNodeAttrs.setAttribute(hub_node.getIdentifier(), "node.shape", this.paParams.getSignatureHub_nodeShape());
                cyNodeAttrs.setAttribute(hub_node.getIdentifier(), "node.fillColor", this.paParams.getSignatureHub_nodeColor());
                cyNodeAttrs.setAttribute(hub_node.getIdentifier(), "node.borderColor", this.paParams.getSignatureHub_borderColor());
            }
            this.paParams.setCurrentNodePlacementY_Offset(currentNodeY_offset);
            i = this.geneset_similarities.keySet().iterator();
            while (i.hasNext()) {
                if (this.interrupted) {
                    throw new InterruptedException();
                }
                String edge_name = i.next().toString();
                if (!this.geneset_similarities.get(edge_name).getInteractionType().equals("sig") || !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset1_Name()) && !this.SelectedSignatureGenesets.containsKey(this.geneset_similarities.get(edge_name).getGeneset2_Name())) continue;
                boolean passed_cutoff = false;
                if (this.paParams.getSignature_CutoffMetric() == 1 && this.geneset_similarities.get(edge_name).getSizeOfOverlap() >= this.paParams.getSignature_absNumber_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 2 && this.geneset_similarities.get(edge_name).getSimilarity_coeffecient() >= this.paParams.getSignature_Jaccard_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 3 && this.geneset_similarities.get(edge_name).getSimilarity_coeffecient() >= this.paParams.getSignature_Overlap_Cutoff()) {
                    passed_cutoff = true;
                } else if (this.paParams.getSignature_CutoffMetric() == 0 && this.geneset_similarities.get(edge_name).getHypergeom_pvalue() != -1.0 && this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff()) {
                    passed_cutoff = true;
                }
                if (!passed_cutoff) continue;
                CyNode hub_node = Cytoscape.getCyNode((String)this.geneset_similarities.get(edge_name).getGeneset1_Name());
                CyNode gene_set = Cytoscape.getCyNode((String)this.geneset_similarities.get(edge_name).getGeneset2_Name());
                CyEdge edge = Cytoscape.getCyEdge((Node)hub_node, (Node)gene_set, (String)"interaction", (Object)"sig", (boolean)true);
                current_network.addEdge((Edge)edge);
                if (this.paParams.getHashkey2gene() != null) {
                    ArrayList<String> gene_list = new ArrayList<String>();
                    HashSet<Integer> genes_hash = this.geneset_similarities.get(edge_name).getOverlapping_genes();
                    for (Integer current : genes_hash) {
                        String gene = this.paParams.getGeneFromHashKey(current);
                        if (gene_list == null) continue;
                        gene_list.add(gene);
                    }
                    cyEdgeAttrs.setListAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.OVERLAP_GENES, gene_list);
                }
                cyEdgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.OVERLAP_SIZE, Integer.valueOf(this.geneset_similarities.get(edge_name).getSizeOfOverlap()));
                cyEdgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.SIMILARITY_COEFFECIENT, Double.valueOf(this.geneset_similarities.get(edge_name).getSimilarity_coeffecient()));
                cyEdgeAttrs.setAttribute(edge.getIdentifier(), prefix + EnrichmentMapVisualStyle.HYPERGEOM_PVALUE, Double.valueOf(this.geneset_similarities.get(edge_name).getHypergeom_pvalue()));
                cyEdgeAttrs.setAttribute(edge.getIdentifier(), "edge.color", this.paParams.getSignatureHub_edgeColor());
                if (this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff() / 100.0) {
                    cyEdgeAttrs.setAttribute(edge.getIdentifier(), "edge.lineWidth", "8.0");
                    continue;
                }
                if (this.geneset_similarities.get(edge_name).getHypergeom_pvalue() <= this.paParams.getSignature_Hypergeom_Cutoff() / 10.0) {
                    cyEdgeAttrs.setAttribute(edge.getIdentifier(), "edge.lineWidth", "4.5");
                    continue;
                }
                cyEdgeAttrs.setAttribute(edge.getIdentifier(), "edge.lineWidth", "1.0");
            }
            Cytoscape.getCurrentNetworkView().redrawGraph(false, true);
        }
        catch (InterruptedException e) {
            this.taskMonitor.setException((Throwable)e, "Generation of Signature Hubs cancelled");
        }
    }

    public static double hyperGeomPvalue(int N, int n, int m, int k) {
        double log_p = BuildDiseaseSignatureTask.binomialLog(m, k) + BuildDiseaseSignatureTask.binomialLog(N - m, n - k) - BuildDiseaseSignatureTask.binomialLog(N, n);
        return Math.exp(log_p);
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k, int mode) {
        double sum = 0.0;
        switch (mode) {
            case 0: {
                int kMax = Math.min(n, m);
                for (int k_prime = k; k_prime <= kMax; ++k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 1: {
                int kMax = Math.min(n, m);
                for (int k_prime = k + 1; k_prime <= kMax; ++k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 2: {
                for (int k_prime = k; k_prime >= 0; --k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
            case 3: {
                for (int k_prime = k - 1; k_prime >= 0; --k_prime) {
                    sum += BuildDiseaseSignatureTask.hyperGeomPvalue(N, n, m, k_prime);
                }
                break;
            }
        }
        return sum;
    }

    public static double hyperGeomPvalue_sum(int N, int n, int m, int k) {
        return BuildDiseaseSignatureTask.hyperGeomPvalue_sum(N, n, m, k, 0);
    }

    public static double binomialLog(int n, int k) {
        return Gamma.logGamma((double)((double)n + 1.0)) - Gamma.logGamma((double)((double)k + 1.0)) - Gamma.logGamma((double)((double)(n - k) + 1.0));
    }

    public void setPaParams(PostAnalysisParameters paParams) {
        this.paParams = paParams;
    }

    public PostAnalysisParameters getPaParams() {
        return this.paParams;
    }

    public void run() {
        this.buildDiseaseSignature();
    }

    public String getTitle() {
        return new String("Generating Signature Hubs");
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) throws IllegalThreadStateException {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }
}

