/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import cytoscape.Cytoscape;
import cytoscape.util.CyFileFilter;
import cytoscape.util.FileUtil;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.HeatMapPanel;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.Ranking;
import org.baderlab.csplugins.enrichmentmap.RanksFileReaderTask;

public class HeatMapActionListener
implements ActionListener {
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private HeatMapParameters hmParams;
    private JComboBox box;
    private EnrichmentMapParameters params;

    public HeatMapActionListener(HeatMapPanel edgeOverlapPanel, HeatMapPanel nodeOverlapPanel, JComboBox box, HeatMapParameters hmParams, EnrichmentMapParameters params) {
        this.edgeOverlapPanel = edgeOverlapPanel;
        this.nodeOverlapPanel = nodeOverlapPanel;
        this.hmParams = hmParams;
        this.box = box;
        this.params = params;
    }

    public void actionPerformed(ActionEvent evt) {
        this.edgeOverlapPanel.clearPanel();
        this.nodeOverlapPanel.clearPanel();
        String select = (String)this.box.getSelectedItem();
        if (select.equalsIgnoreCase("Data As Is")) {
            this.hmParams.setRowNorm(false);
            this.hmParams.setLogtransform(false);
            this.hmParams.setAsIS(true);
        } else if (select.equalsIgnoreCase("Row Normalize Data")) {
            this.hmParams.setRowNorm(true);
            this.hmParams.setLogtransform(false);
            this.hmParams.setAsIS(false);
        } else if (select.equalsIgnoreCase("Log Transform Data")) {
            this.hmParams.setRowNorm(false);
            this.hmParams.setLogtransform(true);
            this.hmParams.setAsIS(false);
        } else if (select.equalsIgnoreCase("Hierarchical Cluster")) {
            this.hmParams.setSortbyrank(false);
            this.hmParams.setSortbycolumn(false);
            this.hmParams.setSortIndex(-1);
        } else if (select.equalsIgnoreCase("Add Rankings ... ")) {
            HashMap<String, HashMap<Integer, Ranking>> all_ranks = this.params.getRanks();
            CyFileFilter filter = new CyFileFilter();
            filter.addExtension("txt");
            filter.addExtension("xls");
            filter.addExtension("rnk");
            File file = FileUtil.getFile((String)"Import new Rank file", (int)FileUtil.LOAD, (CyFileFilter[])new CyFileFilter[]{filter});
            if (file != null) {
                String ranks_name = JOptionPane.showInputDialog((Component)Cytoscape.getDesktop(), "What would you like to name these Rankings?", "My Rankings");
                boolean noname = true;
                while (noname) {
                    noname = false;
                    Iterator<String> j = all_ranks.keySet().iterator();
                    while (j.hasNext()) {
                        String current_name = j.next().toString();
                        if (!current_name.equalsIgnoreCase(ranks_name)) continue;
                        noname = true;
                        ranks_name = JOptionPane.showInputDialog((Component)Cytoscape.getDesktop(), (Object)"Sorry that name already exists.Please choose another name.");
                    }
                }
                RanksFileReaderTask ranking1 = new RanksFileReaderTask(this.params, file.getAbsolutePath(), ranks_name);
                ranking1.run();
            }
        } else {
            HashMap<String, HashMap<Integer, Ranking>> ranks = this.params.getRanks();
            Iterator<String> j = ranks.keySet().iterator();
            while (j.hasNext()) {
                String ranks_name = j.next().toString();
                if (!ranks_name.equalsIgnoreCase(select)) continue;
                this.hmParams.setSortbyrank(true);
                this.hmParams.setSortbycolumn(false);
                this.hmParams.setRankFileIndex(ranks_name);
                this.hmParams.setSortIndex(-1);
            }
        }
        this.hmParams.ResetColorGradient();
        this.edgeOverlapPanel.updatePanel();
        this.nodeOverlapPanel.updatePanel();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        CytoPanel cytoPanel = desktop.getCytoPanel(5);
        int index = cytoPanel.getSelectedIndex();
        cytoPanel.setSelectedIndex(index);
    }
}

