/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.baderlab.csplugins.enrichmentmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.TableSort;

public class TableHeader
extends MouseAdapter {
    private JTable table;
    private TableSort sort;
    private boolean isSort = false;
    private HeatMapParameters hmparams;

    public TableHeader(TableSort sort, JTable table, HeatMapParameters hmparams) {
        this.sort = sort;
        this.table = table;
        this.hmparams = hmparams;
    }

    public TableHeader() {
    }

    public static void mount(TableSort sort, JTable table) {
        TableHeader header = new TableHeader();
        header.table = table;
        header.sort = sort;
        JTableHeader tableHdr = table.getTableHeader();
        tableHdr.addMouseListener(header);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        TableColumnModel columnModel = this.table.getColumnModel();
        int viewColumn = columnModel.getColumnIndexAtX(mouseEvent.getX());
        int column = this.table.convertColumnIndexToModel(viewColumn);
        int evt = mouseEvent.getClickCount();
        if (evt == 1 && column != -1) {
            this.isSort = !this.isSort;
            this.hmparams.setSortbycolumn(true);
            this.hmparams.setSortbyrank(false);
            this.hmparams.setSortIndex(column);
            this.hmparams.setSortbycolumn_event_triggered(true);
            this.hmparams.changeSortComboBoxToColumnSorted();
        }
    }

    public void sortByColumn(int column, boolean ascending) {
        this.sort.sortByColumn(column, ascending);
    }

    public void setSort(boolean isSort) {
        this.isSort = isSort;
    }

    public boolean isSort() {
        return this.isSort;
    }

    private JTable getTable() {
        return this.table;
    }

    private void setTable(JTable table) {
        this.table = table;
    }
}

