/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapVisualStyle;
import org.baderlab.csplugins.enrichmentmap.Enrichment_Map_Plugin;
import org.baderlab.csplugins.enrichmentmap.LegendPanel;
import org.baderlab.csplugins.enrichmentmap.SliderBarPanel;

public class ParametersPanel
extends JPanel {
    public static int summaryPanelWidth = 150;
    public static int summaryPanelHeight = 1000;

    public void updatePanel(EnrichmentMapParameters params) {
        this.removeAll();
        this.revalidate();
        this.setLayout(new BorderLayout());
        JPanel main = new JPanel(new BorderLayout());
        JPanel legends = this.createLegend(params);
        main.add((Component)legends, "North");
        JTextPane runInfo = new JTextPane();
        runInfo.setEditable(false);
        runInfo.setContentType("text/html");
        runInfo.setText(this.getRunInfo(params));
        runInfo.setPreferredSize(new Dimension(summaryPanelWidth, summaryPanelHeight / 2));
        main.add((Component)runInfo, "South");
        JScrollPane jScrollPane = new JScrollPane(main);
        this.add(jScrollPane);
        this.revalidate();
    }

    private String getRunInfo(EnrichmentMapParameters params) {
        String runInfoText = "<html> <h1>Parameters:</h1>";
        runInfoText = runInfoText + "<b>P-value Cut-off:</b>" + params.getPvalue() + "<br>";
        runInfoText = runInfoText + "<b>FDR Q-value Cut-off:</b>" + params.getQvalue() + "<br>";
        if (params.isJaccard()) {
            runInfoText = runInfoText + "<b>Jaccard Cut-off:</b>" + params.getSimilarityCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Jaccard Index<br>";
        } else {
            runInfoText = runInfoText + "<b>Overlap Cut-off:</b>" + params.getSimilarityCutOff() + "<br>";
            runInfoText = runInfoText + "<b>Test used:</b>  Overlap Index<br>";
        }
        runInfoText = runInfoText + "<font size=-1><b>Genesets File:</b>" + this.shortenPathname(params.getGMTFileName()) + "<br>";
        runInfoText = runInfoText + "<b>Dataset 1 Data Files:</b> " + this.shortenPathname(params.getEnrichmentDataset1FileName1()) + ",<br>" + this.shortenPathname(params.getEnrichmentDataset1FileName2()) + "<br>";
        if (params.isTwoDatasets()) {
            runInfoText = runInfoText + "<b>Dataset 2 Data Files:</b> " + this.shortenPathname(params.getEnrichmentDataset2FileName1()) + ",<br>" + this.shortenPathname(params.getEnrichmentDataset2FileName2()) + "<br>";
        }
        if (params.isData()) {
            runInfoText = runInfoText + "<b>Data file:</b>" + this.shortenPathname(params.getExpressionFileName1()) + "<br>";
        }
        if (params.isData2()) {
            runInfoText = runInfoText + "<b>Data file 2:</b>" + this.shortenPathname(params.getExpressionFileName2()) + "<br>";
        }
        runInfoText = runInfoText + "</font></html>";
        return runInfoText;
    }

    private JPanel createLegend(EnrichmentMapParameters params) {
        JPanel legends = new JPanel();
        this.setPreferredSize(new Dimension(summaryPanelWidth, summaryPanelHeight / 2));
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        legends.setLayout(gridbag);
        c.weighty = 1.0;
        c.weightx = 1.0;
        c.fill = 0;
        c.gridheight = 1;
        c.anchor = 21;
        c.insets = new Insets(5, 30, 5, 2);
        c.gridwidth = 0;
        c.gridx = 0;
        c.gridy = 0;
        URL nodeIconURL = Enrichment_Map_Plugin.class.getResource("resources/node_color_small.png");
        if (nodeIconURL != null) {
            ImageIcon nodeIcon = new ImageIcon(nodeIconURL);
            JLabel nodeColorLabel = new JLabel(nodeIcon);
            gridbag.setConstraints(nodeColorLabel, c);
            legends.add(nodeColorLabel);
        }
        LegendPanel node_legend = new LegendPanel(EnrichmentMapVisualStyle.max_phenotype1, EnrichmentMapVisualStyle.max_phenotype2, params.getDataset1Phenotype1(), params.getDataset1Phenotype2());
        node_legend.setToolTipText("Phenotype * (1-P_value)");
        c.gridx = 0;
        c.gridy = 1;
        c.insets = new Insets(0, 0, 0, 0);
        gridbag.setConstraints(node_legend, c);
        legends.add(node_legend);
        if (params.isTwoDatasets()) {
            c.gridx = 0;
            c.gridy = 2;
            c.insets = new Insets(5, 30, 5, 2);
            URL nodeborderIconURL = Enrichment_Map_Plugin.class.getResource("resources/node_border_color_small.png");
            if (nodeborderIconURL != null) {
                ImageIcon nodeborderIcon = new ImageIcon(nodeborderIconURL);
                JLabel nodeborderColorLabel = new JLabel(nodeborderIcon);
                gridbag.setConstraints(nodeborderColorLabel, c);
                legends.add(nodeborderColorLabel);
            }
            LegendPanel node_legend2 = new LegendPanel(EnrichmentMapVisualStyle.max_phenotype1, EnrichmentMapVisualStyle.max_phenotype2, params.getDataset2Phenotype1(), params.getDataset2Phenotype2());
            node_legend2.setToolTipText("Phenotype * (1-P_value)");
            c.gridx = 0;
            c.gridy = 3;
            c.insets = new Insets(0, 0, 0, 0);
            gridbag.setConstraints(node_legend2, c);
            legends.add(node_legend2);
        }
        c.gridx = 0;
        c.gridy = 4;
        c.insets = new Insets(0, 0, 0, 0);
        c.fill = 0;
        c.gridwidth = 0;
        c.anchor = 21;
        SliderBarPanel pvalueSlider = params.getPvalueSlider();
        gridbag.setConstraints(pvalueSlider, c);
        legends.add(pvalueSlider);
        if (params.isFDR()) {
            SliderBarPanel qvalueSlider = params.getQvalueSlider();
            c.gridx = 0;
            c.gridy = 5;
            gridbag.setConstraints(qvalueSlider, c);
            legends.add(qvalueSlider);
        }
        return legends;
    }

    private String shortenPathname(String pathname) {
        if (pathname != null) {
            String[] tokens = pathname.split("\\" + File.separator);
            int num_tokens = tokens.length;
            String new_pathname = num_tokens >= 2 ? "..." + File.separator + tokens[num_tokens - 2] + File.separator + tokens[num_tokens - 1] : pathname;
            return new_pathname;
        }
        return pathname;
    }
}

