/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.heatmap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.baderlab.csplugins.enrichmentmap.heatmap.ExpressionTableValue;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapTableModel;

public class RawExpressionValueRenderer
extends JLabel
implements TableCellRenderer {
    private static final long serialVersionUID = 1L;
    Border unselectedBorder = null;
    Border selectedBorder = null;
    boolean isBordered = true;
    HeatMapTableModel ogt = new HeatMapTableModel();

    public RawExpressionValueRenderer() {
        this.isBordered = this.isBordered;
        this.setOpaque(true);
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color newColor = null;
        Double numberValue = 0.0;
        if (value != null && value instanceof ExpressionTableValue) {
            ExpressionTableValue avalue = (ExpressionTableValue)value;
            numberValue = avalue.getExpression_value();
            newColor = avalue.getExpression_color();
        }
        DecimalFormat formatter = new DecimalFormat("###.##");
        String result = formatter.format(numberValue);
        this.setText(result.toString());
        this.setFont(new Font(UIManager.getFont("TableHeader.font").getName(), 0, UIManager.getFont("TableHeader.font").getSize() - 2));
        this.setHorizontalAlignment(4);
        TableModel tc = table.getModel();
        this.setBackground(newColor);
        if (this.isBordered) {
            if (isSelected) {
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, table.getSelectionBackground());
                }
                this.setBorder(this.selectedBorder);
            } else {
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(0, 0, 0, 0, table.getBackground());
                }
                this.setBorder(this.unselectedBorder);
            }
        }
        this.setToolTipText("Exp value: " + numberValue);
        return this;
    }
}

