/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.model;

import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;

public class GenericResult
extends EnrichmentResult {
    private int gsSize = 0;
    private double fdrqvalue = 1.0;
    private double NES = 1.0;
    private String source = "none";

    public GenericResult(String[] tokens) {
        this.name = tokens[1];
        this.desc = tokens[2];
        this.pvalue = Double.parseDouble(tokens[3]);
        this.gsSize = Integer.parseInt(tokens[4]);
        this.fdrqvalue = Double.parseDouble(tokens[5]);
        this.NES = Double.parseDouble(tokens[6]);
        this.setSource();
    }

    public GenericResult(String name, String description, double pvalue, int gssize) {
        this.name = name;
        this.desc = description;
        this.pvalue = pvalue;
        this.gsSize = gssize;
        this.setSource();
    }

    public GenericResult(String name, String description, double pvalue, int gssize, double fdrqvalue) {
        this.name = name;
        this.desc = description;
        this.pvalue = pvalue;
        this.gsSize = gssize;
        this.fdrqvalue = fdrqvalue;
        this.setSource();
    }

    public GenericResult(String name, String description, double pvalue, int gssize, double fdrqvalue, double phenotype) {
        this.name = name;
        this.desc = description;
        this.gsSize = gssize;
        this.pvalue = pvalue;
        this.fdrqvalue = fdrqvalue;
        this.NES = phenotype;
        this.setSource();
    }

    public boolean geneSetOfInterest(double pvalue, double fdrqvalue, boolean useFDR) {
        if (useFDR) {
            return this.pvalue <= pvalue && this.fdrqvalue <= fdrqvalue;
        }
        return this.pvalue <= pvalue;
    }

    public double getFdrqvalue() {
        return this.fdrqvalue;
    }

    public void setFdrqvalue(double fdrqvalue) {
        this.fdrqvalue = fdrqvalue;
    }

    public int getGsSize() {
        return this.gsSize;
    }

    public void setGsSize(int gs_size) {
        this.gsSize = gs_size;
    }

    public double getNES() {
        return this.NES;
    }

    public void setNES(double NES) {
        this.NES = NES;
    }

    public String toString() {
        return this.name + "\t" + this.desc + "\t" + this.pvalue + "\t" + this.gsSize + "\t" + this.fdrqvalue + "\t" + this.NES;
    }
}

