/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.task;

import cytoscape.task.Task;
import cytoscape.task.TaskMonitor;
import java.util.HashMap;
import java.util.Iterator;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.DataSet;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentResult;
import org.baderlab.csplugins.enrichmentmap.model.GeneSet;
import org.baderlab.csplugins.enrichmentmap.model.GenericResult;
import org.baderlab.csplugins.enrichmentmap.model.GenesetSimilarity;
import org.baderlab.csplugins.enrichmentmap.model.SetOfEnrichmentResults;
import org.baderlab.csplugins.enrichmentmap.task.ComputeSimilarityTask;
import org.baderlab.csplugins.enrichmentmap.task.LoadDataSetTask;
import org.baderlab.csplugins.enrichmentmap.task.VisualizeEnrichmentMapTask;

public class BuildGMTEnrichmentMapTask
implements Task {
    private int maxValue;
    private TaskMonitor taskMonitor = null;
    private boolean interrupted = false;
    private EnrichmentMapParameters params = new EnrichmentMapParameters();

    public BuildGMTEnrichmentMapTask(EnrichmentMapParameters params) {
        this.params.copyInputParameters(params);
    }

    public void buildEnrichmentMap() {
        try {
            EnrichmentMap map = new EnrichmentMap(this.params);
            DataSet current_dataset = map.getDataset("Dataset 1");
            LoadDataSetTask dataset = new LoadDataSetTask(current_dataset, this.taskMonitor);
            dataset.run();
            this.params.setMethod("generic");
            current_dataset.setGenesetsOfInterest(current_dataset.getSetofgenesets());
            ComputeSimilarityTask similarities = new ComputeSimilarityTask(map, this.taskMonitor);
            similarities.run();
            HashMap<String, GenesetSimilarity> similarity_results = similarities.getGeneset_similarities();
            map.setGenesetSimilarity(similarity_results);
            HashMap<String, GeneSet> current_sets = current_dataset.getSetofgenesets().getGenesets();
            SetOfEnrichmentResults setofenrichments = new SetOfEnrichmentResults();
            HashMap<String, EnrichmentResult> currentEnrichments = setofenrichments.getEnrichments();
            Iterator<String> i = current_sets.keySet().iterator();
            while (i.hasNext()) {
                String geneset1_name = i.next().toString();
                GeneSet current = current_sets.get(geneset1_name);
                GenericResult temp_result = new GenericResult(current.getName(), current.getDescription(), 0.01, current.getGenes().size());
                currentEnrichments.put(current.getName(), temp_result);
            }
            current_dataset.setEnrichments(setofenrichments);
            VisualizeEnrichmentMapTask viz_map = new VisualizeEnrichmentMapTask(map, this.taskMonitor);
            viz_map.run();
        }
        catch (OutOfMemoryError e) {
            this.taskMonitor.setException((Throwable)e, "Out of Memory. Please increase memory allotement for cytoscape.");
        }
        catch (Exception e) {
            this.taskMonitor.setException((Throwable)e, "unable to build/visualize map");
        }
    }

    public void run() {
        this.buildEnrichmentMap();
    }

    public void halt() {
        this.interrupted = true;
    }

    public void setTaskMonitor(TaskMonitor taskMonitor) {
        if (this.taskMonitor != null) {
            throw new IllegalStateException("Task Monitor is already set.");
        }
        this.taskMonitor = taskMonitor;
    }

    public String getTitle() {
        return new String("Building Enrichment Map based on GMT File");
    }
}

