/*
 * Decompiled with CFR 0.152.
 */
package org.baderlab.csplugins.enrichmentmap.actions;

import cytoscape.Cytoscape;
import cytoscape.view.CytoscapeDesktop;
import cytoscape.view.cytopanels.CytoPanel;
import giny.model.Edge;
import giny.model.Node;
import giny.view.GraphViewChangeEvent;
import giny.view.GraphViewChangeListener;
import java.awt.Component;
import java.util.List;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapManager;
import org.baderlab.csplugins.enrichmentmap.EnrichmentMapUtils;
import org.baderlab.csplugins.enrichmentmap.heatmap.HeatMapParameters;
import org.baderlab.csplugins.enrichmentmap.model.EnrichmentMap;
import org.baderlab.csplugins.enrichmentmap.view.HeatMapPanel;

public class EnrichmentMapActionListener
implements GraphViewChangeListener {
    private EnrichmentMap map;
    private HeatMapPanel edgeOverlapPanel;
    private HeatMapPanel nodeOverlapPanel;
    private List<Node> Nodes;
    private List<Edge> Edges;
    private final CytoPanel cytoPanel;

    public EnrichmentMapActionListener(EnrichmentMap map) {
        this.map = map;
        EnrichmentMapManager manager = EnrichmentMapManager.getInstance();
        CytoscapeDesktop desktop = Cytoscape.getDesktop();
        this.cytoPanel = desktop.getCytoPanel(5);
        if (map.getParams().isData()) {
            this.edgeOverlapPanel = manager.getEdgesOverlapPanel();
            this.nodeOverlapPanel = manager.getNodesOverlapPanel();
            HeatMapParameters hmParams = new HeatMapParameters(this.edgeOverlapPanel, this.nodeOverlapPanel);
            hmParams.initColorGradients(map.getDataset("Dataset 1").getExpressionSets());
            map.getParams().setHmParams(hmParams);
        }
        this.Nodes = map.getParams().getSelectedNodes();
        this.Edges = map.getParams().getSelectedEdges();
    }

    public void graphViewChanged(GraphViewChangeEvent event) {
        int i;
        boolean override_revalidate_heatmap = EnrichmentMapUtils.isOverrideHeatmapRevalidation();
        if (event.isEdgesSelectedType() && !override_revalidate_heatmap) {
            Edge[] selectedEdges = event.getSelectedEdges();
            for (i = 0; i < selectedEdges.length; ++i) {
                if (this.Edges.contains(selectedEdges[i])) continue;
                this.Edges.add(selectedEdges[i]);
            }
            this.createEdgesData();
        }
        if (event.isNodesSelectedType() && !override_revalidate_heatmap) {
            Node[] selectedNodes = event.getSelectedNodes();
            for (i = 0; i < selectedNodes.length; ++i) {
                if (this.Nodes.contains(selectedNodes[i])) continue;
                this.Nodes.add(selectedNodes[i]);
            }
            this.createNodesData();
        }
        if (event.isNodesUnselectedType()) {
            Node[] unselectedNodes = event.getUnselectedNodes();
            for (i = 0; i < unselectedNodes.length; ++i) {
                if (!this.Nodes.contains(unselectedNodes[i])) continue;
                this.Nodes.remove(unselectedNodes[i]);
            }
            if (!this.Nodes.isEmpty()) {
                this.createNodesData();
            }
            if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
                this.clearPanels();
            }
        }
        if (event.isEdgesUnselectedType()) {
            Edge[] unselectedEdges = event.getUnselectedEdges();
            for (i = 0; i < unselectedEdges.length; ++i) {
                if (!this.Edges.contains(unselectedEdges[i])) continue;
                this.Edges.remove(unselectedEdges[i]);
            }
            if (!this.Edges.isEmpty()) {
                this.createEdgesData();
            }
            if (this.Nodes.isEmpty() && this.Edges.isEmpty()) {
                this.clearPanels();
            }
        }
    }

    public void createEdgesData() {
        if (this.map.getParams().isData()) {
            this.edgeOverlapPanel.updatePanel(this.map);
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.edgeOverlapPanel));
            }
            this.edgeOverlapPanel.revalidate();
        }
    }

    private void createNodesData() {
        if (this.map.getParams().isData()) {
            this.nodeOverlapPanel.updatePanel(this.map);
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.nodeOverlapPanel));
            }
            this.nodeOverlapPanel.revalidate();
        }
    }

    public void clearPanels() {
        if (this.map.getParams().isData()) {
            this.nodeOverlapPanel.clearPanel();
            this.edgeOverlapPanel.clearPanel();
            if (!this.map.getParams().isDisableHeatmapAutofocus()) {
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.nodeOverlapPanel));
                this.cytoPanel.setSelectedIndex(this.cytoPanel.indexOfComponent((Component)this.edgeOverlapPanel));
            }
        }
    }
}

