import sys
import tarfile
import os
import math


def load_disorder(path):
    '''
    Read disorder file generated by DISOPRED
    '''

    tar = tarfile.open(path + "/disorder.tar.gz", "r:gz")
    data = {}
    for tarinfo in tar:
        if tarinfo.isfile():
            file_data = tar.extractfile(tarinfo).readlines()
            pid = tarinfo.name.strip("yeast/").strip(".diso")
            data[pid] = []
            val = 0.0
            for line in file_data[5:]:
                line = line.strip().split()
                if line[2] == "*":
                    data[pid].append(1)
                else:
                    data[pid].append(0)
    return data


def disorder_score(pid, stat, stop, disd, pos):
    '''
    Average of disordered scores
    '''

    if pid in disd:
        regn = disd[pid][stat : stop]
        #return sum(regn) / float(len(regn))
        sum_resd = 0.0
        for idx, value in enumerate(regn):
            if idx in pos:
                sum_resd += value

        return sum_resd / float(len(pos))
	return None



if __name__ == "__main__":
    os.environ["WORK_DIR_GEN"] = "../../"
    disd = read_disorder()


