package org.baderlab.brain;

import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

import java.awt.*;
import java.util.ArrayList;

/**
 * Paints colors for the sequence logo according to Berkeley WebLogo
 */
public class WebLogoProteinStyle implements SymbolStyle {
    private ArrayList<Color> colorList;
    AminoAcidGrouping aaGroup;

    public WebLogoProteinStyle() {
        //since not color settings are provided, we use default color settings
        // provided by a new instance of AminoAcidGrouping
        aaGroup = new AminoAcidGrouping();
        aaGroup.setColoring(AminoAcidGrouping.COLORING_WEBLOGO);
    }

    public WebLogoProteinStyle(AminoAcidGrouping aaGrouping) {
        //color settings are provided in the given AminoAcidGrouping object
        aaGroup = aaGrouping;
    }

    public Paint outlinePaint(Symbol s) throws IllegalSymbolException {
        return fillPaint(s);
    }

    public Paint fillPaint(Symbol s) throws IllegalSymbolException {
        Paint fillColor = aaGroup.getColor(s);

        //TODO - if null, we should return a default color (or just null and let the caller handle it)
        if (fillColor == null) {
            return Color.black;
        }
        return fillColor;

//        //polar amino acids (G,S,T,Y,C,Q,N) are green
//        if (s.equals(ProteinTools.g()) || s.equals(ProteinTools.s()) || s.equals(ProteinTools.t()) ||
//                s.equals(ProteinTools.y()) || s.equals(ProteinTools.c()) || s.equals(ProteinTools.q()) ||
//                s.equals(ProteinTools.n())) {
//            fillColor = colorList.get(0);
//
//        //acidic (D,E) red
//        } else if (s.equals(ProteinTools.d()) || s.equals(ProteinTools.e())) {
//            fillColor = colorList.get(1);
//
//        //basic (K,R,H) blue
//        } else if (s.equals(ProteinTools.k()) || s.equals(ProteinTools.r()) || s.equals(ProteinTools.h())) {
//            fillColor = colorList.get(2);
//
//        //hydrophobic (A,V,L,I,P,W,F,M) amino acids are black
//        } else {
//            fillColor = colorList.get(3);
//        }
//
//        return fillColor;
    }
}
