/*
 * Copyright (C) 2003, 2004 Bjrn-Ove Heimsund
 * 
 * This file is part of SMT.
 * 
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published by the
 * Free Software Foundation; either version 2.1 of the License, or (at your
 * option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License
 * for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

package smt.test;

import junit.framework.Test;
import junit.framework.TestSuite;

/**
 * Test of SMT
 */
public class AllTests {

	public static Test suite() {
		TestSuite suite = new TestSuite("Test for smt.test");
		//$JUnit-BEGIN$
		suite.addTest(new TestSuite(BiCGDiagonalTest.class));
		suite.addTest(new TestSuite(BiCGILUTest.class));
		suite.addTest(new TestSuite(BiCGTest.class));
		suite.addTest(new TestSuite(BiCGstabDiagonalTest.class));
		suite.addTest(new TestSuite(BiCGstabILUTest.class));
		suite.addTest(new TestSuite(BiCGstabTest.class));
		suite.addTest(new TestSuite(CGDiagonalTest.class));
		suite.addTest(new TestSuite(CGICCTest.class));
		suite.addTest(new TestSuite(CGSDiagonalTest.class));
		suite.addTest(new TestSuite(CGSILUTest.class));
		suite.addTest(new TestSuite(CGSSORTest.class));
		suite.addTest(new TestSuite(CGSTest.class));
		suite.addTest(new TestSuite(CGTest.class));
		suite.addTest(new TestSuite(ChebyshevDiagonalTest.class));
		suite.addTest(new TestSuite(ChebyshevICCTest.class));
		suite.addTest(new TestSuite(ChebyshevSSORTest.class));
		suite.addTest(new TestSuite(ChebyshevTest.class));
		suite.addTest(new TestSuite(CompColMatrixTest.class));
		suite.addTest(new TestSuite(CompDiagMatrixTest.class));
		suite.addTest(new TestSuite(CompRowMatrixTest.class));
		suite.addTest(new TestSuite(CoordMatrixTest.class));
		suite.addTest(new TestSuite(FlexCompColMatrixTest.class));
		suite.addTest(new TestSuite(FlexCompRowMatrixTest.class));
		suite.addTest(new TestSuite(GMRESDiagonalTest.class));
		suite.addTest(new TestSuite(GMRESILUTest.class));
		suite.addTest(new TestSuite(GMRESTest.class));
		suite.addTest(new TestSuite(HashColMatrixTest.class));
		suite.addTest(new TestSuite(HashRowMatrixTest.class));
		suite.addTest(new TestSuite(HashVectorTest.class));
		suite.addTest(new TestSuite(IRDiagonalTest.class));
		suite.addTest(new TestSuite(IRILUTest.class));
		suite.addTest(new TestSuite(InverseIterationTest.class));
		suite.addTest(new TestSuite(PowerIterationTest.class));
		suite.addTest(new TestSuite(QMRDiagonalTest.class));
		suite.addTest(new TestSuite(QMRILUTest.class));
		suite.addTest(new TestSuite(QMRTest.class));
		suite.addTest(new TestSuite(RayleighIterationTest.class));
		suite.addTest(new TestSuite(SparseVectorTest.class));
		//$JUnit-END$
		return suite;
	}
}
