package org.baderlab.brain;

import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.seq.ProteinTools;

import java.util.Iterator;
import java.util.List;
import java.util.ArrayList;
import java.io.File;
import java.io.IOException;

/**
 * Created by IntelliJ IDEA.
 * User: shirleyhui
 * Date: Apr 9, 2009
 * Time: 10:39:25 PM
 * To change this template use File | Settings | File Templates.
 */
public class PWMToProfileReader
{
    public static List readPWMsAsProfiles(File projectFile, /*,double fuzzFactor,*/ File codonBiasFile) {
        ProfileSearchProjectFile profileProjectFile = new ProfileSearchProjectFile();
        ArrayList profileList = new ArrayList();

        if (projectFile == null) {
            throw new RuntimeException("Project file must be specified.");
        }

        //test the file to see what type it is: profile or project?
        Iterator files = null;
        try
        {
            if (profileProjectFile.isProjectFile(projectFile.toString()))
            {
                //read project file
                profileProjectFile.read(projectFile.toString());
                files = profileProjectFile.getFileNames();
            } else {
                //read a single profile (list of peptides)
                ArrayList fileList = new ArrayList(1);
                fileList.add(projectFile.toString());
                files = fileList.iterator();
            }

            FiniteAlphabet alpha = ProteinTools.getAlphabet();
            while (files.hasNext()) {
                String pwmFileName = (String) files.next();
                System.out.println("Loading PWM from " + pwmFileName);

                BindingPWM pwm = new BindingPWM();
                pwm.read(new File(pwmFileName), alpha);
                ProteinProfile profile = new ProteinProfile(pwm.getWeightMatrix(), pwm.getName() );
                if (codonBiasFile != null) {
                    profile.reWeightByCodonBias(codonBiasFile);
                }
                profileList.add(profile);
            }
        }
        catch (IOException e)
        {
            e.printStackTrace();
        }

        return (profileList);
    }

    

    
}
