/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.plugins;

import com.lowagie.text.pdf.PdfEncryptor;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.tools.arguments.BitsetArgument;
import com.lowagie.tools.arguments.FileArgument;
import com.lowagie.tools.arguments.OptionArgument;
import com.lowagie.tools.arguments.PdfFilter;
import com.lowagie.tools.arguments.ToolArgument;
import com.lowagie.tools.plugins.AbstractTool;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.swing.JInternalFrame;
import javax.swing.JOptionPane;

public class Encrypt
extends AbstractTool {
    private static final int[] PERMISSIONS;
    private static final String[] PERMISSION_OPTIONS;

    public Encrypt() {
        this.arguments.add(new FileArgument(this, "srcfile", "The file you want to encrypt", false, new PdfFilter()));
        this.arguments.add(new FileArgument(this, "destfile", "The file to which the encrypted PDF has to be written", true, new PdfFilter()));
        this.arguments.add(new ToolArgument(this, "ownerpassword", "The ownerpassword you want to add to the PDF file", String.class.getName()));
        this.arguments.add(new ToolArgument(this, "userpassword", "The userpassword you want to add to the PDF file", String.class.getName()));
        this.arguments.add(new BitsetArgument((AbstractTool)this, "permissions", "Permissions on the file", PERMISSION_OPTIONS));
        OptionArgument optionArgument = new OptionArgument(this, "strength", "Strength of the encryption");
        optionArgument.addOption("40 bit encryption", "40");
        optionArgument.addOption("128 bit encryption", "128");
        this.arguments.add(optionArgument);
    }

    protected void createFrame() {
        this.internalFrame = new JInternalFrame("Encrypt", true, false, true);
        this.internalFrame.setSize(300, 80);
        this.internalFrame.setJMenuBar(this.getMenubar());
        System.out.println("=== Encrypt OPENED ===");
    }

    public void execute() {
        try {
            if (this.getValue("srcfile") == null) {
                throw new InstantiationException("You need to choose a sourcefile");
            }
            if (this.getValue("destfile") == null) {
                throw new InstantiationException("You need to choose a destination file");
            }
            int n = 0;
            String string = (String)this.getValue("permissions");
            if (string != null) {
                for (int i = 0; i < string.length(); ++i) {
                    n |= string.charAt(i) == '0' ? 0 : PERMISSIONS[i];
                }
            }
            byte[] byArray = null;
            if (this.getValue("userpassword") != null) {
                byArray = ((String)this.getValue("userpassword")).getBytes();
            }
            byte[] byArray2 = null;
            if (this.getValue("ownerpassword") != null) {
                byArray2 = ((String)this.getValue("ownerpassword")).getBytes();
            }
            PdfReader pdfReader = new PdfReader(((File)this.getValue("srcfile")).getAbsolutePath());
            PdfEncryptor.encrypt(pdfReader, (OutputStream)new FileOutputStream((File)this.getValue("destfile")), byArray, byArray2, n, "128".equals(this.getValue("strength")));
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.internalFrame, exception.getMessage(), exception.getClass().getName(), 0);
            System.err.println(exception.getMessage());
        }
    }

    public void valueHasChanged(ToolArgument toolArgument) {
        if (this.internalFrame == null) {
            return;
        }
    }

    public static void main(String[] stringArray) {
        Encrypt encrypt = new Encrypt();
        if (stringArray.length < 2) {
            System.err.println(encrypt.getUsage());
        }
        encrypt.setArguments(stringArray);
        encrypt.execute();
    }

    protected File getDestPathPDF() throws InstantiationException {
        return (File)this.getValue("destfile");
    }

    static {
        Encrypt.addVersion("$Id: Encrypt.java,v 1.13 2007/02/06 13:10:37 blowagie Exp $");
        PERMISSIONS = new int[]{2052, 8, 16, 32, 256, 512, 1024, 4};
        PERMISSION_OPTIONS = new String[]{"AllowPrinting", "AllowModifyContents", "AllowCopy", "AllowModifyAnnotations", "AllowFillIn (128 bit only)", "AllowScreenReaders (128 bit only)", "AllowAssembly (128 bit only)", "AllowDegradedPrinting (128 bit only)"};
    }
}

