/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeField;
import org.biojava.utils.bytecode.CodeMethod;

public class ConstantPool {
    private static final byte CONSTANT_Class = 7;
    private static final byte CONSTANT_Fieldref = 9;
    private static final byte CONSTANT_Methodref = 10;
    private static final byte CONSTANT_InterfaceMethodref = 11;
    private static final byte CONSTANT_String = 8;
    private static final byte CONSTANT_Integer = 3;
    private static final byte CONSTANT_Float = 4;
    private static final byte CONSTANT_Long = 5;
    private static final byte CONSTANT_Double = 6;
    private static final byte CONSTANT_NameAndType = 12;
    private static final byte CONSTANT_Utf8 = 1;
    private List constants = new ArrayList();

    public ConstantPool() {
        this.constants.add(null);
    }

    public int resolveClass(CodeClass c) {
        return this.resolve(new CPTypedStringEntry(7, this.resolveUtf8(c.getJName())));
    }

    public int resolveField(CodeField f) {
        try {
            return this.resolve(new CPRefEntry(9, this.resolveClass(f.getContainingClass()), this.resolveNameAndType(f.getName(), f.getType().getDescriptor())));
        }
        catch (NullPointerException npe) {
            throw new Error("Can't resolve filed " + f);
        }
    }

    public int resolveMethod(CodeMethod m) {
        return this.resolve(new CPRefEntry(10, this.resolveClass(m.getContainingClass()), this.resolveNameAndType(m.getName(), m.getDescriptor())));
    }

    public int resolveInterfaceMethod(CodeMethod m) {
        return this.resolve(new CPRefEntry(11, this.resolveClass(m.getContainingClass()), this.resolveNameAndType(m.getName(), m.getDescriptor())));
    }

    public int resolveString(String s) {
        return this.resolve(new CPTypedStringEntry(8, this.resolveUtf8(s)));
    }

    public int resolveInt(int i) {
        return this.resolve(new CPIntEntry(i));
    }

    public int resolveFloat(float f) {
        return this.resolve(new CPFloatEntry(f));
    }

    public int resolveLong(long l) {
        return this.resolve(new CPLongEntry(l));
    }

    public int resolveDouble(double d) {
        return this.resolve(new CPDoubleEntry(d));
    }

    public int resolveUtf8(String s) {
        return this.resolve(new CPUtf8Entry(s));
    }

    public int resolveNameAndType(String name, String desc) {
        return this.resolve(new CPNameAndTypeEntry(this.resolveUtf8(name), this.resolveUtf8(desc)));
    }

    private int resolve(CPEntry e) {
        int i;
        for (i = 1; i < this.constants.size(); ++i) {
            CPEntry e2 = (CPEntry)this.constants.get(i);
            if (e2 == null || !e.equals(e2)) continue;
            return i;
        }
        i = this.constants.size();
        this.constants.add(e);
        for (int k = 1; k < e.needSlots(); ++k) {
            this.constants.add(null);
        }
        return i;
    }

    public int constantPoolSize() {
        return this.constants.size();
    }

    public void writeConstantPool(DataOutput d) throws IOException {
        Iterator i = this.constants.iterator();
        while (i.hasNext()) {
            CPEntry e = (CPEntry)i.next();
            if (e == null) continue;
            e.write(d);
        }
    }

    private static class CPNameAndTypeEntry
    implements CPEntry {
        int name;
        int desc;

        CPNameAndTypeEntry(int name, int desc) {
            this.name = name;
            this.desc = desc;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPNameAndTypeEntry)) {
                return false;
            }
            CPNameAndTypeEntry cpnte = (CPNameAndTypeEntry)o;
            return cpnte.desc == this.desc && cpnte.name == this.name;
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(12);
            d.writeShort(this.name);
            d.writeShort(this.desc);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPNameAndTypeEntry name=" + this.name + " desc=" + this.desc;
        }
    }

    private static class CPUtf8Entry
    implements CPEntry {
        String val;

        CPUtf8Entry(String val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPUtf8Entry)) {
                return false;
            }
            return ((CPUtf8Entry)o).val.equals(this.val);
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(1);
            d.writeUTF(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPUtf8Entry val=" + this.val;
        }
    }

    private static class CPDoubleEntry
    implements CPEntry {
        double val;

        CPDoubleEntry(double val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPDoubleEntry)) {
                return false;
            }
            return ((CPDoubleEntry)o).val == this.val || Double.isNaN(((CPDoubleEntry)o).val) && Double.isNaN(this.val);
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(6);
            d.writeDouble(this.val);
        }

        public int needSlots() {
            return 2;
        }

        public String toString() {
            return "CPDoubleEntry val=" + this.val;
        }
    }

    private static class CPFloatEntry
    implements CPEntry {
        float val;

        CPFloatEntry(float val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPFloatEntry)) {
                return false;
            }
            return ((CPFloatEntry)o).val == this.val || Float.isNaN(((CPFloatEntry)o).val) && Float.isNaN(this.val);
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(4);
            d.writeFloat(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPFloatEntry val=" + this.val;
        }
    }

    private static class CPLongEntry
    implements CPEntry {
        long val;

        CPLongEntry(long val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPLongEntry)) {
                return false;
            }
            return ((CPLongEntry)o).val == this.val;
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(5);
            d.writeLong(this.val);
        }

        public int needSlots() {
            return 2;
        }

        public String toString() {
            return "CPLongEntry val=" + this.val;
        }
    }

    private static class CPIntEntry
    implements CPEntry {
        int val;

        CPIntEntry(int val) {
            this.val = val;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPIntEntry)) {
                return false;
            }
            return ((CPIntEntry)o).val == this.val;
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(3);
            d.writeInt(this.val);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPIntEntry val=" + this.val;
        }
    }

    private static class CPRefEntry
    implements CPEntry {
        byte tag;
        int clazz;
        int name;

        CPRefEntry(byte tag, int clazz, int name) {
            this.tag = tag;
            this.clazz = clazz;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPRefEntry)) {
                return false;
            }
            CPRefEntry cte = (CPRefEntry)o;
            return cte.clazz == this.clazz && cte.name == this.name && cte.tag == this.tag;
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(this.tag);
            d.writeShort(this.clazz);
            d.writeShort(this.name);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPRefEntry tag=" + this.tag + " class=" + this.clazz + " name=" + this.name;
        }
    }

    private static class CPTypedStringEntry
    implements CPEntry {
        byte tag;
        int name;

        CPTypedStringEntry(byte tag, int name) {
            this.tag = tag;
            this.name = name;
        }

        public boolean equals(Object o) {
            if (!(o instanceof CPTypedStringEntry)) {
                return false;
            }
            CPTypedStringEntry cte = (CPTypedStringEntry)o;
            return cte.name == this.name && cte.tag == this.tag;
        }

        public void write(DataOutput d) throws IOException {
            d.writeByte(this.tag);
            d.writeShort(this.name);
        }

        public int needSlots() {
            return 1;
        }

        public String toString() {
            return "CPTypedStringEntry tag=" + this.tag + " name=" + this.name;
        }
    }

    private static interface CPEntry {
        public void write(DataOutput var1) throws IOException;

        public int needSlots();
    }
}

