/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.task;

import csplugins.dataviewer.mapper.MapPsiInteractionsToGraph;
import csplugins.dataviewer.model.OrganismOption;
import csplugins.dataviewer.model.SearchBundle;
import csplugins.dataviewer.model.SearchBundleList;
import csplugins.dataviewer.model.SearchRequest;
import csplugins.dataviewer.model.SearchResponse;
import csplugins.dataviewer.task.CPathTimeEstimator;
import csplugins.dataviewer.ui.Console;
import csplugins.task.BaseTask;
import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.view.CyNetworkView;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.SwingUtilities;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.core.EmptySetException;
import org.mskcc.dataservices.live.interaction.ReadPsiFromCPath;
import org.mskcc.dataservices.mapper.MapperException;
import org.mskcc.dataservices.util.PropertyManager;

public class QueryCPathTask
extends BaseTask {
    private HashMap cyMap;
    private SearchRequest searchRequest;
    private SearchResponse searchResponse;
    private SearchBundle searchBundle;
    private SearchBundleList searchList;
    private Console console;
    private static final int DEFAULT_INCREMENT = 10;
    private static final int LARGER_INCREMENT = 50;

    public QueryCPathTask(HashMap hashMap, SearchRequest searchRequest, SearchBundleList searchBundleList, Console console) {
        super("Retrieving Data from cPath:  " + searchRequest.toString() + "...");
        this.logToConsoleBold("Retrieving Data from cPath:  " + searchRequest.toString() + "...");
        PropertyManager propertyManager = PropertyManager.getInstance();
        String string = propertyManager.getProperty(PropertyManager.CPATH_READ_LOCATION);
        this.logToConsole("Connecting to cPath:  " + string);
        this.cyMap = hashMap;
        this.searchRequest = searchRequest;
        this.searchList = searchBundleList;
        this.console = console;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void executeTask() {
        this.setIndeterminate(true);
        this.setProgressMessage("Connecting to cPath...");
        PropertyManager propertyManager = PropertyManager.getInstance();
        String string = propertyManager.getProperty(PropertyManager.CPATH_READ_LOCATION);
        ReadPsiFromCPath readPsiFromCPath = new ReadPsiFromCPath(string);
        this.searchResponse = new SearchResponse();
        try {
            try {
                Object var4_4 = null;
                OrganismOption organismOption = this.searchRequest.getOrganism();
                int n = organismOption.getTaxonomyId();
                if (organismOption == OrganismOption.ALL_ORGANISMS) {
                    n = -1;
                }
                int n2 = this.searchRequest.getMaxHitsOption().getMaxHits();
                this.getAllInteractions(readPsiFromCPath, n, n2);
            }
            catch (EmptySetException emptySetException) {
                this.console.logMessage("No Matching Results Found.  Please Try Again.");
                this.searchResponse.setException(emptySetException);
                Object var9_15 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            catch (DataServiceException dataServiceException) {
                this.searchResponse.setException(dataServiceException);
                Object var9_16 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            catch (MapperException mapperException) {
                this.searchResponse.setException(mapperException);
                Object var9_17 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            catch (RuntimeException runtimeException) {
                this.searchResponse.setException(runtimeException);
                Object var9_18 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            catch (Exception exception) {
                this.searchResponse.setException(exception);
                Object var9_19 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            catch (Throwable throwable) {
                this.searchResponse.setException(throwable);
                Object var9_20 = null;
                this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
                this.searchList.add(this.searchBundle);
                if (!this.isInterrupted()) return;
                this.logToConsole("Data Retrieval Cancelled by User.");
                return;
            }
            Object var9_14 = null;
            this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
            this.searchList.add(this.searchBundle);
        }
        catch (Throwable throwable) {
            Object var9_21 = null;
            this.searchBundle = new SearchBundle((SearchRequest)this.searchRequest.clone(), this.searchResponse);
            this.searchList.add(this.searchBundle);
            if (!this.isInterrupted()) throw throwable;
            this.logToConsole("Data Retrieval Cancelled by User.");
            throw throwable;
        }
        if (!this.isInterrupted()) return;
        this.logToConsole("Data Retrieval Cancelled by User.");
    }

    private void getAllInteractions(ReadPsiFromCPath readPsiFromCPath, int n, int n2) throws DataServiceException, MapperException, InterruptedException {
        this.searchResponse = new SearchResponse();
        int n3 = readPsiFromCPath.getInteractionsCount(this.searchRequest.getQuery(), n);
        this.logToConsole("Total Number of Matching Interactions:  " + n3);
        ArrayList arrayList = new ArrayList();
        int n4 = 0;
        int n5 = Math.min(n2, n3);
        int n6 = 10;
        if (n2 > 100) {
            n6 = 50;
        }
        while (n4 < n5 && !this.isInterrupted()) {
            this.getInteractions(readPsiFromCPath, n, arrayList, n4, n6, n5);
            n4 += n6;
        }
        this.searchResponse.setInteractions(arrayList);
        if (this.isInterrupted()) {
            throw new InterruptedException();
        }
        this.mapToGraph();
    }

    private void getInteractions(ReadPsiFromCPath readPsiFromCPath, int n, ArrayList arrayList, int n2, int n3, int n4) throws DataServiceException {
        int n5 = Math.min(n2 + n3, n4);
        this.setProgressMessage("Getting Interactions:  " + n2 + " - " + n5 + " of " + n4);
        Date date = new Date();
        ArrayList arrayList2 = readPsiFromCPath.getInteractionsByKeyword(this.searchRequest.getQuery(), n, n2, n3);
        arrayList.addAll(arrayList2);
        Date date2 = new Date();
        long l = date2.getTime() - date.getTime();
        long l2 = CPathTimeEstimator.calculateEsimatedTimeRemaining(l, n2, n3, n4);
        this.logToConsole("Getting Interactions:  " + n2 + " - " + n5 + " of " + n4 + " [OK]");
        this.setMaxProgressValue(n4);
        this.setProgressValue(n2 + n3);
        this.setEstimatedTimeRemaining(l2);
    }

    private void mapToGraph() throws MapperException {
        this.setIndeterminate(true);
        String string = this.searchRequest.toString();
        ArrayList arrayList = this.searchResponse.getInteractions();
        if (string.length() > 25) {
            string = new String(string + "...");
        }
        CyNetwork cyNetwork = Cytoscape.createNetwork((String)string);
        cyNetwork.setTitle(string);
        this.searchResponse.setCyNetwork(cyNetwork);
        CyNetworkView cyNetworkView = Cytoscape.createNetworkView((CyNetwork)cyNetwork);
        Cytoscape.destroyNetworkView((CyNetworkView)cyNetworkView);
        this.logToConsole("Mapping Data to Cytoscape Network");
        this.setProgressMessage("Mapping Data to Cytoscape Network.  Please wait.");
        MapPsiInteractionsToGraph mapPsiInteractionsToGraph = new MapPsiInteractionsToGraph(arrayList, cyNetwork, 2);
        mapPsiInteractionsToGraph.setBaseTask(this);
        mapPsiInteractionsToGraph.doMapping();
        ArrayList arrayList2 = mapPsiInteractionsToGraph.getWarnings();
        if (arrayList2.size() > 0) {
            this.logToConsole("------------------------------------------");
        }
        for (int i = 0; i < arrayList2.size(); ++i) {
            int n = i + 1;
            this.logToConsole("Warning # " + n + ":  " + (String)arrayList2.get(i));
            this.logToConsole("------------------------------------------");
        }
        HashMap hashMap = mapPsiInteractionsToGraph.getCyMap();
        this.cyMap.putAll(hashMap);
        this.logToConsole("Total Number of Nodes in Network:  " + cyNetwork.getNodeCount());
        this.logToConsole("Total Number of Edges in Network:  " + cyNetwork.getEdgeCount());
        if (cyNetwork.getNodeCount() < Cytoscape.getCytoscapeObj().getViewThreshold()) {
            this.logToConsole("Your Network is Under " + Cytoscape.getCytoscapeObj().getViewThreshold() + " nodes --> a Cytoscape View  will be " + "automatically created.");
            this.setProgressMessage("Creating Network View.  Please wait.");
            CyNetworkView cyNetworkView2 = Cytoscape.createNetworkView((CyNetwork)cyNetwork);
            this.searchResponse.setCyNetworkView(cyNetworkView2);
            this.setProgressMessage("Applying Visual Styles.");
            Cytoscape.getDesktop().getVizMapManager().applyAppearances();
        } else {
            this.logToConsole("Your Network is Over " + Cytoscape.getCytoscapeObj().getViewThreshold() + " nodes --> a Cytoscape View  will not be " + "automatically created.");
        }
    }

    private void logToConsole(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                QueryCPathTask.this.console.logMessage(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void logToConsoleBold(final String string) {
        Runnable runnable = new Runnable(){

            public void run() {
                QueryCPathTask.this.console.logMessageBold(string);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }
}

