/*
 * Decompiled with CFR 0.152.
 */
package csplugins.dataviewer.mapper;

import csplugins.dataviewer.util.AttributeUtil;
import csplugins.task.BaseTask;
import cytoscape.CyEdge;
import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.bio.vocab.CommonVocab;
import org.mskcc.dataservices.mapper.Mapper;
import org.mskcc.dataservices.mapper.MapperException;
import org.mskcc.dataservices.schemas.psi.types.RoleType;

public class MapInteractionsToGraph
implements Mapper {
    public static final int SPOKE_VIEW = 1;
    public static final int MATRIX_VIEW = 2;
    public static final String ROOT_GRAPH_INDEXES = "ROOT_GRAPH_INDEXES";
    public static final String DS_INTERACTOR = "DS_INTERACTOR";
    public static final String DS_INTERACTION = "DS_INTERACTION";
    protected CyNetwork cyNetwork;
    private HashMap cyMap;
    private ArrayList interactions;
    private int graphType;
    private ArrayList warnings = new ArrayList();
    private static final int MATRIX_CUT_OFF = 5;
    protected static final String OPEN_PAREN = " (";
    protected static final String CLOSE_PAREN = ") ";
    private BaseTask task;

    public MapInteractionsToGraph(ArrayList arrayList, CyNetwork cyNetwork, int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Illegal GraphType Parameter.");
        }
        this.cyMap = new HashMap();
        this.interactions = arrayList;
        this.cyNetwork = cyNetwork;
        this.graphType = n;
    }

    public void setBaseTask(BaseTask baseTask) {
        this.task = baseTask;
    }

    public HashMap getCyMap() {
        return this.cyMap;
    }

    public final void doMapping() throws MapperException {
        HashMap hashMap = this.createNodeMap();
        HashMap hashMap2 = this.createEdgeMap();
        this.validateInteractions();
        this.addNewNodes(hashMap);
        this.addNewEdges(hashMap, hashMap2);
    }

    public ArrayList getWarnings() {
        return this.warnings;
    }

    private void validateInteractions() throws MapperException {
        String string = "In order to correctly graph your interactions, each interaction must specify exactly one bait value.";
        if (this.task != null) {
            this.task.setProgressMessage("Validating Interactions");
            this.task.setMaxProgressValue(this.interactions.size());
        }
        if (this.graphType == 1) {
            for (int i = 0; i < this.interactions.size(); ++i) {
                Interaction interaction = (Interaction)this.interactions.get(i);
                ArrayList arrayList = interaction.getInteractors();
                if (arrayList.size() > 2) {
                    HashMap hashMap = (HashMap)interaction.getAttribute("BAIT_MAP");
                    if (hashMap == null) {
                        throw new MapperException(string);
                    }
                    Interactor interactor = this.determineBait(arrayList, hashMap);
                    if (interactor == null) {
                        throw new MapperException(string);
                    }
                }
                if (this.task == null) continue;
                this.task.setProgressValue(i);
            }
        }
    }

    private void addNewNodes(HashMap hashMap) {
        if (this.task != null) {
            this.task.setProgressMessage("Adding Nodes to Network");
            this.task.setMaxProgressValue(this.interactions.size());
        }
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = (Interaction)this.interactions.get(i);
            ArrayList arrayList = interaction.getInteractors();
            for (int j = 0; j < arrayList.size(); ++j) {
                Interactor interactor = (Interactor)arrayList.get(j);
                this.addNode(interactor, hashMap);
            }
            if (this.task == null) continue;
            this.task.setProgressValue(i);
        }
    }

    private void addNewEdges(HashMap hashMap, HashMap hashMap2) {
        if (this.task != null) {
            this.task.setProgressMessage("Adding Edges to Network");
            this.task.setMaxProgressValue(this.interactions.size());
        }
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = (Interaction)this.interactions.get(i);
            ArrayList arrayList = interaction.getInteractors();
            if (this.graphType == 2) {
                this.doMatrixView(arrayList, hashMap, interaction, hashMap2);
            } else {
                this.doSpokeView(arrayList, hashMap, interaction, hashMap2);
            }
            if (this.task == null) continue;
            this.task.setProgressValue(i);
        }
    }

    private void doMatrixView(ArrayList arrayList, HashMap hashMap, Interaction interaction, HashMap hashMap2) {
        if (arrayList.size() <= 5) {
            for (int i = 0; i < arrayList.size(); ++i) {
                for (int j = i + 1; j < arrayList.size(); ++j) {
                    Interactor interactor = (Interactor)arrayList.get(i);
                    Interactor interactor2 = (Interactor)arrayList.get(j);
                    this.createEdge(interactor, interactor2, interaction, hashMap, hashMap2);
                }
            }
        } else {
            ExternalReference[] externalReferenceArray = interaction.getExternalRefs();
            StringBuffer stringBuffer = new StringBuffer();
            if (externalReferenceArray != null && externalReferenceArray.length > 0) {
                for (int i = 0; i < externalReferenceArray.length; ++i) {
                    String string = externalReferenceArray[i].getDatabase();
                    String string2 = externalReferenceArray[i].getId();
                    stringBuffer.append("[" + string + ":" + string2 + "] ");
                }
            } else {
                stringBuffer.append("[No Ids available]");
            }
            String string = new String("Interaction contains more than 5 interactors.  The interaction will not be mapped to  any Cytoscape edges.  The offending interaction is identified with the following identifiers:  " + stringBuffer);
            this.warnings.add(string);
        }
    }

    private void doSpokeView(ArrayList arrayList, HashMap hashMap, Interaction interaction, HashMap hashMap2) {
        HashMap hashMap3 = (HashMap)interaction.getAttribute("BAIT_MAP");
        if (arrayList.size() > 2) {
            Interactor interactor = this.determineBait(arrayList, hashMap3);
            String string = interactor.getName();
            for (int i = 0; i < arrayList.size(); ++i) {
                Interactor interactor2 = (Interactor)arrayList.get(i);
                RoleType roleType = (RoleType)hashMap3.get(interactor2.getName());
                if (roleType != null && roleType == RoleType.BAIT) continue;
                this.createEdge(interactor, interactor2, interaction, hashMap, hashMap2);
            }
        } else {
            Interactor interactor = (Interactor)arrayList.get(0);
            Interactor interactor3 = (Interactor)arrayList.get(1);
            this.createEdge(interactor, interactor3, interaction, hashMap, hashMap2);
        }
    }

    private Interactor determineBait(ArrayList arrayList, HashMap hashMap) {
        Interactor interactor = null;
        for (int i = 0; i < arrayList.size(); ++i) {
            Interactor interactor2 = (Interactor)arrayList.get(i);
            String string = interactor2.getName();
            RoleType roleType = (RoleType)hashMap.get(string);
            if (roleType == null || roleType != RoleType.BAIT) continue;
            interactor = interactor2;
        }
        return interactor;
    }

    private void createEdge(Interactor interactor, Interactor interactor2, Interaction interaction, HashMap hashMap, HashMap hashMap2) {
        CyNode cyNode = (CyNode)hashMap.get(interactor.getName());
        CyNode cyNode2 = (CyNode)hashMap.get(interactor2.getName());
        CyEdge cyEdge = Cytoscape.getCyEdge((Node)cyNode, (Node)cyNode2, (String)"interaction", (Object)"pp", (boolean)true);
        this.cyNetwork.addEdge((Edge)cyEdge);
        String string = this.createEdgeKey((Node)cyNode, (Node)cyNode2, interaction);
        cyEdge.setIdentifier(string);
        this.cyNetwork.getEdgeAttributes().addNameMapping(string, (Object)cyEdge);
        this.mapEdgeAttributes(interaction, cyEdge);
        int n = cyEdge.getRootGraphIndex();
        ArrayList<Integer> arrayList = (ArrayList<Integer>)interaction.getAttribute(ROOT_GRAPH_INDEXES);
        if (arrayList == null) {
            arrayList = new ArrayList<Integer>();
            interaction.addAttribute(ROOT_GRAPH_INDEXES, arrayList);
        }
        arrayList.add(new Integer(n));
        this.cyMap.put(string, interaction);
        hashMap2.put(string, cyEdge);
    }

    private boolean edgeExists(CyNode cyNode, CyNode cyNode2, Interaction interaction, HashMap hashMap) {
        String string = this.createEdgeKey((Node)cyNode, (Node)cyNode2, interaction);
        String string2 = this.createEdgeKey((Node)cyNode2, (Node)cyNode, interaction);
        boolean bl = hashMap.containsKey(string);
        boolean bl2 = hashMap.containsKey(string2);
        boolean bl3 = bl | bl2;
        return bl3;
    }

    private void addNode(Interactor interactor, HashMap hashMap) {
        String string = interactor.getName();
        boolean bl = hashMap.containsKey(string);
        if (!bl) {
            CyNode cyNode = Cytoscape.getCyNode((String)string, (boolean)true);
            this.cyNetwork.addNode((Node)cyNode);
            cyNode.setIdentifier(string);
            this.cyNetwork.setNodeAttributeValue((Node)cyNode, "canonicalName", (Object)string);
            this.cyNetwork.setNodeAttributeValue((Node)cyNode, "commonName", (Object)string);
            this.cyMap.put(string, interactor);
            this.mapNodeAttributes(interactor, cyNode);
            hashMap.put(string, cyNode);
        }
    }

    protected void mapNodeAttributes(Interactor interactor, CyNode cyNode) {
        String[] stringArray;
        Object object;
        HashMap hashMap = interactor.getAllAttributes();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object = (String)iterator.next();
            stringArray = (String[])hashMap.get(object);
            this.cyNetwork.setNodeAttributeValue((Node)cyNode, (String)object, (Object)stringArray);
        }
        object = interactor.getExternalRefs();
        if (object != null) {
            stringArray = new String[((ExternalReference[])object).length];
            String[] stringArray2 = new String[((ExternalReference[])object).length];
            for (int i = 0; i < ((ExternalReference[])object).length; ++i) {
                ExternalReference externalReference = object[i];
                stringArray[i] = externalReference.getDatabase();
                stringArray2[i] = externalReference.getId();
            }
            this.cyNetwork.setNodeAttributeValue((Node)cyNode, CommonVocab.XREF_DB_NAME, (Object)stringArray);
            this.cyNetwork.setNodeAttributeValue((Node)cyNode, CommonVocab.XREF_DB_ID, (Object)stringArray2);
        }
    }

    protected void mapEdgeAttributes(Interaction interaction, CyEdge cyEdge) {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        HashMap hashMap = interaction.getAllAttributes();
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            object2 = hashMap.get(object3);
            if (!(object2 instanceof String)) continue;
            object = (String)object2;
            Object object4 = this.cyNetwork.getEdgeAttributeValue((Edge)cyEdge, (String)object3);
            if (object4 != null) {
                stringArray = AttributeUtil.appendString(object4, (String)object);
                this.cyNetwork.setEdgeAttributeValue((Edge)cyEdge, (String)object3, (Object)stringArray);
                continue;
            }
            this.cyNetwork.setEdgeAttributeValue((Edge)cyEdge, (String)object3, object);
        }
        object3 = interaction.getExternalRefs();
        if (object3 != null) {
            object2 = new String[((ExternalReference[])object3).length];
            object = new String[((ExternalReference[])object3).length];
            for (int i = 0; i < ((ExternalReference[])object3).length; ++i) {
                stringArray = object3[i];
                object2[i] = stringArray.getDatabase();
                object[i] = stringArray.getId();
            }
            this.cyNetwork.setEdgeAttributeValue((Edge)cyEdge, CommonVocab.XREF_DB_NAME, object2);
            this.cyNetwork.setEdgeAttributeValue((Edge)cyEdge, CommonVocab.XREF_DB_ID, object);
        }
    }

    protected String getInteractionTypeId(Interaction interaction) {
        String string = (String)interaction.getAttribute("interaction");
        if (string == null) {
            return " <--> ";
        }
        return new String(OPEN_PAREN + string + CLOSE_PAREN);
    }

    private String createEdgeKey(Node node, Node node2, Interaction interaction) {
        return new String(node.getIdentifier() + this.getInteractionTypeId(interaction) + node2.getIdentifier());
    }

    private HashMap createNodeMap() {
        HashMap<String, CyNode> hashMap = new HashMap<String, CyNode>();
        Iterator iterator = this.cyNetwork.nodesIterator();
        while (iterator.hasNext()) {
            CyNode cyNode = (CyNode)iterator.next();
            String string = cyNode.getIdentifier();
            hashMap.put(string, cyNode);
        }
        return hashMap;
    }

    private HashMap createEdgeMap() {
        HashMap<String, CyEdge> hashMap = new HashMap<String, CyEdge>();
        Iterator iterator = this.cyNetwork.edgesIterator();
        while (iterator.hasNext()) {
            CyEdge cyEdge = (CyEdge)iterator.next();
            String string = cyEdge.getIdentifier();
            hashMap.put(string, cyEdge);
        }
        return hashMap;
    }
}

