/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.persist;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import org.exolab.castor.jdo.DuplicateIdentityException;
import org.exolab.castor.jdo.ObjectDeletedException;
import org.exolab.castor.jdo.ObjectModifiedException;
import org.exolab.castor.jdo.ObjectNotFoundException;
import org.exolab.castor.jdo.PersistenceException;
import org.exolab.castor.jdo.TimeStampable;
import org.exolab.castor.jdo.engine.JDOCallback;
import org.exolab.castor.jdo.engine.JDOClassDescriptor;
import org.exolab.castor.jdo.engine.JDOFieldDescriptor;
import org.exolab.castor.mapping.AccessMode;
import org.exolab.castor.mapping.ClassDescriptor;
import org.exolab.castor.mapping.FieldDescriptor;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.TypeConvertor;
import org.exolab.castor.mapping.loader.ClassDescriptorImpl;
import org.exolab.castor.mapping.loader.FieldHandlerImpl;
import org.exolab.castor.mapping.loader.MappingLoader;
import org.exolab.castor.mapping.xml.ClassMapping;
import org.exolab.castor.mapping.xml.FieldMapping;
import org.exolab.castor.persist.CollectionProxy;
import org.exolab.castor.persist.DatingService;
import org.exolab.castor.persist.DepositBox;
import org.exolab.castor.persist.FieldMolder;
import org.exolab.castor.persist.LRU;
import org.exolab.castor.persist.Lazy;
import org.exolab.castor.persist.LockEngine;
import org.exolab.castor.persist.OID;
import org.exolab.castor.persist.QueryResults;
import org.exolab.castor.persist.RelationCollection;
import org.exolab.castor.persist.TransactionContext;
import org.exolab.castor.persist.spi.CallbackInterceptor;
import org.exolab.castor.persist.spi.Complex;
import org.exolab.castor.persist.spi.LogInterceptor;
import org.exolab.castor.persist.spi.Persistence;
import org.exolab.castor.persist.spi.PersistenceFactory;
import org.exolab.castor.util.Messages;

public class ClassMolder {
    private String _name;
    private FieldMolder[] _ids;
    private FieldMolder[] _fhs;
    private ClassMolder _extends;
    private ClassMolder _depends;
    private Vector _dependent;
    private Vector _extendent;
    private AccessMode _accessMode;
    private Persistence _persistence;
    private LockEngine _engine;
    private CallbackInterceptor _callback;
    private int _cachetype;
    private int _cacheparam;
    private boolean _isKeyGenUsed;
    private boolean _debug = Boolean.getBoolean("org.exolab.castor.debug");
    private boolean _timeStampable;
    private int _priority = -1;
    static /* synthetic */ Class class$org$exolab$castor$jdo$TimeStampable;
    static /* synthetic */ Class class$org$exolab$castor$jdo$Persistent;

    ClassMolder(DatingService ds, MappingLoader loader, LockEngine lock, ClassDescriptor clsDesc, Persistence persist) throws ClassNotFoundException, MappingException {
        ClassMapping clsMap = ((ClassDescriptorImpl)clsDesc).getMapping();
        this._engine = lock;
        this._persistence = persist;
        this._name = clsMap.getName();
        this._accessMode = AccessMode.getAccessMode(clsMap.getAccess().toString());
        this._timeStampable = (class$org$exolab$castor$jdo$TimeStampable == null ? (class$org$exolab$castor$jdo$TimeStampable = ClassMolder.class$("org.exolab.castor.jdo.TimeStampable")) : class$org$exolab$castor$jdo$TimeStampable).isAssignableFrom(clsDesc.getJavaClass());
        ds.register(this._name, this);
        ClassMapping dep = (ClassMapping)clsMap.getDepends();
        ClassMapping ext = (ClassMapping)clsMap.getExtends();
        if (dep != null) {
            ds.pairDepends(this, dep.getName());
        }
        if (ext != null) {
            ds.pairExtends(this, ext.getName());
        }
        if (clsDesc instanceof JDOClassDescriptor) {
            if (((JDOClassDescriptor)clsDesc).getCacheType() != null) {
                this._cachetype = LRU.mapType(((JDOClassDescriptor)clsDesc).getCacheType());
                this._cacheparam = ((JDOClassDescriptor)clsDesc).getCacheParam();
            }
            this._isKeyGenUsed = ((JDOClassDescriptor)clsDesc).getKeyGeneratorDescriptor() != null;
        }
        FieldMapping[] fmId = this.getIdFields(clsMap);
        this._ids = new FieldMolder[fmId.length];
        int i = 0;
        while (i < this._ids.length) {
            this._ids[i] = new FieldMolder(ds, this, fmId[i]);
            ++i;
        }
        FieldMapping[] fmFields = this.getFullFields(clsMap);
        this._fhs = new FieldMolder[fmFields.length];
        int i2 = 0;
        while (i2 < this._fhs.length) {
            if (fmFields[i2].getSql() != null && fmFields[i2].getSql().getManyTable() != null) {
                String[] manyName;
                String[] manyKey;
                String manyTable = null;
                String[] idSQL = null;
                int[] idType = null;
                String[] relatedIdSQL = null;
                int[] relatedIdType = null;
                TypeConvertor[] idConvertTo = null;
                TypeConvertor[] idConvertFrom = null;
                String[] idConvertParam = null;
                TypeConvertor[] relatedIdConvertTo = null;
                TypeConvertor[] relatedIdConvertFrom = null;
                String[] relatedIdConvertParam = null;
                manyTable = fmFields[i2].getSql().getManyTable();
                idSQL = new String[fmId.length];
                idType = new int[fmId.length];
                idConvertFrom = new TypeConvertor[fmId.length];
                idConvertTo = new TypeConvertor[fmId.length];
                idConvertParam = new String[fmId.length];
                FieldDescriptor[] fd = ((ClassDescriptorImpl)clsDesc).getIdentities();
                int j = 0;
                while (j < fmId.length) {
                    idSQL[j] = fmId[j].getSql().getName()[0];
                    if (!(fd[j] instanceof JDOFieldDescriptor)) {
                        throw new MappingException("Identity type must contains sql information: " + this._name);
                    }
                    int[] type = ((JDOFieldDescriptor)fd[j]).getSQLType();
                    idType[j] = type == null ? 0 : type[0];
                    FieldHandlerImpl fh = (FieldHandlerImpl)fd[j].getHandler();
                    idConvertTo[j] = fh.getConvertTo();
                    idConvertFrom[j] = fh.getConvertFrom();
                    idConvertParam[j] = fh.getConvertParam();
                    ++j;
                }
                relatedIdSQL = null;
                String relatedType = fmFields[i2].getType();
                ClassDescriptor relDesc = loader.getDescriptor(ds.resolve(relatedType));
                if (relDesc instanceof JDOClassDescriptor) {
                    FieldDescriptor[] relatedIds = ((JDOClassDescriptor)relDesc).getIdentities();
                    relatedIdSQL = new String[relatedIds.length];
                    relatedIdType = new int[relatedIds.length];
                    relatedIdConvertTo = new TypeConvertor[relatedIds.length];
                    relatedIdConvertFrom = new TypeConvertor[relatedIds.length];
                    relatedIdConvertParam = new String[relatedIds.length];
                    int j2 = 0;
                    while (j2 < relatedIdSQL.length) {
                        if (!(relatedIds[j2] instanceof JDOFieldDescriptor)) {
                            throw new MappingException("Field type is not persistence-capable: " + relatedIds[j2].getFieldName());
                        }
                        String[] tempId = ((JDOFieldDescriptor)relatedIds[j2]).getSQLName();
                        relatedIdSQL[j2] = tempId == null ? null : tempId[0];
                        int[] tempType = ((JDOFieldDescriptor)relatedIds[j2]).getSQLType();
                        relatedIdType[j2] = tempType == null ? 0 : tempType[0];
                        FieldHandlerImpl fh = (FieldHandlerImpl)relatedIds[j2].getHandler();
                        relatedIdConvertTo[j2] = fh.getConvertTo();
                        relatedIdConvertFrom[j2] = fh.getConvertFrom();
                        relatedIdConvertParam[j2] = fh.getConvertParam();
                        ++j2;
                    }
                }
                if ((manyKey = fmFields[i2].getSql().getManyKey()) != null && manyKey.length != 0) {
                    if (manyKey.length != idSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + clsDesc.getJavaClass().getName());
                    }
                    idSQL = manyKey;
                }
                if ((manyName = fmFields[i2].getSql().getName()) != null && manyName.length != 0) {
                    if (manyName.length != relatedIdSQL.length) {
                        throw new MappingException("The number of many-keys doesn't match referred object: " + relDesc.getJavaClass().getName());
                    }
                    relatedIdSQL = manyName;
                }
                this._fhs[i2] = new FieldMolder(ds, this, fmFields[i2], manyTable, idSQL, idType, idConvertTo, idConvertFrom, idConvertParam, relatedIdSQL, relatedIdType, relatedIdConvertTo, relatedIdConvertFrom, relatedIdConvertParam);
            } else {
                this._fhs[i2] = new FieldMolder(ds, this, fmFields[i2]);
            }
            ++i2;
        }
        if ((class$org$exolab$castor$jdo$Persistent == null ? (class$org$exolab$castor$jdo$Persistent = ClassMolder.class$("org.exolab.castor.jdo.Persistent")) : class$org$exolab$castor$jdo$Persistent).isAssignableFrom(ds.resolve(this._name))) {
            this._callback = new JDOCallback();
        }
    }

    private FieldMapping[] getIdFields(ClassMapping clsMap) throws MappingException {
        ClassMapping base = clsMap;
        while (base.getExtends() != null) {
            base = (ClassMapping)base.getExtends();
        }
        Object fmDepended = null;
        String[] identities = base.getIdentity();
        if (identities == null || identities.length == 0) {
            throw new MappingException("Identity is null!");
        }
        FieldMapping[] fmIds = new FieldMapping[identities.length];
        FieldMapping[] fmBase = base.getFieldMapping();
        int i = 0;
        boolean j = false;
        while (i < fmBase.length) {
            int k = 0;
            while (k < identities.length) {
                if (fmBase[i].getName().equals(identities[k])) {
                    fmIds[k] = fmBase[i];
                    break;
                }
                ++k;
            }
            ++i;
        }
        if (fmDepended == null) {
            return fmIds;
        }
        FieldMapping[] fmResult = new FieldMapping[(fmDepended).length + identities.length];
        System.arraycopy(fmIds, 0, fmResult, 0, fmIds.length);
        System.arraycopy(fmDepended, 0, fmResult, fmIds.length, (fmDepended).length);
        return fmIds;
    }

    private FieldMapping[] getFullFields(ClassMapping clsMap) throws MappingException {
        FieldMapping[] fields = null;
        ClassMapping extend = (ClassMapping)clsMap.getExtends();
        if (extend != null) {
            ClassMapping origin = extend;
            while (origin.getExtends() != null) {
                origin = (ClassMapping)origin.getExtends();
            }
            String[] identities = origin.getIdentity();
            FieldMapping[] extendFields = this.getFullFields(extend);
            FieldMapping[] thisFields = clsMap.getFieldMapping();
            ArrayList<FieldMapping> fieldList = new ArrayList<FieldMapping>(extendFields.length + thisFields.length);
            int i = 0;
            while (i < extendFields.length) {
                fieldList.add(extendFields[i]);
                ++i;
            }
            int i2 = 0;
            while (i2 < thisFields.length) {
                int k = 0;
                while (k < identities.length) {
                    if (!thisFields[i2].getName().equals(identities[k])) {
                        fieldList.add(thisFields[i2]);
                        break;
                    }
                    ++k;
                }
                ++i2;
            }
            fields = new FieldMapping[fieldList.size()];
            fieldList.toArray(fields);
        } else {
            String[] identities = clsMap.getIdentity();
            if (identities == null || identities.length == 0) {
                throw new MappingException("Identity is null!");
            }
            FieldMapping[] thisFields = clsMap.getFieldMapping();
            fields = new FieldMapping[thisFields.length - identities.length];
            int i = 0;
            int j = 0;
            while (i < thisFields.length) {
                boolean idfield = false;
                int k = 0;
                while (k < identities.length) {
                    if (thisFields[i].getName().equals(identities[k])) {
                        idfield = true;
                        break;
                    }
                    ++k;
                }
                if (!idfield) {
                    fields[j] = thisFields[i];
                    ++j;
                }
                ++i;
            }
        }
        return fields;
    }

    public static Vector resolve(MappingLoader loader, LockEngine lock, PersistenceFactory factory, LogInterceptor logInterceptor) throws MappingException, ClassNotFoundException {
        Vector<ClassMolder> result = new Vector<ClassMolder>();
        DatingService ds = new DatingService(loader.getClassLoader());
        Enumeration enumeration = loader.listJavaClasses();
        while (enumeration.hasMoreElements()) {
            ClassDescriptor desc = loader.getDescriptor((Class)enumeration.nextElement());
            Persistence persist = factory.getPersistence(desc, logInterceptor);
            ClassMolder mold = new ClassMolder(ds, loader, lock, desc, persist);
            result.add(mold);
        }
        ds.close();
        return result;
    }

    private boolean removeRelation(TransactionContext tx, Object object, ClassMolder relatedMolder, Object relatedObject) {
        boolean removed = false;
        boolean updateCache = false;
        boolean updatePersist = false;
        ClassMolder relatedBaseMolder = null;
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 2: {
                    Object related;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    relatedBaseMolder = relatedMolder;
                    while (fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null) {
                        relatedBaseMolder = relatedBaseMolder._extends;
                    }
                    if (fieldClassMolder != relatedBaseMolder || (related = this._fhs[i].getValue(object, tx.getClassLoader())) != relatedObject) break;
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    updateCache = true;
                    updatePersist = true;
                    removed = true;
                    break;
                }
                case 3: 
                case 4: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    relatedBaseMolder = relatedMolder;
                    while (fieldClassMolder != relatedBaseMolder && relatedBaseMolder != null) {
                        relatedBaseMolder = relatedBaseMolder._extends;
                    }
                    if (fieldClassMolder != relatedBaseMolder) break;
                    boolean changed = false;
                    Object related = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (related instanceof RelationCollection) {
                        RelationCollection lazy = (RelationCollection)related;
                        changed = lazy.remove(relatedObject);
                    } else {
                        Iterator itor = this.getIterator(related);
                        while (itor.hasNext()) {
                            Object o = itor.next();
                            if (o != relatedObject) continue;
                            changed = true;
                            itor.remove();
                        }
                    }
                    if (!changed) break;
                    updateCache = true;
                    updatePersist = false;
                    removed = true;
                }
            }
            ++i;
        }
        tx.markModified(object, updatePersist, updateCache);
        return removed;
    }

    public int getPriority() {
        if (this._priority == -2) {
            return 0;
        }
        if (this._priority < 0) {
            this._priority = -2;
            int maxPrior = 0;
            int i = 0;
            while (i < this._fhs.length) {
                if (this._fhs[i].isPersistanceCapable() && this._fhs[i].getFieldClassMolder() != this && this._fhs[i].isStored() && this._fhs[i].getFieldClassMolder().isKeyGeneratorUsed()) {
                    maxPrior = Math.max(maxPrior, this._fhs[i].getFieldClassMolder().getPriority() + 1);
                }
                ++i;
            }
            if (this._extendent != null) {
                int i2 = 0;
                while (i2 < this._extendent.size()) {
                    maxPrior = Math.max(maxPrior, ((ClassMolder)this._extendent.get(i2)).getPriority());
                    ++i2;
                }
            }
            this._priority = maxPrior;
        }
        return this._priority;
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws ObjectNotFoundException, PersistenceException {
        return this.load(tx, oid, locker, object, suggestedAccessMode, null);
    }

    public Object load(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode, QueryResults results) throws ObjectNotFoundException, PersistenceException {
        Object stamp = null;
        AccessMode accessMode = this.getAccessMode(suggestedAccessMode);
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be loaded is null");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null || accessMode == AccessMode.DbLocked) {
            fields = new Object[this._fhs.length];
            if (results != null) {
                stamp = results.getQuery().fetch(fields, oid.getIdentity());
            } else {
                Connection conn = (Connection)tx.getConnection(oid.getLockEngine());
                stamp = this._persistence.load(conn, fields, oid.getIdentity(), accessMode);
            }
            oid.setDbLock(accessMode == AccessMode.DbLocked);
            locker.setObject(tx, fields);
        }
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
        Object ids = oid.getIdentity();
        this.setIdentity(tx, object, ids);
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    Object temp = fields[i];
                    if (temp != null) {
                        this._fhs[i].setValue(object, temp, tx.getClassLoader());
                        break;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    break;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        if (bytes != null) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                            ObjectInputStream os = new ObjectInputStream(bis);
                            Object o = os.readObject();
                            this._fhs[i].setValue(object, o, tx.getClassLoader());
                            break;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        break;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    Object temp;
                    if (this._fhs[i].isLazy()) {
                        System.err.println("Warning: Lazy loading of object is not yet support!");
                    }
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        try {
                            temp = tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                        }
                        catch (ObjectNotFoundException ex) {
                            temp = null;
                        }
                        this._fhs[i].setValue(object, temp, tx.getClassLoader());
                        break;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    break;
                }
                case 3: 
                case 4: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (!this._fhs[i].isLazy()) {
                        CollectionProxy cp = CollectionProxy.create(this._fhs[i], object, tx.getClassLoader());
                        ArrayList v = (ArrayList)fields[i];
                        if (v != null) {
                            int j = 0;
                            int l = v.size();
                            while (j < l) {
                                cp.add(v.get(j), tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode));
                                ++j;
                            }
                            cp.close();
                            break;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        break;
                    }
                    ArrayList list = (ArrayList)fields[i];
                    RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, accessMode, list);
                    this._fhs[i].setValue(object, relcol, tx.getClassLoader());
                    break;
                }
                default: {
                    throw new PersistenceException("Unexpected field type!");
                }
            }
            ++i;
        }
        return stamp;
    }

    public Object create(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        ArrayList fids;
        Object o;
        LockEngine fieldEngine;
        ClassMolder fieldClassMolder;
        short fieldType;
        if (this._persistence == null) {
            throw new PersistenceException("non persistence capable: " + oid.getName());
        }
        Object[] fields = new Object[this._fhs.length];
        Object ids = oid.getIdentity();
        int i = 0;
        while (i < this._fhs.length) {
            fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    fields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    break;
                }
                case 2: {
                    Object fid;
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    fieldEngine = this._fhs[i].getFieldLockEngine();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null || (fid = fieldClassMolder.getIdentity(tx, o)) == null) break;
                    fields[i] = fid;
                    break;
                }
                case 1: {
                    try {
                        Object dependent = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (dependent != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(dependent);
                            fields[i] = bos.toByteArray();
                            break;
                        }
                        fields[i] = null;
                        break;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error during serializing dependent object", e);
                    }
                }
                case 3: {
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    fieldEngine = this._fhs[i].getFieldLockEngine();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i] = fids;
                    break;
                }
                case 4: {
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    fieldEngine = this._fhs[i].getFieldLockEngine();
                    o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i] = fids;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
            ++i;
        }
        Object createdId = this._persistence.create(tx.getDatabase(), (Connection)tx.getConnection(oid.getLockEngine()), fields, ids);
        if (createdId == null) {
            throw new PersistenceException("Identity can't be created!");
        }
        locker.setObject(tx, fields);
        oid.setDbLock(true);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
        this.setIdentity(tx, object, createdId);
        int i2 = 0;
        while (i2 < this._fhs.length) {
            fieldType = this._fhs[i2].getFieldType();
            switch (fieldType) {
                case 4: {
                    fieldClassMolder = this._fhs[i2].getFieldClassMolder();
                    fieldEngine = this._fhs[i2].getFieldLockEngine();
                    o = this._fhs[i2].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    fids = this.extractIdentityList(tx, fieldClassMolder, o);
                    fields[i2] = fids;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        Object oo = itor.next();
                        if (!tx.isPersistent(oo)) continue;
                        this._fhs[i2].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), createdId, fieldClassMolder.getIdentity(tx, oo));
                    }
                    break;
                }
            }
            ++i2;
        }
        return createdId;
    }

    public void markCreate(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException {
        boolean updateCache = false;
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    if (this._fhs[i].isDependent()) {
                        if (!tx.isRecorded(o)) {
                            tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                            if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                            updateCache = true;
                            break;
                        }
                        if (tx.isDepended(oid, o)) break;
                        throw new PersistenceException("Dependent object may not change its master. Object: " + o + " new master: " + oid);
                    }
                    if (!tx.isAutoStore() || tx.isRecorded(o)) break;
                    tx.markCreate(fieldEngine, fieldClassMolder, o, null);
                    if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                    updateCache = true;
                    break;
                }
                case 3: {
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (this._fhs[i].isDependent()) {
                            if (!tx.isRecorded(oo)) {
                                tx.markCreate(fieldEngine, fieldClassMolder, oo, oid);
                                if (!fieldClassMolder._isKeyGenUsed) continue;
                                updateCache = true;
                                continue;
                            }
                            if (tx.isDepended(oid, oo)) continue;
                            throw new PersistenceException("Dependent object may not change its master");
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, oo, null);
                        if (!fieldClassMolder._isKeyGenUsed) continue;
                        updateCache = true;
                    }
                    break;
                }
                case 4: {
                    Object oo;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (o == null) break;
                    Iterator itor = this.getIterator(o);
                    while (itor.hasNext()) {
                        oo = itor.next();
                        if (!tx.isAutoStore() || tx.isRecorded(oo)) continue;
                        tx.markCreate(fieldEngine, fieldClassMolder, oo, null);
                        updateCache = true;
                    }
                    break;
                }
            }
            ++i;
        }
        tx.markModified(object, false, updateCache);
    }

    private boolean isEquals(Collection c1, Collection c2) {
        if (c1 == c2) {
            return true;
        }
        if (c1 == null || c2 == null) {
            return false;
        }
        return c1.containsAll(c2) && c2.containsAll(c1);
    }

    private static boolean isEquals(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1.equals(o2)) {
            return true;
        }
        if (o1 instanceof BigDecimal && ((BigDecimal)o1).compareTo(o2) == 0) {
            return true;
        }
        if (o1 instanceof Timestamp && o2 instanceof Timestamp) {
            Timestamp t1 = (Timestamp)o1;
            Timestamp t2 = (Timestamp)o2;
            return ((Date)t1).getTime() == ((Date)t2).getTime() && t1.getNanos() / 1000000 == t2.getNanos() / 1000000;
        }
        if (o1 instanceof byte[] && o2 instanceof byte[]) {
            return Arrays.equals((byte[])o1, (byte[])o2);
        }
        if (o1 instanceof char[] && o2 instanceof char[]) {
            return Arrays.equals((char[])o1, (char[])o2);
        }
        return false;
    }

    public boolean preStore(TransactionContext tx, OID oid, DepositBox locker, Object object, int timeout) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identity of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException(Messages.format("jdo.identityChanged", this._name, oid.getIdentity(), this.getIdentity(tx, object)));
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        boolean updateCache = false;
        boolean updatePersist = false;
        int i = 0;
        while (i < newfields.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (ClassMolder.isEquals(fields[i], value)) break;
                    if (this._fhs[i].isReadonly()) {
                        this._fhs[i].setValue(object, fields[i], tx.getClassLoader());
                        break;
                    }
                    if (this._fhs[i].isStored()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    break;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        Object fieldValue = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (fieldValue == null && bytes == null) break;
                        if (fieldValue == null || bytes == null) {
                            if (this._fhs[i].isStored()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            break;
                        }
                        ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                        ObjectInputStream os = new ObjectInputStream(bis);
                        Object dependent = os.readObject();
                        if (dependent.equals(fieldValue)) break;
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        break;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    Object deref;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        newfields[i] = fieldClassMolder.getIdentity(tx, value);
                    }
                    if (ClassMolder.isEquals(fields[i], newfields[i])) {
                        if (!this._debug || fields[i] == null) break;
                        if (value != null && tx.isDeleted(value)) {
                            System.err.println("Warning: deleted object found!");
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            this._fhs[i].setValue(object, null, tx.getClassLoader());
                            break;
                        }
                        if (!tx.isAutoStore() && !this._fhs[i].isDependent() || value == tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) break;
                        throw new DuplicateIdentityException("");
                    }
                    if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                        updatePersist = true;
                    }
                    updateCache = true;
                    if (this._fhs[i].isDependent()) {
                        Object reldel;
                        if (fields[i] != null && (reldel = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                            tx.delete(reldel);
                        }
                        if (value == null || tx.isRecorded(value)) break;
                        tx.markCreate(fieldEngine, fieldClassMolder, value, oid);
                        break;
                    }
                    if (tx.isAutoStore()) {
                        if (fields[i] != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                            fieldClassMolder.removeRelation(tx, deref, this, object);
                        }
                        if (value == null || tx.isRecorded(value)) break;
                        tx.markCreate(fieldEngine, fieldClassMolder, value, null);
                        break;
                    }
                    if (fields[i] != null && (deref = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) != null) {
                        fieldClassMolder.removeRelation(tx, deref, this, object);
                    }
                    if (value == null || tx.isRecorded(value)) break;
                    throw new PersistenceException("Object, " + object + ", links to another object, " + value + " that is not loaded/updated/created in this transaction");
                }
                case 3: {
                    Iterator itor;
                    ArrayList deleted;
                    RelationCollection lazy;
                    Iterator addedItor;
                    Collection added;
                    Object reldel;
                    Iterator removedItor;
                    Collection removed;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    ArrayList orgFields = (ArrayList)fields[i];
                    if (!(value instanceof Lazy)) {
                        removed = this.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                        removedItor = removed.iterator();
                        if (removedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (removedItor.hasNext()) {
                            Object removedId = removedItor.next();
                            reldel = tx.fetch(fieldEngine, fieldClassMolder, removedId, null);
                            if (reldel == null) continue;
                            if (this._fhs[i].isDependent()) {
                                tx.delete(reldel);
                                continue;
                            }
                            fieldClassMolder.removeRelation(tx, reldel, this, object);
                        }
                        added = this.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                        addedItor = added.iterator();
                        if (addedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (addedItor.hasNext()) {
                            Object addedValue = addedItor.next();
                            if (this._fhs[i].isDependent()) {
                                if (tx.isRecorded(addedValue)) continue;
                                tx.markCreate(fieldEngine, fieldClassMolder, addedValue, oid);
                                continue;
                            }
                            if (!tx.isAutoStore() || tx.isRecorded(addedValue)) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, addedValue, null);
                        }
                    } else {
                        Object toBeAdded;
                        lazy = (RelationCollection)value;
                        tx.addTxSynchronizable(lazy);
                        deleted = lazy.getDeleted();
                        if (!deleted.isEmpty()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            itor = ((AbstractList)deleted).iterator();
                            while (itor.hasNext()) {
                                updateCache = true;
                                Object toBeDeleted = lazy.find(itor.next());
                                if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                                if (this._fhs[i].isDependent()) {
                                    tx.delete(toBeDeleted);
                                    continue;
                                }
                                fieldClassMolder.removeRelation(tx, toBeDeleted, this, object);
                            }
                        }
                        if (((ArrayList)(added = lazy.getAdded())).isEmpty()) break;
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        if (this._fhs[i].isDependent()) {
                            itor = ((AbstractList)added).iterator();
                            while (itor.hasNext()) {
                                toBeAdded = lazy.find(itor.next());
                                if (toBeAdded == null) continue;
                                tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, oid);
                            }
                        } else {
                            if (!tx.isAutoStore()) break;
                            itor = ((AbstractList)added).iterator();
                            while (itor.hasNext()) {
                                toBeAdded = lazy.find(itor.next());
                                if (toBeAdded == null || tx.isRecorded(toBeAdded)) continue;
                                tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, null);
                            }
                        }
                    }
                    break;
                }
                case 4: {
                    Iterator itor;
                    ArrayList deleted;
                    RelationCollection lazy;
                    Iterator addedItor;
                    Collection added;
                    Object reldel;
                    Iterator removedItor;
                    Collection removed;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    ArrayList orgFields = (ArrayList)fields[i];
                    if (!(value instanceof Lazy)) {
                        removed = this.getRemovedIdsList(tx, orgFields, value, fieldClassMolder);
                        removedItor = removed.iterator();
                        if (removedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (removedItor.hasNext()) {
                            Object id = removedItor.next();
                            if (tx.isDeletedByOID(new OID(fieldEngine, fieldClassMolder, id)) || (reldel = tx.load(fieldEngine, fieldClassMolder, id, null, null)) == null || !tx.isPersistent(reldel)) continue;
                            tx.writeLock(reldel, tx.getLockTimeout());
                            this._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), id);
                            fieldClassMolder.removeRelation(tx, reldel, this, object);
                        }
                        added = this.getAddedValuesList(tx, orgFields, value, fieldClassMolder);
                        addedItor = added.iterator();
                        if (addedItor.hasNext()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                        }
                        while (addedItor.hasNext()) {
                            Object addedField = addedItor.next();
                            tx.markModified(addedField, false, true);
                            if (tx.isPersistent(addedField)) {
                                this._fhs[i].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), fieldClassMolder.getIdentity(tx, addedField));
                                continue;
                            }
                            if (!tx.isAutoStore() || tx.isDeleted(addedField)) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, addedField, null);
                        }
                    } else {
                        lazy = (RelationCollection)value;
                        tx.addTxSynchronizable(lazy);
                        deleted = lazy.getDeleted();
                        if (!deleted.isEmpty()) {
                            if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                                updatePersist = true;
                            }
                            updateCache = true;
                            itor = ((AbstractList)deleted).iterator();
                            while (itor.hasNext()) {
                                updateCache = true;
                                Object deletedId = itor.next();
                                Object toBeDeleted = lazy.find(deletedId);
                                if (toBeDeleted == null || !tx.isPersistent(toBeDeleted)) continue;
                                tx.writeLock(toBeDeleted, 0);
                                this._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), deletedId);
                                fieldClassMolder.removeRelation(tx, toBeDeleted, this, object);
                            }
                        }
                        if (((ArrayList)(added = lazy.getAdded())).isEmpty()) break;
                        if (this._fhs[i].isStored() && this._fhs[i].isCheckDirty()) {
                            updatePersist = true;
                        }
                        updateCache = true;
                        itor = ((AbstractList)added).iterator();
                        while (itor.hasNext()) {
                            Object addedId = itor.next();
                            Object toBeAdded = lazy.find(addedId);
                            if (toBeAdded == null) continue;
                            if (tx.isPersistent(toBeAdded)) {
                                this._fhs[i].getRelationLoader().createRelation((Connection)tx.getConnection(oid.getLockEngine()), oid.getIdentity(), addedId);
                                continue;
                            }
                            if (!tx.isAutoStore() || tx.isRecorded(toBeAdded)) continue;
                            tx.markCreate(fieldEngine, fieldClassMolder, toBeAdded, null);
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        tx.markModified(object, updatePersist, updateCache);
        if (updateCache || updatePersist) {
            tx.writeLock(object, timeout);
        }
        return updateCache;
    }

    public void store(TransactionContext tx, OID oid, DepositBox locker, Object object) throws DuplicateIdentityException, PersistenceException, ObjectModifiedException, ObjectDeletedException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be stored is null");
        }
        if (!oid.getIdentity().equals(this.getIdentity(tx, object))) {
            throw new PersistenceException("Identities changes is not allowed!");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        if (fields == null) {
            throw new PersistenceException("Object, " + oid + ",  isn't loaded in the persistence storage!");
        }
        Object[] newfields = new Object[this._fhs.length];
        int i = 0;
        while (i < newfields.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    newfields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    break;
                }
                case 1: {
                    try {
                        Object dependent = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (dependent != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(dependent);
                            newfields[i] = bos.toByteArray();
                            break;
                        }
                        newfields[i] = null;
                        break;
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error during serializing dependent object", e);
                    }
                }
                case 2: {
                    if (!this._fhs[i].isStored()) break;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value == null) break;
                    newfields[i] = fieldClassMolder.getIdentity(tx, value);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    break;
                }
            }
            ++i;
        }
        Object stamp = this._persistence.store(tx.getConnection(oid.getLockEngine()), newfields, oid.getIdentity(), fields, oid.getStamp());
        oid.setStamp(stamp);
    }

    private Collection getAddedValuesList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            return new ArrayList(0);
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return ((Map)collection).values();
            }
            Map newMap = (Map)collection;
            ArrayList added = new ArrayList(newMap.size());
            Iterator newItor = newMap.entrySet().iterator();
            while (newItor.hasNext()) {
                Map.Entry newId = newItor.next();
                if (orgIds.contains(newId.getKey())) continue;
                added.add(newId.getValue());
            }
            return added;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                if (collection == null) {
                    return new ArrayList(0);
                }
                return (Collection)collection;
            }
            if (collection == null) {
                return new ArrayList(0);
            }
            Collection newValues = (Collection)collection;
            ArrayList added = new ArrayList(newValues.size());
            Iterator newItor = newValues.iterator();
            while (newItor.hasNext()) {
                Object newValue = newItor.next();
                Object newId = ch.getIdentity(tx, newValue);
                if (newId != null && orgIds.contains(newId)) continue;
                added.add(newValue);
            }
            return added;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    private Collection getRemovedIdsList(TransactionContext tx, ArrayList orgIds, Object collection, ClassMolder ch) {
        if (collection == null) {
            if (orgIds == null) {
                return new ArrayList(0);
            }
            return orgIds;
        }
        if (collection instanceof Map) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Map newMap = (Map)collection;
            Iterator orgItor = ((AbstractList)orgIds).iterator();
            ArrayList removed = new ArrayList(orgIds.size());
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        if (collection instanceof Collection) {
            if (orgIds == null || orgIds.size() == 0) {
                return new ArrayList(0);
            }
            Collection newCol = (Collection)collection;
            Iterator orgItor = ((AbstractList)orgIds).iterator();
            ArrayList removed = new ArrayList(0);
            HashMap newMap = new HashMap();
            Iterator newColItor = newCol.iterator();
            while (newColItor.hasNext()) {
                Object newObject = newColItor.next();
                Object newId = ch.getIdentity(tx, newObject);
                if (newId == null) continue;
                newMap.put(newId, newObject);
            }
            while (orgItor.hasNext()) {
                Object id = orgItor.next();
                if (newMap.containsKey(id)) continue;
                removed.add(id);
            }
            return removed;
        }
        throw new IllegalArgumentException("Collection type " + collection.getClass().getName() + " is not supported!");
    }

    /*
     * Unable to fully structure code
     */
    public boolean update(TransactionContext tx, OID oid, DepositBox locker, Object object, AccessMode suggestedAccessMode) throws PersistenceException, ObjectModifiedException {
        block42: {
            accessMode = this.getAccessMode(suggestedAccessMode);
            fields = (Object[])locker.getObject(tx);
            if (!this.isDependent() && !this._timeStampable) {
                throw new IllegalArgumentException("A master object that involves in a long transaction must be a TimeStampable!");
            }
            lockTimestamp = locker.getTimeStamp();
            v0 = objectTimestamp = this._timeStampable != false ? ((TimeStampable)object).jdoGetTimeStamp() : 1L;
            if (objectTimestamp <= 0L || oid.getIdentity() == null) break block42;
            if (this._timeStampable && objectTimestamp != lockTimestamp) {
                throw new ObjectModifiedException("Timestamp mismatched!");
            }
            if (!this._timeStampable && this.isDependent() && fields == null) {
                fields = new Object[this._fhs.length];
                conn = (Connection)tx.getConnection(oid.getLockEngine());
                stamp = this._persistence.load(conn, fields, oid.getIdentity(), accessMode);
                oid.setDbLock(accessMode == AccessMode.DbLocked);
                locker.setObject(tx, fields);
            }
            ids = oid.getIdentity();
            try {
                i = 0;
                while (i < this._fhs.length) {
                    fieldType = this._fhs[i].getFieldType();
                    switch (fieldType) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            break;
                        }
                        case 2: {
                            fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            fieldEngine = this._fhs[i].getFieldLockEngine();
                            o = this._fhs[i].getValue(object, tx.getClassLoader());
                            if (this._fhs[i].isDependent()) {
                                if (o != null && !tx.isRecorded(o)) {
                                    tx.markUpdate(fieldEngine, fieldClassMolder, o, oid);
                                }
                                if (fields[i] == null) break;
                                tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                                break;
                            }
                            if (!tx.isAutoStore()) break;
                            if (o != null && !tx.isRecorded(o)) {
                                tx.markUpdate(fieldEngine, fieldClassMolder, o, null);
                            }
                            if (fields[i] == null) break;
                            tx.load(fieldEngine, fieldClassMolder, fields[i], null, suggestedAccessMode);
                            break;
                        }
                        case 3: {
                            fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            fieldEngine = this._fhs[i].getFieldLockEngine();
                            if (!this._fhs[i].isDependent()) ** GOTO lbl78
                            if (!this._fhs[i].isLazy()) {
                                itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                                v = (ArrayList)fields[i];
                                newSetOfIds = new ArrayList<E>();
                                while (itor.hasNext()) {
                                    element = itor.next();
                                    actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                    newSetOfIds.add(actualIdentity);
                                    if (v == null || !v.contains(actualIdentity) || tx.isRecorded(element)) continue;
                                    tx.markUpdate(fieldEngine, fieldClassMolder, element, oid);
                                }
                                if (v == null) break;
                                j = 0;
                                l = v.size();
                                while (j < l) {
                                    if (!newSetOfIds.contains(v.get(j))) {
                                        tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                                    }
                                    ++j;
                                }
                            } else {
                                avlist = (ArrayList)fields[i];
                                fieldClassMolder = this._fhs[i].getFieldClassMolder();
                                fieldEngine = this._fhs[i].getFieldLockEngine();
                                relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, accessMode, avlist);
                                break;
lbl78:
                                // 1 sources

                                if (!tx.isAutoStore()) break;
                                itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                                v = (ArrayList)fields[i];
                                newSetOfIds = new ArrayList<E>();
                                while (itor.hasNext()) {
                                    element = itor.next();
                                    actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                    newSetOfIds.add(actualIdentity);
                                    if (v != null && v.contains(actualIdentity)) {
                                        if (tx.isRecorded(element)) continue;
                                        tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                                        continue;
                                    }
                                    if (tx.isRecorded(element)) continue;
                                    tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                                }
                                if (v == null) break;
                                j = 0;
                                l = v.size();
                                while (j < l) {
                                    if (!newSetOfIds.contains(v.get(j))) {
                                        tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                                    }
                                    ++j;
                                }
                            }
                            break;
                        }
                        case 4: {
                            fieldClassMolder = this._fhs[i].getFieldClassMolder();
                            fieldEngine = this._fhs[i].getFieldLockEngine();
                            if (!tx.isAutoStore()) break;
                            itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                            v = (ArrayList)fields[i];
                            newSetOfIds = new ArrayList<Object>();
                            while (itor.hasNext()) {
                                element = itor.next();
                                actualIdentity = fieldClassMolder.getActualIdentity(tx, element);
                                newSetOfIds.add(actualIdentity);
                                if (v != null && v.contains(actualIdentity)) {
                                    if (tx.isRecorded(element)) continue;
                                    tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                                    continue;
                                }
                                if (tx.isRecorded(element)) continue;
                                tx.markUpdate(fieldEngine, fieldClassMolder, element, null);
                            }
                            if (v == null) break;
                            j = 0;
                            l = v.size();
                            while (j < l) {
                                if (!newSetOfIds.contains(v.get(j))) {
                                    tx.load(oid.getLockEngine(), fieldClassMolder, v.get(j), null, suggestedAccessMode);
                                }
                                ++j;
                            }
                            break;
                        }
                    }
                    ++i;
                }
            }
            catch (ObjectNotFoundException e) {
                e.printStackTrace();
                throw new ObjectModifiedException("dependent object deleted concurrently");
            }
            return false;
        }
        if (objectTimestamp == 0L || objectTimestamp == 1L) {
            updateCache = false;
            i = 0;
            while (i < this._fhs.length) {
                fieldType = this._fhs[i].getFieldType();
                switch (fieldType) {
                    case 0: 
                    case 1: {
                        break;
                    }
                    case 2: {
                        fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        fieldEngine = this._fhs[i].getFieldLockEngine();
                        o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) break;
                        if (this._fhs[i].isDependent()) {
                            if (tx.isRecorded(o)) break;
                            tx.markCreate(fieldEngine, fieldClassMolder, o, oid);
                            if (this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                            updateCache = true;
                            break;
                        }
                        if (!tx.isAutoStore() || tx.isRecorded(o) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, o, null)) || this._fhs[i].isStored() || !fieldClassMolder._isKeyGenUsed) break;
                        updateCache = true;
                        break;
                    }
                    case 3: {
                        fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        fieldEngine = this._fhs[i].getFieldLockEngine();
                        o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) break;
                        itor = this.getIterator(o);
                        while (itor.hasNext()) {
                            oo = itor.next();
                            if (this._fhs[i].isDependent()) {
                                if (!tx.isRecorded(oo)) {
                                    tx.markCreate(fieldEngine, fieldClassMolder, oo, oid);
                                    if (!fieldClassMolder._isKeyGenUsed) continue;
                                    updateCache = true;
                                    continue;
                                }
                                if (tx.isDepended(oid, oo)) continue;
                                throw new PersistenceException("Dependent object may not change its master");
                            }
                            if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null)) || !fieldClassMolder._isKeyGenUsed) continue;
                            updateCache = true;
                        }
                        break;
                    }
                    case 4: {
                        fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        fieldEngine = this._fhs[i].getFieldLockEngine();
                        o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o == null) break;
                        itor = this.getIterator(o);
                        while (itor.hasNext()) {
                            oo = itor.next();
                            if (!tx.isAutoStore() || tx.isRecorded(oo) || !(creating = tx.markUpdate(fieldEngine, fieldClassMolder, oo, null))) continue;
                            updateCache = true;
                        }
                        break;
                    }
                }
                ++i;
            }
            tx.markModified(object, false, updateCache);
            return true;
        }
        System.err.println("object: " + object + " timestamp: " + objectTimestamp + "lockertimestamp: " + lockTimestamp);
        throw new ObjectModifiedException("Invalid object timestamp detected.");
    }

    public void updateCache(TransactionContext tx, OID oid, DepositBox locker, Object object) {
        Object[] fields = new Object[this._fhs.length];
        if (oid.getIdentity() == null) {
            throw new IllegalStateException("The identities of the cache to be updated is null");
        }
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    fields[i] = this._fhs[i].getValue(object, tx.getClassLoader());
                    break;
                }
                case 1: {
                    try {
                        Object o = this._fhs[i].getValue(object, tx.getClassLoader());
                        if (o != null) {
                            ByteArrayOutputStream bos = new ByteArrayOutputStream();
                            ObjectOutputStream os = new ObjectOutputStream(bos);
                            os.writeObject(o);
                            fields[i] = bos.toByteArray();
                            break;
                        }
                        fields[i] = null;
                    }
                    catch (IOException e) {}
                    break;
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        Object fid = fieldClassMolder.getIdentity(tx, value);
                        if (fid == null) break;
                        fields[i] = fid;
                        break;
                    }
                    fields[i] = null;
                    break;
                }
                case 3: {
                    RelationCollection lazy;
                    ArrayList fids;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        if (!(value instanceof Lazy)) {
                            fids = this.extractIdentityList(tx, fieldClassMolder, value);
                            fields[i] = fids;
                            break;
                        }
                        lazy = (RelationCollection)value;
                        fids = (ArrayList)lazy.getIdentitiesList().clone();
                        fields[i] = fids;
                        break;
                    }
                    fields[i] = null;
                    break;
                }
                case 4: {
                    RelationCollection lazy;
                    ArrayList fids;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    Object value = this._fhs[i].getValue(object, tx.getClassLoader());
                    if (value != null) {
                        if (!(value instanceof Lazy)) {
                            fids = this.extractIdentityList(tx, fieldClassMolder, value);
                            fields[i] = fids;
                            break;
                        }
                        lazy = (RelationCollection)value;
                        fids = (ArrayList)lazy.getIdentitiesList().clone();
                        fields[i] = fids;
                        break;
                    }
                    fields[i] = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Field type invalid!");
                }
            }
            ++i;
        }
        locker.setObject(tx, fields);
        if (object instanceof TimeStampable) {
            ((TimeStampable)object).jdoSetTimeStamp(locker.getTimeStamp());
        }
    }

    private static void deleteExtend(TransactionContext tx, ClassMolder extend, Object identity) throws ObjectNotFoundException, PersistenceException {
        Object[] persistFields = null;
        int i = 0;
        while (i < extend._fhs.length) {
            if (extend._fhs[i].isDependent()) {
                try {
                    if (persistFields == null) {
                        persistFields = new Object[extend._fhs.length];
                        extend._persistence.load((Connection)tx.getConnection(extend._engine), persistFields, identity, AccessMode.ReadOnly);
                    }
                    if (extend._fhs[i].isMulti()) {
                        ArrayList listOfIds = (ArrayList)persistFields[i];
                        int j = 0;
                        while (i < listOfIds.size()) {
                            extend._persistence.delete(tx.getConnection(extend._fhs[i].getFieldLockEngine()), listOfIds.get(j));
                            ++j;
                        }
                    }
                }
                catch (ObjectNotFoundException e) {}
            } else if (extend._fhs[i].isManyToMany()) {
                extend._fhs[i].getRelationLoader().deleteRelation((Connection)tx.getConnection(extend._fhs[i].getFieldLockEngine()), identity);
            }
            ++i;
        }
    }

    public void delete(TransactionContext tx, OID oid) throws PersistenceException {
        int i;
        Object ids = oid.getIdentity();
        int i2 = 0;
        while (i2 < this._fhs.length) {
            if (this._fhs[i2].isManyToMany()) {
                this._fhs[i2].getRelationLoader().deleteRelation((Connection)tx.getConnection(oid.getLockEngine()), ids);
            }
            ++i2;
        }
        this._persistence.delete((Connection)tx.getConnection(oid.getLockEngine()), ids);
        Vector<ClassMolder> extendPath = new Vector<ClassMolder>();
        ClassMolder base = this;
        while (base != null) {
            extendPath.add(base);
            base = base._extends;
        }
        base = this._depends;
        while (base != null) {
            if (base._extendent != null) {
                i = 0;
                while (i < base._extendent.size()) {
                    if (!extendPath.contains(base._extendent.get(i))) {
                        // empty if block
                    }
                    ++i;
                }
            }
            base = base._extends;
        }
        if (this._extendent != null) {
            i = 0;
            while (i < this._extendent.size()) {
                if (!extendPath.contains(this._extendent.get(i))) {
                    // empty if block
                }
                ++i;
            }
        }
    }

    public void markDelete(TransactionContext tx, OID oid, DepositBox locker, Object object) throws ObjectNotFoundException, PersistenceException {
        Object[] fields = (Object[])locker.getObject(tx);
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: 
                case 1: {
                    break;
                }
                case 2: {
                    Object fid;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (this._fhs[i].isDependent()) {
                        Object fobject;
                        fid = fields[i];
                        Object fetched = null;
                        if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                            tx.delete(fetched);
                        }
                        if ((fobject = this._fhs[i].getValue(object, tx.getClassLoader())) == null || !tx.isPersistent(fobject)) break;
                        tx.delete(fobject);
                        break;
                    }
                    fid = fields[i];
                    Object fetched = null;
                    if (fid == null || (fetched = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null)) == null) break;
                    fieldClassMolder.removeRelation(tx, fetched, this, object);
                    break;
                }
                case 3: {
                    Object fobject;
                    Iterator itor;
                    Object fetched;
                    Object fid;
                    ArrayList alist;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (this._fhs[i].isDependent()) {
                        alist = (ArrayList)fields[i];
                        if (fields[i] == null) break;
                        int j = 0;
                        while (j < alist.size()) {
                            fid = alist.get(j);
                            fetched = null;
                            if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                                tx.delete(fetched);
                            }
                            ++j;
                        }
                        itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                        while (itor.hasNext()) {
                            fobject = itor.next();
                            if (fobject == null || !tx.isPersistent(fobject)) continue;
                            tx.delete(fobject);
                        }
                    } else {
                        if (fields[i] == null) break;
                        alist = (ArrayList)fields[i];
                        int j = 0;
                        while (j < alist.size()) {
                            fid = alist.get(j);
                            fetched = null;
                            if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                                fieldClassMolder.removeRelation(tx, fetched, this, object);
                            }
                            ++j;
                        }
                        itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                        while (itor.hasNext()) {
                            fobject = itor.next();
                            if (fobject == null || !tx.isPersistent(fobject)) continue;
                            fieldClassMolder.removeRelation(tx, fobject, this, object);
                        }
                    }
                    break;
                }
                case 4: {
                    Object fetched;
                    Object fid;
                    ArrayList alist;
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        alist = (ArrayList)fields[i];
                        int j = 0;
                        while (j < alist.size()) {
                            fid = alist.get(j);
                            fetched = null;
                            if (fid != null && (fetched = tx.fetch(fieldEngine, fieldClassMolder, fid, null)) != null) {
                                fieldClassMolder.removeRelation(tx, fetched, this, object);
                            }
                            ++j;
                        }
                    }
                    Iterator itor = this.getIterator(this._fhs[i].getValue(object, tx.getClassLoader()));
                    while (itor.hasNext()) {
                        Object fobject = itor.next();
                        if (fobject == null || !tx.isPersistent(fobject)) continue;
                        fieldClassMolder.removeRelation(tx, fobject, this, object);
                    }
                    break;
                }
                default: {
                    throw new PersistenceException("Invalid field type!");
                }
            }
            ++i;
        }
    }

    public void revertObject(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
        if (oid.getIdentity() == null) {
            throw new PersistenceException("The identities of the object to be revert is null");
        }
        Object[] fields = (Object[])locker.getObject(tx);
        this.setIdentity(tx, object, oid.getIdentity());
        int i = 0;
        while (i < this._fhs.length) {
            short fieldType = this._fhs[i].getFieldType();
            switch (fieldType) {
                case 0: {
                    Object temp = fields[i];
                    break;
                }
                case 1: {
                    try {
                        byte[] bytes = (byte[])fields[i];
                        if (bytes != null) {
                            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
                            ObjectInputStream os = new ObjectInputStream(bis);
                            Object o = os.readObject();
                            this._fhs[i].setValue(object, o, tx.getClassLoader());
                            break;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        break;
                    }
                    catch (OptionalDataException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (ClassNotFoundException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                    catch (IOException e) {
                        throw new PersistenceException("Error while deserializing an dependent object", e);
                    }
                }
                case 2: {
                    ClassMolder fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    LockEngine fieldEngine = this._fhs[i].getFieldLockEngine();
                    if (fields[i] != null) {
                        Object value = tx.fetch(fieldEngine, fieldClassMolder, fields[i], null);
                        this._fhs[i].setValue(object, value, tx.getClassLoader());
                        break;
                    }
                    this._fhs[i].setValue(object, null, tx.getClassLoader());
                    break;
                }
                case 3: 
                case 4: {
                    LockEngine fieldEngine;
                    ClassMolder fieldClassMolder;
                    Object o = fields[i];
                    if (o == null) {
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        break;
                    }
                    if (!this._fhs[i].isLazy()) {
                        fieldClassMolder = this._fhs[i].getFieldClassMolder();
                        fieldEngine = this._fhs[i].getFieldLockEngine();
                        CollectionProxy cp = CollectionProxy.create(this._fhs[i], object, tx.getClassLoader());
                        ArrayList v = (ArrayList)fields[i];
                        if (v != null) {
                            this._fhs[i].setValue(object, cp.getCollection(), tx.getClassLoader());
                            int j = 0;
                            int l = v.size();
                            while (j < l) {
                                cp.add(v.get(j), tx.fetch(oid.getLockEngine(), fieldClassMolder, v.get(j), null));
                                ++j;
                            }
                            cp.close();
                            break;
                        }
                        this._fhs[i].setValue(object, null, tx.getClassLoader());
                        break;
                    }
                    ArrayList list = (ArrayList)fields[i];
                    fieldClassMolder = this._fhs[i].getFieldClassMolder();
                    fieldEngine = this._fhs[i].getFieldLockEngine();
                    RelationCollection relcol = new RelationCollection(tx, oid, fieldEngine, fieldClassMolder, null, list);
                    this._fhs[i].setValue(object, relcol, tx.getClassLoader());
                    break;
                }
            }
            ++i;
        }
    }

    public void writeLock(TransactionContext tx, OID oid, DepositBox locker, Object object) throws PersistenceException {
    }

    public Object newInstance(ClassLoader loader) {
        try {
            if (loader != null) {
                return loader.loadClass(this._name).newInstance();
            }
            return Class.forName(this._name).newInstance();
        }
        catch (ClassNotFoundException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InstantiationException e) {
        }
        catch (ExceptionInInitializerError e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        return null;
    }

    public AccessMode getAccessMode(AccessMode txMode) {
        if (txMode == null) {
            return this._accessMode;
        }
        if (this._accessMode == AccessMode.ReadOnly || txMode == AccessMode.ReadOnly) {
            return AccessMode.ReadOnly;
        }
        if (this._accessMode == AccessMode.DbLocked || txMode == AccessMode.DbLocked) {
            return AccessMode.DbLocked;
        }
        if (this._accessMode == AccessMode.Exclusive || txMode == AccessMode.Exclusive) {
            return AccessMode.Exclusive;
        }
        return txMode;
    }

    public CallbackInterceptor getCallback() {
        return this._callback;
    }

    public boolean isDefaultIdentity(Object identity) {
        if (this._ids.length == 1) {
            return this._ids[0].isDefault(identity);
        }
        if (identity == null) {
            return true;
        }
        Complex c = (Complex)identity;
        int i = 0;
        while (i < c.size()) {
            if (!this._ids[i].isDefault(c.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object getIdentity(TransactionContext tx, Object o) {
        if (this.isKeyGeneratorUsed() && !tx.isPersistent(o) && !tx.isReadOnly(o)) {
            return null;
        }
        return this.getActualIdentity(tx, o);
    }

    public Object getActualIdentity(TransactionContext tx, Object o) {
        return this.getActualIdentity(tx.getClassLoader(), o);
    }

    public Object getActualIdentity(ClassLoader loader, Object o) {
        if (this._ids.length == 1) {
            return this._ids[0].getValue(o, loader);
        }
        if (this._ids.length == 2) {
            Object temp = this._ids[0].getValue(o, loader);
            return temp == null ? null : new Complex(temp, this._ids[1].getValue(o, loader));
        }
        Object[] osIds = new Object[this._ids.length];
        int i = 0;
        while (i < osIds.length) {
            osIds[i] = this._ids[i].getValue(o, loader);
            ++i;
        }
        if (osIds[0] == null) {
            return null;
        }
        return new Complex(osIds);
    }

    public void setIdentity(TransactionContext tx, Object object, Object identity) throws PersistenceException {
        if (this._ids.length > 1) {
            if (identity instanceof Complex) {
                Complex com = (Complex)identity;
                if (com.size() != this._ids.length) {
                    throw new PersistenceException("Complex size mismatched!");
                }
                int i = 0;
                while (i < this._ids.length) {
                    this._ids[i].setValue(object, com.get(i), tx.getClassLoader());
                    ++i;
                }
            }
        } else {
            if (identity instanceof Complex) {
                throw new PersistenceException("Complex type not accepted!");
            }
            this._ids[0].setValue(object, identity, tx.getClassLoader());
        }
    }

    public Persistence getPersistence() {
        return this._persistence;
    }

    public void setPersistence(Persistence persist) {
        this._persistence = persist;
    }

    public Class getJavaClass(ClassLoader loader) {
        Class<?> result = null;
        try {
            result = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean isAssignableFrom(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        Class<?> molderClass = null;
        try {
            molderClass = loader != null ? loader.loadClass(this._name) : Class.forName(this._name);
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return molderClass.isAssignableFrom(cls);
    }

    public String getName() {
        return this._name;
    }

    public FieldMolder[] getFields() {
        return this._fhs;
    }

    public FieldMolder[] getIds() {
        return this._ids;
    }

    public ClassMolder getExtends() {
        return this._extends;
    }

    public ClassMolder getDepends() {
        return this._depends;
    }

    public LockEngine getLockEngine() {
        return this._engine;
    }

    public int getCacheType() {
        return this._cachetype;
    }

    public int getCacheParam() {
        return this._cacheparam;
    }

    public boolean isDependent() {
        return this._depends != null;
    }

    public void setFieldsNull(Object object) {
    }

    void addExtendent(ClassMolder ext) {
        if (this._extendent == null) {
            this._extendent = new Vector();
        }
        this._extendent.add(ext);
    }

    void addDependent(ClassMolder dep) {
        if (this._dependent == null) {
            this._dependent = new Vector();
        }
        this._dependent.add(dep);
    }

    void setExtends(ClassMolder ext) {
        this._extends = ext;
        ext.addExtendent(this);
    }

    void setDepends(ClassMolder dep) {
        this._depends = dep;
        dep.addDependent(this);
    }

    private Iterator getIterator(Object o) {
        if (o == null) {
            return new Iterator(){

                public boolean hasNext() {
                    return false;
                }

                public Object next() {
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        if (o instanceof Collection) {
            return ((Collection)o).iterator();
        }
        if (o instanceof Map) {
            return ((Map)o).values().iterator();
        }
        throw new IllegalArgumentException();
    }

    private ArrayList extractIdentityList(TransactionContext tx, ClassMolder molder, Object col) {
        if (col == null) {
            return new ArrayList();
        }
        if (col instanceof Collection) {
            ArrayList<Object> idList = new ArrayList<Object>();
            Iterator itor = ((Collection)col).iterator();
            while (itor.hasNext()) {
                Object id = molder.getIdentity(tx, itor.next());
                if (id == null) continue;
                idList.add(id);
            }
            return idList;
        }
        if (col instanceof Map) {
            ArrayList idList = new ArrayList();
            Iterator itor = ((Map)col).keySet().iterator();
            while (itor.hasNext()) {
                idList.add(itor.next());
            }
            return idList;
        }
        throw new IllegalArgumentException("A Collection or Map is expected!");
    }

    public String toString() {
        return "ClassMolder " + this._name;
    }

    public boolean isKeyGeneratorUsed() {
        return this._isKeyGenUsed || this._extends != null && this._extends.isKeyGeneratorUsed();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

