/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.document;

import com.lowagie.text.HeaderFooter;
import com.lowagie.text.rtf.RtfElement;
import com.lowagie.text.rtf.document.RtfCodePage;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.document.RtfInfoElement;
import com.lowagie.text.rtf.document.RtfInfoGroup;
import com.lowagie.text.rtf.document.RtfPageSetting;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooter;
import com.lowagie.text.rtf.headerfooter.RtfHeaderFooterGroup;
import com.lowagie.text.rtf.list.RtfList;
import com.lowagie.text.rtf.list.RtfListTable;
import com.lowagie.text.rtf.style.RtfColor;
import com.lowagie.text.rtf.style.RtfColorList;
import com.lowagie.text.rtf.style.RtfFont;
import com.lowagie.text.rtf.style.RtfFontList;
import com.lowagie.text.rtf.style.RtfParagraphStyle;
import com.lowagie.text.rtf.style.RtfStylesheetList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class RtfDocumentHeader
extends RtfElement {
    private static final byte[] TITLE_PAGE = "\\titlepg".getBytes();
    private static final byte[] FACING_PAGES = "\\facingp".getBytes();
    private RtfCodePage codePage = null;
    private RtfColorList colorList = null;
    private RtfFontList fontList = null;
    private RtfListTable listTable = null;
    private RtfStylesheetList stylesheetList = null;
    private RtfInfoGroup infoGroup = null;
    private RtfPageSetting pageSetting = null;
    private HeaderFooter header = null;
    private HeaderFooter footer = null;

    protected RtfDocumentHeader(RtfDocument rtfDocument) {
        super(rtfDocument);
    }

    protected void init() {
        this.codePage = new RtfCodePage(this.document);
        this.colorList = new RtfColorList(this.document);
        this.fontList = new RtfFontList(this.document);
        this.listTable = new RtfListTable(this.document);
        this.stylesheetList = new RtfStylesheetList(this.document);
        this.infoGroup = new RtfInfoGroup(this.document);
        this.pageSetting = new RtfPageSetting(this.document);
        this.header = new RtfHeaderFooterGroup(this.document, 1);
        this.footer = new RtfHeaderFooterGroup(this.document, 2);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            byteArrayOutputStream.write(this.codePage.writeDefinition());
            byteArrayOutputStream.write(this.fontList.writeDefinition());
            byteArrayOutputStream.write(this.colorList.writeDefinition());
            byteArrayOutputStream.write(this.stylesheetList.writeDefinition());
            byteArrayOutputStream.write(this.listTable.writeDefinition());
            byteArrayOutputStream.write(this.infoGroup.write());
            byteArrayOutputStream.write(this.pageSetting.writeDefinition());
            byteArrayOutputStream.write(this.writeSectionDefinition());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] writeSectionDefinition() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            RtfHeaderFooterGroup rtfHeaderFooterGroup = this.convertHeaderFooter(this.header, 1);
            RtfHeaderFooterGroup rtfHeaderFooterGroup2 = this.convertHeaderFooter(this.footer, 2);
            if (rtfHeaderFooterGroup.hasTitlePage() || rtfHeaderFooterGroup2.hasTitlePage()) {
                byteArrayOutputStream.write(TITLE_PAGE);
                rtfHeaderFooterGroup.setHasTitlePage();
                rtfHeaderFooterGroup2.setHasTitlePage();
            }
            if (rtfHeaderFooterGroup.hasFacingPages() || rtfHeaderFooterGroup2.hasFacingPages()) {
                byteArrayOutputStream.write(FACING_PAGES);
                rtfHeaderFooterGroup.setHasFacingPages();
                rtfHeaderFooterGroup2.setHasFacingPages();
            }
            byteArrayOutputStream.write(rtfHeaderFooterGroup2.write());
            byteArrayOutputStream.write(rtfHeaderFooterGroup.write());
            byteArrayOutputStream.write(this.pageSetting.writeSectionDefinition());
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public int getFontNumber(RtfFont rtfFont) {
        return this.fontList.getFontNumber(rtfFont);
    }

    public int getColorNumber(RtfColor rtfColor) {
        return this.colorList.getColorNumber(rtfColor);
    }

    public int getListNumber(RtfList rtfList) {
        return this.listTable.getListNumber(rtfList);
    }

    public RtfParagraphStyle getRtfParagraphStyle(String string) {
        return this.stylesheetList.getRtfParagraphStyle(string);
    }

    public void freeListNumber(RtfList rtfList) {
        this.listTable.freeListNumber(rtfList);
    }

    public RtfPageSetting getPageSetting() {
        return this.pageSetting;
    }

    public void addInfoElement(RtfInfoElement rtfInfoElement) {
        this.infoGroup.add(rtfInfoElement);
    }

    public void setHeader(HeaderFooter headerFooter) {
        this.header = headerFooter;
    }

    public void setFooter(HeaderFooter headerFooter) {
        this.footer = headerFooter;
    }

    public void registerParagraphStyle(RtfParagraphStyle rtfParagraphStyle) {
        this.stylesheetList.registerParagraphStyle(rtfParagraphStyle);
    }

    private RtfHeaderFooterGroup convertHeaderFooter(HeaderFooter headerFooter, int n) {
        if (headerFooter != null) {
            if (headerFooter instanceof RtfHeaderFooterGroup) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooterGroup)headerFooter, n);
            }
            if (headerFooter instanceof RtfHeaderFooter) {
                return new RtfHeaderFooterGroup(this.document, (RtfHeaderFooter)headerFooter, n);
            }
            return new RtfHeaderFooterGroup(this.document, headerFooter, n);
        }
        return new RtfHeaderFooterGroup(this.document, n);
    }
}

