/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.visual.mappings.continuous;

import cytoscape.visual.mappings.BoundaryRangeValues;
import cytoscape.visual.mappings.Interpolator;
import cytoscape.visual.mappings.InterpolatorFactory;
import cytoscape.visual.mappings.continuous.ContinuousMappingPoint;
import cytoscape.visual.parsers.ObjectToString;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;

public class ContinuousMappingWriter {
    private Properties newProps = new Properties();

    public ContinuousMappingWriter(ArrayList points, String baseKey, String attrName, Interpolator interp) {
        this.loadProperties(points, baseKey, attrName, interp);
    }

    public Properties getProperties() {
        return this.newProps;
    }

    private void loadProperties(ArrayList points, String baseKey, String contAttrName, Interpolator interp) {
        String contAttrKey = baseKey + ".controller";
        if (contAttrName != null) {
            this.newProps.setProperty(contAttrKey, contAttrName);
        }
        String intKey = baseKey + ".interpolator";
        String intName = InterpolatorFactory.getName(interp);
        this.newProps.setProperty(intKey, intName);
        String bvNumKey = baseKey + ".boundaryvalues";
        int numBV = points.size();
        String numString = Integer.toString(numBV);
        this.newProps.setProperty(bvNumKey, numString);
        int count = 0;
        Iterator si = points.iterator();
        while (si.hasNext()) {
            String bvBase = baseKey + ".bv" + count;
            String bvKey = bvBase + ".domainvalue";
            ContinuousMappingPoint cmp = (ContinuousMappingPoint)si.next();
            Double dVal = new Double(cmp.getValue());
            String dValString = dVal.toString();
            this.newProps.setProperty(bvKey, dValString);
            BoundaryRangeValues brv = cmp.getRange();
            String lKey = bvBase + ".lesser";
            String lString = ObjectToString.getStringValue(brv.lesserValue);
            this.newProps.setProperty(lKey, lString);
            String eKey = bvBase + ".equal";
            String eString = ObjectToString.getStringValue(brv.equalValue);
            this.newProps.setProperty(eKey, eString);
            String gKey = bvBase + ".greater";
            String gString = ObjectToString.getStringValue(brv.greaterValue);
            this.newProps.setProperty(gKey, gString);
            ++count;
        }
    }
}

