/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.synonyms;

import cytoscape.Cytoscape;
import cytoscape.data.CyAttributes;
import cytoscape.data.synonyms.AliasType;
import giny.model.Edge;
import giny.model.Node;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Aliases {
    public static final String ALIAS = "alias";
    private final AliasType objectType;
    CyAttributes attributes;

    public Aliases(AliasType type) {
        this.objectType = type;
        switch (this.objectType) {
            case NODE: {
                this.attributes = Cytoscape.getNodeAttributes();
                break;
            }
            case EDGE: {
                this.attributes = Cytoscape.getEdgeAttributes();
                break;
            }
            case NETWORK: {
                this.attributes = Cytoscape.getNetworkAttributes();
                break;
            }
            default: {
                this.attributes = null;
            }
        }
    }

    public void add(String key, String alias) {
        ArrayList<String> aliasList = this.attributes.getListAttribute(key, ALIAS);
        if (aliasList != null) {
            aliasList.add(alias);
            TreeSet aliasSet = new TreeSet(aliasList);
            this.attributes.setListAttribute(key, ALIAS, new ArrayList(aliasSet));
        } else {
            aliasList = new ArrayList<String>();
            aliasList.add(alias);
            this.attributes.setListAttribute(key, ALIAS, aliasList);
        }
    }

    public void add(String key, List<String> aliasList) {
        List curAliasList = this.attributes.getListAttribute(key, ALIAS);
        if (curAliasList != null) {
            curAliasList.addAll(aliasList);
        }
        TreeSet<String> aliasSet = new TreeSet<String>(aliasList);
        this.attributes.setListAttribute(key, ALIAS, new ArrayList<String>(aliasSet));
    }

    public void remove(String key, String alias) {
        List curAliasList = this.attributes.getListAttribute(key, ALIAS);
        if (curAliasList != null) {
            curAliasList.remove(alias);
            this.attributes.setListAttribute(key, ALIAS, curAliasList);
        }
    }

    public List<String> getAliases(String key) {
        return this.attributes.getListAttribute(key, ALIAS);
    }

    public String getKey(String alias) {
        String id = null;
        switch (this.objectType) {
            case NODE: {
                Iterator it = Cytoscape.getRootGraph().nodesIterator();
                while (it.hasNext()) {
                    id = ((Node)it.next()).getIdentifier();
                    List aliases = this.attributes.getListAttribute(id, ALIAS);
                    if (aliases == null || !aliases.contains(alias)) continue;
                    return id;
                }
                break;
            }
            case EDGE: {
                Iterator it = Cytoscape.getRootGraph().edgesIterator();
                while (it.hasNext()) {
                    id = ((Edge)it.next()).getIdentifier();
                    List aliases = this.attributes.getListAttribute(id, ALIAS);
                    if (aliases == null || !aliases.contains(alias)) continue;
                    return id;
                }
                break;
            }
            case NETWORK: {
                Iterator it = Cytoscape.getNetworkSet().iterator();
                while (it.hasNext()) {
                    id = ((Node)it.next()).getIdentifier();
                    List aliases = this.attributes.getListAttribute(id, ALIAS);
                    if (aliases == null || !aliases.contains(alias)) continue;
                    return id;
                }
                break;
            }
        }
        return null;
    }

    public Set<String> getIdSet(String key) {
        List curAliases = this.attributes.getListAttribute(key, ALIAS);
        TreeSet<String> allNames = new TreeSet<String>();
        if (curAliases != null) {
            allNames.addAll(curAliases);
        }
        allNames.add(key);
        return allNames;
    }
}

