/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.data.annotation;

import cytoscape.CyNetwork;
import cytoscape.CyNode;
import cytoscape.Cytoscape;
import cytoscape.CytoscapeInit;
import cytoscape.data.CyAttributes;
import cytoscape.data.Semantics;
import cytoscape.data.annotation.Annotation;
import cytoscape.data.annotation.AnnotationDescription;
import cytoscape.data.servers.BioDataServer;
import cytoscape.util.CytoscapeAction;
import cytoscape.view.CyNetworkView;
import giny.view.NodeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class AnnotationGui
extends CytoscapeAction {
    protected BioDataServer dataServer;
    protected String defaultSpecies;
    AnnotationDescription[] annotationDescriptions;
    JTree availableAnnotationsTree;
    JTree currentAnnotationsTree;
    JList actionListBox;
    DefaultListModel actionListModel;
    int actionListBoxCurrentSelection;
    TreePath annotationPath;
    String currentAnnotationCategory;
    JDialog mainDialog;
    JButton annotateNodesButton;
    JButton layoutByAnnotationButton;
    JButton addSharedAnnotationEdgesButton;
    JButton deleteCreatedObjectsButton;
    CyNetworkView networkView;
    CyNetwork network;

    public AnnotationGui() {
    }

    public AnnotationGui(boolean isMenu, ImageIcon icon) {
        super("Ontology Mapper...", icon);
        this.setPreferredMenu("File.Import.Ontology");
    }

    public void actionPerformed(ActionEvent e) {
        this.networkView = Cytoscape.getCurrentNetworkView();
        this.network = this.networkView.getNetwork();
        this.dataServer = Cytoscape.getBioDataServer();
        if (this.dataServer == null) {
            JOptionPane.showMessageDialog(null, "No annotations are available.", "Error!", 0);
            return;
        }
        if (this.network.getNodeCount() == 0) {
            JOptionPane.showMessageDialog(null, "No nodes in network to annotate.", "Error!", 0);
            return;
        }
        this.annotationDescriptions = this.dataServer.getAnnotationDescriptions();
        Semantics.applyNamingServices(this.network);
        this.defaultSpecies = CytoscapeInit.getProperties().getProperty("defaultSpeciesName");
        this.mainDialog = new Gui("Import Annotation from Ontology Data");
        this.mainDialog.pack();
        this.mainDialog.setLocationRelativeTo(Cytoscape.getDesktop());
        this.mainDialog.setVisible(true);
    }

    public String addAnnotationToNodes(AnnotationDescription aDesc, int level) {
        String callerID = "AnnotationGui.addAnnotationToNodes";
        CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
        String baseAnnotationName = aDesc.getCurator() + " " + aDesc.getType();
        String annotationNameAtLevel = baseAnnotationName + " (Level " + level + ")";
        String annotationNameForLeafIDs = baseAnnotationName + " leaf IDs";
        nodeAttributes.deleteAttribute(annotationNameAtLevel);
        nodeAttributes.deleteAttribute(annotationNameForLeafIDs);
        Iterator it = Cytoscape.getRootGraph().nodesIterator();
        ArrayList<String> nodeLabels = new ArrayList<String>();
        while (it.hasNext()) {
            CyNode node = (CyNode)it.next();
            String nodeLabel = node.getIdentifier();
            if (nodeLabel == null) continue;
            nodeLabels.add(nodeLabel);
        }
        String[] nodeLabelArray = nodeLabels.toArray(new String[nodeLabels.size()]);
        int unAnnotatedNodeCount = 0;
        for (int i = 0; i < nodeLabelArray.length; ++i) {
            String[][] fullAnnotations = this.dataServer.getAllAnnotations(aDesc, nodeLabelArray[i]);
            if (fullAnnotations.length == 0) {
                ++unAnnotatedNodeCount;
                continue;
            }
            String[] uniqueAnnotationsAtLevel = this.collapseToUniqueAnnotationsAtLevel(fullAnnotations, level);
            ArrayList<String> annotsList = new ArrayList<String>();
            if (uniqueAnnotationsAtLevel.length == 0) {
                nodeAttributes.setAttribute(nodeLabelArray[i], annotationNameAtLevel, "");
            } else {
                for (int j = 0; j < uniqueAnnotationsAtLevel.length; ++j) {
                    annotsList.add(uniqueAnnotationsAtLevel[j]);
                }
                if (annotsList.size() != 0) {
                    nodeAttributes.setListAttribute(nodeLabelArray[i], annotationNameAtLevel, annotsList);
                }
            }
            int[] annotationIDs = this.dataServer.getClassifications(aDesc, nodeLabelArray[i]);
            Integer[] integerArray = new Integer[annotationIDs.length];
            for (int j = 0; j < annotationIDs.length; ++j) {
                integerArray[j] = new Integer(annotationIDs[j]);
            }
        }
        return annotationNameAtLevel;
    }

    private String[] collapseToUniqueAnnotationsAtLevel(String[][] fullAnnotations, int level) {
        Vector<String> collector = new Vector<String>();
        for (int i = 0; i < fullAnnotations.length; ++i) {
            String annotationAtLevel;
            int indexOfClosestAvailableLevel = level - 1;
            if (indexOfClosestAvailableLevel > fullAnnotations[i].length - 1) {
                indexOfClosestAvailableLevel = fullAnnotations[i].length - 1;
            }
            if (collector.contains(annotationAtLevel = fullAnnotations[i][indexOfClosestAvailableLevel])) continue;
            collector.add(annotationAtLevel);
        }
        return collector.toArray(new String[0]);
    }

    class ActionListBoxSelectionListener
    implements ListSelectionListener {
        ActionListBoxSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)e.getSource();
            if (!lsm.isSelectionEmpty()) {
                int minIndex = lsm.getMinSelectionIndex();
                int maxIndex = lsm.getMaxSelectionIndex();
                for (int i = minIndex; i <= maxIndex; ++i) {
                    if (!lsm.isSelectedIndex(i)) continue;
                    Object obj = AnnotationGui.this.actionListModel.elementAt(i);
                    AnnotationGui.this.currentAnnotationCategory = (String)obj;
                }
            }
        }
    }

    class ApplyAnnotationAction
    extends AbstractAction {
        ApplyAnnotationAction() {
            super("");
        }

        public void actionPerformed(ActionEvent e) {
            int max = AnnotationGui.this.annotationPath.getPathCount();
            for (int i = 0; i < max; ++i) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(i);
                Object userObj = node.getUserObject();
            }
            DefaultMutableTreeNode node1 = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(1);
            AnnotationDescription aDesc = (AnnotationDescription)node1.getUserObject();
            DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)AnnotationGui.this.annotationPath.getPathComponent(2);
            int level = (Integer)node2.getUserObject();
            if (aDesc == null) {
                return;
            }
            String callerID = "ApplyAnnotationAction.actionPerformed";
            AnnotationGui.this.currentAnnotationCategory = AnnotationGui.this.addAnnotationToNodes(aDesc, level);
            Object[] uniqueAnnotationValues = null;
            CyAttributes nodeAtts = Cytoscape.getNodeAttributes();
            Iterator it = Cytoscape.getRootGraph().nodesIterator();
            HashSet<String> values = new HashSet<String>();
            while (it.hasNext()) {
                Object val;
                List vals;
                CyNode node = (CyNode)it.next();
                byte type = nodeAtts.getType(AnnotationGui.this.currentAnnotationCategory);
                if (type == 4) {
                    String strVal = nodeAtts.getStringAttribute(node.getIdentifier(), AnnotationGui.this.currentAnnotationCategory);
                    if (strVal == null) continue;
                    values.add(strVal);
                    continue;
                }
                if (type != -2 || (vals = nodeAtts.getListAttribute(node.getIdentifier(), AnnotationGui.this.currentAnnotationCategory)).size() <= 0 || !((val = vals.get(0)) instanceof String)) continue;
                values.addAll(vals);
            }
            uniqueAnnotationValues = values.toArray();
            if (uniqueAnnotationValues.length == 0) {
                JOptionPane.showMessageDialog(null, "There is no match between the selected annotation \nand current nodes in the network.\n\nMake sure that your network data file \nand Gene Association files use same naming scheme.\n\nPlease compare the 3rd column of Gene Association\nfile (DB_Object_Symbol) and node names in your network.", "No match in Gene Ontology Database", 0);
            }
            if (uniqueAnnotationValues != null && uniqueAnnotationValues.length > 0 && uniqueAnnotationValues[0].getClass() == "string".getClass()) {
                Arrays.sort(uniqueAnnotationValues, String.CASE_INSENSITIVE_ORDER);
                this.appendToSelectionTree(AnnotationGui.this.currentAnnotationCategory, uniqueAnnotationValues);
            }
        }

        protected void appendToSelectionTree(String currentAnnotationCategory, Object[] uniqueAnnotationValues) {
            DefaultMutableTreeNode branch = new DefaultMutableTreeNode(currentAnnotationCategory);
            for (int i = 0; i < uniqueAnnotationValues.length; ++i) {
                branch.add(new DefaultMutableTreeNode(uniqueAnnotationValues[i]));
            }
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)AnnotationGui.this.currentAnnotationsTree.getModel().getRoot();
            DefaultTreeModel model = (DefaultTreeModel)AnnotationGui.this.currentAnnotationsTree.getModel();
            model.insertNodeInto(branch, root, root.getChildCount());
            AnnotationGui.this.currentAnnotationsTree.scrollPathToVisible(new TreePath(branch.getPath()));
            model.reload();
        }
    }

    protected class Gui
    extends JDialog {
        Gui(String title) {
            super((Frame)Cytoscape.getDesktop(), false);
            this.setTitle(title);
            this.setContentPane(this.createWidgets());
            this.setDefaultCloseOperation(1);
        }

        private JPanel createWidgets() {
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            JPanel topPanel = new JPanel();
            topPanel.setLayout(new GridLayout(0, 2));
            AnnotationGui.this.availableAnnotationsTree = this.createAvailableAnnotationsTree();
            AnnotationGui.this.currentAnnotationsTree = this.createNodeSelectionTree();
            AnnotationGui.this.availableAnnotationsTree.addTreeSelectionListener(new AddAnnotationTreeSelectionListener());
            AnnotationGui.this.currentAnnotationsTree.addTreeSelectionListener(new SelectNodesTreeSelectionListener());
            JScrollPane chooserScrollPane = new JScrollPane(AnnotationGui.this.availableAnnotationsTree);
            JPanel chooserPanel = new JPanel();
            chooserPanel.setLayout(new BorderLayout());
            chooserPanel.add((Component)chooserScrollPane, "Center");
            AnnotationGui.this.annotateNodesButton = new JButton("Apply Annotation to All Nodes");
            AnnotationGui.this.annotateNodesButton.setEnabled(false);
            chooserPanel.add((Component)AnnotationGui.this.annotateNodesButton, "South");
            chooserPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Available Ontology Data"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            AnnotationGui.this.annotateNodesButton.addActionListener(new ApplyAnnotationAction());
            topPanel.add(chooserPanel);
            JPanel currentAnnotationsButtonPanel = new JPanel();
            currentAnnotationsButtonPanel.setLayout(new GridLayout(0, 3));
            AnnotationGui.this.layoutByAnnotationButton = new JButton("Layout");
            AnnotationGui.this.layoutByAnnotationButton.setEnabled(false);
            currentAnnotationsButtonPanel.add(AnnotationGui.this.layoutByAnnotationButton);
            AnnotationGui.this.layoutByAnnotationButton.addActionListener(new LayoutByAnnotationAction());
            AnnotationGui.this.addSharedAnnotationEdgesButton = new JButton("Add Edges");
            currentAnnotationsButtonPanel.add(AnnotationGui.this.addSharedAnnotationEdgesButton);
            AnnotationGui.this.addSharedAnnotationEdgesButton.setEnabled(false);
            AnnotationGui.this.addSharedAnnotationEdgesButton.addActionListener(new DrawSharedEdgesAnnotationAction());
            AnnotationGui.this.deleteCreatedObjectsButton = new JButton("Delete created nodes/edges");
            AnnotationGui.this.deleteCreatedObjectsButton.setEnabled(false);
            currentAnnotationsButtonPanel.add(AnnotationGui.this.deleteCreatedObjectsButton);
            AnnotationGui.this.deleteCreatedObjectsButton.addActionListener(new DeleteCreatedObjectsAction());
            JScrollPane currentChoicesScrollPane = new JScrollPane(AnnotationGui.this.currentAnnotationsTree);
            currentChoicesScrollPane.setPreferredSize(chooserScrollPane.getPreferredSize());
            JPanel panel3 = new JPanel();
            panel3.setLayout(new BorderLayout());
            panel3.add((Component)currentChoicesScrollPane, "Center");
            panel3.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Annotations to be Imported"), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
            panel3.add((Component)currentAnnotationsButtonPanel, "South");
            topPanel.add(panel3);
            mainPanel.add((Component)topPanel, "Center");
            JPanel okButtonPanel = new JPanel();
            JButton okButton = new JButton("OK");
            okButton.addActionListener(new OKAction());
            okButtonPanel.add(okButton);
            mainPanel.add((Component)okButtonPanel, "South");
            return mainPanel;
        }

        private void expandAll(JTree tree, TreePath parent, boolean expand) {
            TreeNode node = (TreeNode)parent.getLastPathComponent();
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    this.expandAll(tree, path, expand);
                }
            }
            if (expand) {
                tree.expandPath(parent);
            } else {
                tree.collapsePath(parent);
            }
        }

        protected JTree createAvailableAnnotationsTree() {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Available Annotations");
            this.createTreeNodes(root, AnnotationGui.this.annotationDescriptions);
            JTree tree = new JTree(root);
            tree.getSelectionModel().setSelectionMode(1);
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            return tree;
        }

        protected JTree createNodeSelectionTree() {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode("Annotations Categories");
            JTree tree = new JTree(root);
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
            this.expandAll(tree, new TreePath(root), true);
            return tree;
        }

        protected void createTreeNodes(DefaultMutableTreeNode root, AnnotationDescription[] descriptions) {
            if (descriptions == null || descriptions.length == 0) {
                return;
            }
            Set speciesInGraph = Semantics.getSpeciesInNetwork(AnnotationGui.this.network);
            DefaultMutableTreeNode branch = null;
            Vector<String> topLevelNamesList = new Vector<String>();
            for (int i = 0; i < descriptions.length; ++i) {
                String species = descriptions[i].getSpecies();
                if (!speciesInGraph.contains(species)) continue;
                topLevelNamesList.add(descriptions[i].getCurator() + ", " + descriptions[i].getType() + ", " + descriptions[i].getSpecies());
                branch = new DefaultMutableTreeNode(descriptions[i]);
                Annotation annotation = AnnotationGui.this.dataServer.getAnnotation(descriptions[i]);
                if (annotation == null) continue;
                int maxDepth = annotation.maxDepth();
                for (int level = 0; level < maxDepth; ++level) {
                    branch.add(new DefaultMutableTreeNode(new Integer(level + 1)));
                }
                root.add(branch);
            }
        }

        public class DeleteCreatedObjectsAction
        extends AbstractAction {
            DeleteCreatedObjectsAction() {
                super("");
            }

            public void actionPerformed(ActionEvent e) {
                AnnotationGui.this.deleteCreatedObjectsButton.setEnabled(false);
            }
        }

        public class DrawSharedEdgesAnnotationAction
        extends AbstractAction {
            DrawSharedEdgesAnnotationAction() {
                super("");
            }

            public void actionPerformed(ActionEvent e) {
                AnnotationGui.this.deleteCreatedObjectsButton.setEnabled(true);
            }
        }

        public class LayoutByAnnotationAction
        extends AbstractAction {
            LayoutByAnnotationAction() {
                super("");
            }

            public void actionPerformed(ActionEvent e) {
                AnnotationGui.this.deleteCreatedObjectsButton.setEnabled(true);
            }
        }

        public class OKAction
        extends AbstractAction {
            OKAction() {
                super("");
            }

            public void actionPerformed(ActionEvent e) {
                Gui.this.setVisible(false);
            }
        }

        class SelectNodesTreeSelectionListener
        implements TreeSelectionListener {
            SelectNodesTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AnnotationGui.this.currentAnnotationsTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                AnnotationGui.this.layoutByAnnotationButton.setEnabled(!node.isLeaf());
                AnnotationGui.this.addSharedAnnotationEdgesButton.setEnabled(!node.isLeaf());
                if (!node.isLeaf()) {
                    return;
                }
                CyAttributes nodeAttributes = Cytoscape.getNodeAttributes();
                Iterator nvi = AnnotationGui.this.networkView.getNodeViewsIterator();
                while (nvi.hasNext()) {
                    ((NodeView)nvi.next()).setSelected(false);
                }
                TreePath[] selectedPaths = AnnotationGui.this.currentAnnotationsTree.getSelectionPaths();
                HashMap selectionHash = this.extractAnnotationsFromSelection(selectedPaths);
                Iterator nvi2 = AnnotationGui.this.networkView.getNodeViewsIterator();
                block1: while (nvi2.hasNext()) {
                    NodeView nv = (NodeView)nvi2.next();
                    String nodeLabel = nv.getNode().getIdentifier();
                    if (nodeLabel == null) continue;
                    for (String name : selectionHash.keySet()) {
                        Vector categoryList = (Vector)selectionHash.get(name);
                        byte type = nodeAttributes.getType(name);
                        if (type == 4) {
                            String attributeValue = nodeAttributes.getStringAttribute(nodeLabel, name);
                            if (attributeValue == null || !categoryList.contains(attributeValue)) continue block1;
                            nv.setSelected(true);
                            continue block1;
                        }
                        if (type != -2) continue;
                        boolean hit = false;
                        List attributeList = nodeAttributes.getListAttribute(nodeLabel, name);
                        Iterator ali = attributeList.iterator();
                        while (ali.hasNext()) {
                            if (!categoryList.contains(ali.next())) continue;
                            nv.setSelected(true);
                            hit = true;
                            break;
                        }
                        if (!hit) continue;
                        continue block1;
                    }
                }
                AnnotationGui.this.networkView.redrawGraph(false, false);
            }

            protected HashMap extractAnnotationsFromSelection(TreePath[] paths) {
                HashMap<String, Vector> hash = new HashMap<String, Vector>();
                for (int i = 0; i < paths.length; ++i) {
                    Vector list;
                    String annotationName = paths[i].getPathComponent(1).toString();
                    String annotationValue = paths[i].getPathComponent(2).toString();
                    if (!hash.containsKey(annotationName)) {
                        list = new Vector();
                        hash.put(annotationName, list);
                    }
                    list = (Vector)hash.get(annotationName);
                    list.add(annotationValue);
                }
                return hash;
            }
        }

        class AddAnnotationTreeSelectionListener
        implements TreeSelectionListener {
            AddAnnotationTreeSelectionListener() {
            }

            public void valueChanged(TreeSelectionEvent e) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)AnnotationGui.this.availableAnnotationsTree.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (!node.isLeaf()) {
                    return;
                }
                AnnotationGui.this.annotationPath = AnnotationGui.this.availableAnnotationsTree.getSelectionPaths()[0];
                AnnotationGui.this.annotateNodesButton.setEnabled(true);
            }
        }
    }
}

