/*
 * Decompiled with CFR 0.152.
 */
package cytoscape.actions;

import cytoscape.CyNetwork;
import cytoscape.Cytoscape;
import cytoscape.data.Semantics;
import cytoscape.util.CytoscapeAction;
import cytoscape.util.FileUtil;
import giny.model.Node;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;

public class ListFromFileSelectionAction
extends CytoscapeAction {
    public ListFromFileSelectionAction() {
        super("From File...");
        this.setPreferredMenu("Select.Nodes");
    }

    public void actionPerformed(ActionEvent e) {
        boolean cancelSelectionAction = !this.selectFromFile();
        Cytoscape.getCurrentNetworkView().updateView();
    }

    private boolean selectFromFile() {
        String name;
        try {
            name = FileUtil.getFile("Load Gene Selection File", FileUtil.LOAD).toString();
        }
        catch (Exception exp) {
            return false;
        }
        CyNetwork network = Cytoscape.getCurrentNetwork();
        try {
            String s;
            FileReader fin = new FileReader(name);
            BufferedReader bin = new BufferedReader(fin);
            ArrayList<String> fileNodes = new ArrayList<String>();
            while ((s = bin.readLine()) != null) {
                String trimName = s.trim();
                if (trimName.length() <= 0) continue;
                fileNodes.add(trimName);
            }
            fin.close();
            List nodeList = network.nodesList();
            Node[] nodes = nodeList.toArray(new Node[0]);
            for (int i = 0; i < nodes.length; ++i) {
                Node node = nodes[i];
                boolean select = false;
                String canonicalName = node.getIdentifier();
                List synonyms = Semantics.getAllSynonyms(canonicalName, network);
                Iterator synI = synonyms.iterator();
                while (synI.hasNext()) {
                    if (!fileNodes.contains((String)synI.next())) continue;
                    select = true;
                    break;
                }
                if (!select) continue;
                network.setSelectedNodeState(node, true);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error Reading \"" + name + "\"", 0);
            return false;
        }
        return true;
    }
}

