/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io.game;

import org.biojava.bio.SmallAnnotation;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.game.ElementRecognizer;
import org.biojava.bio.seq.io.game.GAMEDbxrefPropHandler;
import org.biojava.bio.seq.io.game.GAMEFeatureCallbackItf;
import org.biojava.bio.seq.io.game.GAMEFeatureSetHandler;
import org.biojava.bio.seq.io.game.GAMEGenePropHandler;
import org.biojava.bio.seq.io.game.StAXFeatureHandler;
import org.biojava.bio.seq.io.game.StAXHandlerFactory;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.stax.StAXContentHandler;
import org.xml.sax.Attributes;

public class GAMEAnnotationHandler
extends StAXFeatureHandler
implements GAMEFeatureCallbackItf {
    public static final StAXHandlerFactory GAME_ANNOTATION_HANDLER_FACTORY = new StAXHandlerFactory(){

        public StAXContentHandler getHandler(StAXFeatureHandler staxenv) {
            return new GAMEAnnotationHandler(staxenv);
        }
    };
    private Location range = Location.empty;
    private StrandedFeature.Strand strand = StrandedFeature.UNKNOWN;

    GAMEAnnotationHandler(StAXFeatureHandler staxenv) {
        this.featureListener = staxenv.featureListener;
        this.setHandlerCharacteristics("annotation", true);
        super.addHandler(new ElementRecognizer.ByLocalName("gene"), GAMEGenePropHandler.GAME_GENE_PROP_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("feature_set"), GAMEFeatureSetHandler.GAME_FEATURESET_HANDLER_FACTORY);
        super.addHandler(new ElementRecognizer.ByLocalName("dbxref"), GAMEDbxrefPropHandler.GAME_DBXREF_PROP_HANDLER_FACTORY);
    }

    protected Feature.Template createTemplate() {
        StrandedFeature.Template gt = new StrandedFeature.Template();
        gt.type = "gene";
        gt.source = "";
        gt.location = Location.empty;
        gt.annotation = new SmallAnnotation();
        gt.strand = StrandedFeature.UNKNOWN;
        return gt;
    }

    public void reportFeature(Location loc) {
        this.range = this.range.union(loc);
    }

    public void reportStrand(StrandedFeature.Strand strand) {
        ((StrandedFeature.Template)this.featureTemplate).strand = strand;
    }

    public void startElementHandler(String nsURI, String localName, String qName, Attributes attrs) {
        String annotationId = attrs.getValue("id");
        if (annotationId != null) {
            try {
                this.featureTemplate.annotation.setProperty("annotation_id", annotationId);
            }
            catch (ChangeVetoException cae) {
                System.err.println("GAMEAnnotationHandler: veto exception caught.");
            }
        }
    }

    public void endElementHandler(String nsURI, String localName, String qName, StAXContentHandler handler) {
        if (this.range != Location.empty) {
            this.featureTemplate.location = new RangeLocation(this.range.getMin(), this.range.getMax());
        }
    }
}

