/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.mapper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.mskcc.dataservices.bio.AttributeBag;
import org.mskcc.dataservices.bio.ExternalReference;
import org.mskcc.dataservices.bio.Interaction;
import org.mskcc.dataservices.bio.Interactor;
import org.mskcc.dataservices.mapper.Mapper;
import org.mskcc.dataservices.schemas.psi.BibrefType;
import org.mskcc.dataservices.schemas.psi.CvType;
import org.mskcc.dataservices.schemas.psi.DbReferenceType;
import org.mskcc.dataservices.schemas.psi.Entry;
import org.mskcc.dataservices.schemas.psi.EntrySet;
import org.mskcc.dataservices.schemas.psi.ExperimentList;
import org.mskcc.dataservices.schemas.psi.ExperimentListItem;
import org.mskcc.dataservices.schemas.psi.ExperimentType;
import org.mskcc.dataservices.schemas.psi.InteractionElementType;
import org.mskcc.dataservices.schemas.psi.InteractionList;
import org.mskcc.dataservices.schemas.psi.InteractorList;
import org.mskcc.dataservices.schemas.psi.NamesType;
import org.mskcc.dataservices.schemas.psi.Organism;
import org.mskcc.dataservices.schemas.psi.ParticipantList;
import org.mskcc.dataservices.schemas.psi.ProteinInteractorType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantType;
import org.mskcc.dataservices.schemas.psi.ProteinParticipantTypeChoice;
import org.mskcc.dataservices.schemas.psi.RefType;
import org.mskcc.dataservices.schemas.psi.XrefType;

public class MapInteractionsToPsi
implements Mapper {
    private static final String EXP_AFFINITY_PRECIPITATION = "Affinity Precipitation";
    private static final String EXP_AFFINITY_CHROMOTOGRAPHY = "Affinity Chromatography";
    private static final String EXP_TWO_HYBRID = "Two Hybrid";
    private static final String EXP_PURIFIED_COMPLEX = "Purified Complex";
    private static final String PUB_MED_DB = "pubmed";
    private EntrySet entrySet;
    private ArrayList interactions;

    public MapInteractionsToPsi(ArrayList arrayList) {
        this.interactions = arrayList;
    }

    public void doMapping() {
        this.entrySet = new EntrySet();
        this.entrySet.setLevel(1);
        this.entrySet.setVersion(1);
        Entry entry = new Entry();
        InteractorList interactorList = this.getInteractorList();
        InteractionList interactionList = this.getInteractionList();
        entry.setInteractorList(interactorList);
        entry.setInteractionList(interactionList);
        this.entrySet.addEntry(entry);
    }

    public EntrySet getPsiXml() {
        return this.entrySet;
    }

    private InteractorList getInteractorList() {
        HashMap hashMap = this.getNonRedundantInteractors();
        InteractorList interactorList = new InteractorList();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            Interactor interactor = (Interactor)iterator.next();
            ProteinInteractorType proteinInteractorType = new ProteinInteractorType();
            this.setNameId(interactor, proteinInteractorType);
            this.setOrganism(interactor, proteinInteractorType);
            this.setSequence(interactor, proteinInteractorType);
            XrefType xrefType = this.createExternalRefs(interactor);
            if (xrefType != null) {
                proteinInteractorType.setXref(xrefType);
            }
            interactorList.addProteinInteractor(proteinInteractorType);
        }
        return interactorList;
    }

    private void setSequence(Interactor interactor, ProteinInteractorType proteinInteractorType) {
        String string = (String)interactor.getAttribute("SEQUENCE_DATA");
        if (string != null) {
            proteinInteractorType.setSequence(string);
        }
    }

    private void setNameId(Interactor interactor, ProteinInteractorType proteinInteractorType) {
        NamesType namesType = new NamesType();
        namesType.setShortLabel(interactor.getName());
        String string = (String)interactor.getAttribute("FULL_NAME");
        if (string != null) {
            namesType.setFullName(string);
        }
        proteinInteractorType.setNames(namesType);
        proteinInteractorType.setId(interactor.getName());
    }

    private void setOrganism(Interactor interactor, ProteinInteractorType proteinInteractorType) {
        String string;
        Organism organism = new Organism();
        String string2 = (String)interactor.getAttribute("ORGANISM_NCBI_TAXON_ID");
        if (string2 != null) {
            int n = Integer.parseInt(string2);
            organism.setNcbiTaxId(n);
        }
        NamesType namesType = new NamesType();
        String string3 = (String)interactor.getAttribute("ORGANISM_COMMON_NAME");
        if (string3 != null) {
            namesType.setShortLabel(string3);
        }
        if ((string = (String)interactor.getAttribute("ORGANISM_SPECIES")) != null) {
            namesType.setFullName(string);
        }
        organism.setNames(namesType);
        if (organism.isValid()) {
            proteinInteractorType.setOrganism(organism);
        }
    }

    private XrefType createExternalRefs(AttributeBag attributeBag) {
        HashSet<String> hashSet = new HashSet<String>();
        ExternalReference[] externalReferenceArray = attributeBag.getExternalRefs();
        XrefType xrefType = new XrefType();
        if (externalReferenceArray != null && externalReferenceArray.length > 0) {
            this.createPrimaryKey(externalReferenceArray[0], xrefType);
            if (externalReferenceArray.length > 1) {
                for (int i = 1; i < externalReferenceArray.length; ++i) {
                    String string = this.generateXRefKey(externalReferenceArray[i]);
                    if (hashSet.contains(string)) continue;
                    this.createSecondaryKey(externalReferenceArray[i], xrefType);
                    hashSet.add(string);
                }
            }
        }
        if (xrefType.getPrimaryRef() != null) {
            return xrefType;
        }
        return null;
    }

    private String generateXRefKey(ExternalReference externalReference) {
        String string = externalReference.getDatabase() + "." + externalReference.getId();
        return string;
    }

    private void createPrimaryKey(ExternalReference externalReference, XrefType xrefType) {
        DbReferenceType dbReferenceType = new DbReferenceType();
        dbReferenceType.setDb(externalReference.getDatabase());
        dbReferenceType.setId(externalReference.getId());
        xrefType.setPrimaryRef(dbReferenceType);
    }

    private void createSecondaryKey(ExternalReference externalReference, XrefType xrefType) {
        DbReferenceType dbReferenceType = new DbReferenceType();
        dbReferenceType.setDb(externalReference.getDatabase());
        dbReferenceType.setId(externalReference.getId());
        xrefType.addSecondaryRef(dbReferenceType);
    }

    private HashMap getNonRedundantInteractors() {
        HashMap hashMap = new HashMap();
        for (int i = 0; i < this.interactions.size(); ++i) {
            Interaction interaction = (Interaction)this.interactions.get(i);
            ArrayList arrayList = interaction.getInteractors();
            for (int j = 0; j < arrayList.size(); ++j) {
                Interactor interactor = (Interactor)arrayList.get(j);
                this.addToHashMap(interactor, hashMap);
            }
        }
        return hashMap;
    }

    private void addToHashMap(Interactor interactor, HashMap hashMap) {
        String string = interactor.getName();
        if (!hashMap.containsKey(string)) {
            hashMap.put(string, interactor);
        }
    }

    private InteractionList getInteractionList() {
        InteractionList interactionList = new InteractionList();
        for (int i = 0; i < this.interactions.size(); ++i) {
            InteractionElementType interactionElementType = new InteractionElementType();
            Interaction interaction = (Interaction)this.interactions.get(i);
            ExperimentList experimentList = this.getExperimentDescription(interaction, i);
            interactionElementType.setExperimentList(experimentList);
            ParticipantList participantList = this.getParticipantList(interaction);
            interactionElementType.setParticipantList(participantList);
            interactionList.addInteraction(interactionElementType);
            XrefType xrefType = this.createExternalRefs(interaction);
            if (xrefType == null) continue;
            interactionElementType.setXref(xrefType);
        }
        return interactionList;
    }

    private ExperimentList getExperimentDescription(Interaction interaction, int n) {
        ExperimentList experimentList = new ExperimentList();
        ExperimentListItem experimentListItem = new ExperimentListItem();
        ExperimentType experimentType = new ExperimentType();
        experimentListItem.setExperimentDescription(experimentType);
        experimentType.setId("exp" + n);
        BibrefType bibrefType = null;
        Object object = interaction.getAttribute("PUB_MED_ID");
        if (object != null && object instanceof String) {
            bibrefType = this.createBibRef(PUB_MED_DB, (String)object);
            experimentType.setBibref(bibrefType);
        }
        CvType cvType = this.getInteractionDetection(interaction);
        experimentType.setInteractionDetection(cvType);
        experimentList.addExperimentListItem(experimentListItem);
        return experimentList;
    }

    private BibrefType createBibRef(String string, String string2) {
        XrefType xrefType = this.createXRef(string, string2);
        BibrefType bibrefType = new BibrefType();
        bibrefType.setXref(xrefType);
        return bibrefType;
    }

    private XrefType createXRef(String string, String string2) {
        XrefType xrefType = new XrefType();
        DbReferenceType dbReferenceType = new DbReferenceType();
        dbReferenceType.setDb(string);
        dbReferenceType.setId(string2);
        xrefType.setPrimaryRef(dbReferenceType);
        return xrefType;
    }

    private CvType getInteractionDetection(Interaction interaction) {
        CvType cvType = new CvType();
        String string = null;
        try {
            string = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_NAME");
        }
        catch (ClassCastException classCastException) {
            string = null;
        }
        if (string == null) {
            string = "Not Specified";
        }
        String string2 = null;
        try {
            string2 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_ID");
        }
        catch (ClassCastException classCastException) {
            string2 = null;
        }
        if (string2 == null) {
            if (string.equals(EXP_AFFINITY_PRECIPITATION) || string.equals(EXP_AFFINITY_CHROMOTOGRAPHY)) {
                string = "affinity chromatography technologies";
                string2 = "MI:0004";
            } else if (string.equals(EXP_TWO_HYBRID)) {
                string = "classical two hybrid";
                string2 = "MI:0018";
            } else if (string.equals(EXP_PURIFIED_COMPLEX)) {
                string = "copurification";
                string2 = "MI:0025";
            } else {
                string2 = "Not Specified";
            }
        }
        NamesType namesType = this.createName(string, null);
        cvType.setNames(namesType);
        String string3 = null;
        try {
            string3 = (String)interaction.getAttribute("EXPERIMENTAL_SYSTEM_XREF_DB");
        }
        catch (ClassCastException classCastException) {
            string3 = null;
        }
        if (string3 == null) {
            string3 = "PSI-MI";
        }
        XrefType xrefType = this.createXRef(string3, string2);
        cvType.setXref(xrefType);
        return cvType;
    }

    private NamesType createName(String string, String string2) {
        NamesType namesType = new NamesType();
        namesType.setShortLabel(string);
        if (string2 != null) {
            namesType.setFullName(string2);
        }
        return namesType;
    }

    private ParticipantList getParticipantList(Interaction interaction) {
        ParticipantList participantList = new ParticipantList();
        ArrayList arrayList = interaction.getInteractors();
        for (int i = 0; i < arrayList.size(); ++i) {
            Interactor interactor = (Interactor)arrayList.get(i);
            String string = interactor.getName();
            ProteinParticipantType proteinParticipantType = this.createParticipant(string);
            participantList.addProteinParticipant(proteinParticipantType);
        }
        return participantList;
    }

    private ProteinParticipantType createParticipant(String string) {
        ProteinParticipantType proteinParticipantType = new ProteinParticipantType();
        ProteinParticipantTypeChoice proteinParticipantTypeChoice = new ProteinParticipantTypeChoice();
        RefType refType = new RefType();
        refType.setRef(string);
        proteinParticipantTypeChoice.setProteinInteractorRef(refType);
        proteinParticipantType.setProteinParticipantTypeChoice(proteinParticipantTypeChoice);
        return proteinParticipantType;
    }
}

