/*
 * Decompiled with CFR 0.152.
 */
package org.mskcc.dataservices.live.state;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.mskcc.dataservices.bio.Matrix;
import org.mskcc.dataservices.bio.StateInformation;
import org.mskcc.dataservices.core.DataServiceException;
import org.mskcc.dataservices.live.DataServiceBase;
import org.mskcc.dataservices.live.state.NameValuePair;
import org.mskcc.dataservices.services.ReadStateInformation;
import org.mskcc.dataservices.util.ContentReader;
import org.mskcc.dataservices.util.StringParser;

public class ReadSoftFromFileOrWeb
extends DataServiceBase
implements ReadStateInformation {
    private static final String CARET_CHAR = "^";
    private static final String BANG_CHAR = "!";
    private static final String HASH_CHAR = "#";
    private StateInformation stateInfo = new StateInformation();

    public StateInformation getStateInformation(String string) throws DataServiceException {
        try {
            ContentReader contentReader = new ContentReader();
            String string2 = contentReader.retrieveContent(string);
            this.parseFile(string2);
        }
        catch (IOException iOException) {
            String string3 = "Error Occurred while parsing the SOFT Data File.  Please try again.";
            throw new DataServiceException(iOException, string3);
        }
        return this.stateInfo;
    }

    public void parseFile(String string) throws IOException, DataServiceException {
        ArrayList arrayList = StringParser.createArrayList(string);
        ArrayList arrayList2 = this.findEntities(arrayList);
        this.extractAllEntities(arrayList2, arrayList, this.stateInfo);
        this.validateStateInformation(this.stateInfo);
    }

    private void validateStateInformation(StateInformation stateInformation) throws DataServiceException {
        if (stateInformation.getMatrices().size() == 0) {
            throw new DataServiceException("This File does not contain any SOFT entities, and is probably not a SOFT File.  Please check the file or URL, and try again.");
        }
    }

    private ArrayList findEntities(ArrayList arrayList) {
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (!string.startsWith(CARET_CHAR)) continue;
            arrayList2.add(new Integer(i));
        }
        return arrayList2;
    }

    private void extractAllEntities(ArrayList arrayList, ArrayList arrayList2, StateInformation stateInformation) throws DataServiceException {
        for (int i = 0; i < arrayList.size(); ++i) {
            int n;
            Integer n2 = (Integer)arrayList.get(i);
            int n3 = n2;
            if (i < arrayList.size() - 1) {
                Integer n4 = (Integer)arrayList.get(i + 1);
                n = n4;
            } else {
                n = arrayList2.size();
            }
            this.parseEntityData(stateInformation, arrayList2, n3, --n);
        }
    }

    private void parseEntityData(StateInformation stateInformation, ArrayList arrayList, int n, int n2) throws DataServiceException {
        try {
            String string;
            ArrayList arrayList2 = new ArrayList();
            HashMap hashMap = new HashMap();
            String string2 = string = (String)arrayList.get(n);
            int n3 = this.extractMetaData(arrayList, n + 1, n2, arrayList2, hashMap);
            Matrix matrix = null;
            if (n3 < n2) {
                int n4;
                ArrayList arrayList3 = this.extractDataHeaders(arrayList, n3);
                int n5 = this.findIdColumn(arrayList3);
                ArrayList<String> arrayList4 = new ArrayList<String>();
                for (n4 = n3 + 1; n4 <= n2; ++n4) {
                    String string3 = (String)arrayList.get(n4);
                    arrayList4.add(string3);
                }
                n4 = StringParser.countColumns(arrayList4);
                matrix = new Matrix(arrayList4.size(), n4);
                matrix.setHeaderNames(arrayList3);
                matrix.setHeaderDescriptions(hashMap);
                matrix.setIdColumn(n5);
                StringParser.parseIntoMatrix(matrix, arrayList4);
            } else {
                matrix = new Matrix(0, 0);
            }
            this.addAttributes(matrix, arrayList2);
            matrix.setTitle(string2);
            stateInformation.addMatrix(matrix);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new DataServiceException("This File does not contain any SOFT entities, and is probably not a SOFT File.  Please check the file or URL, and try again.");
        }
    }

    private int findIdColumn(ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            if (!string.equals("IDENTIFIER")) continue;
            return i;
        }
        return -1;
    }

    private int extractMetaData(ArrayList arrayList, int n, int n2, ArrayList arrayList2, HashMap hashMap) {
        int n3;
        for (n3 = n; n3 <= n2; ++n3) {
            NameValuePair nameValuePair;
            String string = (String)arrayList.get(n3);
            if (string.startsWith(BANG_CHAR)) {
                nameValuePair = this.extractNameValuePair(string);
                arrayList2.add(nameValuePair);
                continue;
            }
            if (!string.startsWith(HASH_CHAR)) break;
            nameValuePair = this.extractNameValuePair(string);
            hashMap.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return n3;
    }

    private ArrayList extractDataHeaders(ArrayList arrayList, int n) {
        ArrayList<String> arrayList2 = new ArrayList<String>();
        String string = (String)arrayList.get(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = (String)stringTokenizer.nextElement();
            arrayList2.add(string2);
        }
        return arrayList2;
    }

    private void addAttributes(Matrix matrix, ArrayList arrayList) {
        for (int i = 0; i < arrayList.size(); ++i) {
            NameValuePair nameValuePair = (NameValuePair)arrayList.get(i);
            matrix.addAttribute(nameValuePair.getName(), nameValuePair.getValue());
        }
    }

    private NameValuePair extractNameValuePair(String string) {
        String string2 = null;
        String string3 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        string2 = (String)stringTokenizer.nextElement();
        if (stringTokenizer.hasMoreElements()) {
            string3 = (String)stringTokenizer.nextElement();
        }
        NameValuePair nameValuePair = new NameValuePair(string2, string3);
        return nameValuePair;
    }
}

